/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.internal.avro.implementation.schema.complex;

import com.azure.storage.internal.avro.implementation.AvroParserState;
import com.azure.storage.internal.avro.implementation.schema.AvroCompositeSchema;
import com.azure.storage.internal.avro.implementation.schema.AvroSchema;
import com.azure.storage.internal.avro.implementation.schema.AvroType;
import com.azure.storage.internal.avro.implementation.schema.primitive.AvroLongSchema;
import com.azure.storage.internal.avro.implementation.schema.primitive.AvroStringSchema;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;

public class AvroMapSchema
extends AvroCompositeSchema {
    private final AvroType valueType;
    private Long blockCount;
    private String key;
    private Map<String, Object> ret = new LinkedHashMap<String, Object>();

    public AvroMapSchema(AvroType valueType, AvroParserState state, Consumer<Object> onResult) {
        super(state, onResult);
        this.valueType = valueType;
    }

    @Override
    public void pushToStack() {
        this.state.pushToStack(this);
        AvroLongSchema blockSchema = new AvroLongSchema(this.state, this::onBlockCount);
        blockSchema.pushToStack();
    }

    private void onBlockCount(Object blockCount) {
        AvroMapSchema.checkType("blockCount", blockCount, Long.class);
        Long bc = (Long)blockCount;
        if (bc == 0L) {
            this.result = this.ret;
            this.done = true;
        } else if (bc > 0L) {
            this.blockCount = bc;
            AvroStringSchema keySchema = new AvroStringSchema(this.state, this::onKey);
            keySchema.pushToStack();
        } else {
            this.blockCount = -bc.longValue();
            AvroLongSchema byteCountSchema = new AvroLongSchema(this.state, this::onByteCount);
            byteCountSchema.pushToStack();
        }
    }

    private void onByteCount(Object byteCount) {
        AvroStringSchema keySchema = new AvroStringSchema(this.state, this::onKey);
        keySchema.pushToStack();
    }

    private void onKey(Object key) {
        AvroMapSchema.checkType("key", key, String.class);
        this.key = (String)key;
        AvroSchema valueSchema = AvroMapSchema.getSchema(this.valueType, this.state, this::onValue);
        valueSchema.pushToStack();
    }

    private void onValue(Object value) {
        this.ret.put(this.key, value);
        Long l = this.blockCount;
        Long l2 = this.blockCount = Long.valueOf(this.blockCount - 1L);
        if (this.blockCount == 0L) {
            AvroLongSchema blockCountSchema = new AvroLongSchema(this.state, this::onBlockCount);
            blockCountSchema.pushToStack();
        } else {
            AvroStringSchema keySchema = new AvroStringSchema(this.state, this::onKey);
            keySchema.pushToStack();
        }
    }
}

