/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.typecomputer.base;

import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.om.exceptions.IncompatibleTypeException;
import org.apache.asterix.om.typecomputer.impl.TypeComputeUtils;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;

public class TypeCastUtils {
    private TypeCastUtils() {
    }

    public static boolean setRequiredAndInputTypes(AbstractFunctionCallExpression expr, IAType requiredType, IAType inputType) throws CompilationException {
        return TypeCastUtils.setRequiredAndInputTypes(expr, requiredType, inputType, true);
    }

    public static boolean setRequiredAndInputTypes(AbstractFunctionCallExpression expr, IAType requiredType, IAType inputType, boolean failIfTypeMismatch) throws CompilationException {
        boolean changed = false;
        Object[] opaqueParameters = expr.getOpaqueParameters();
        if (opaqueParameters == null) {
            ATypeTag actualTypeTag;
            ATypeTag requiredTypeTag;
            opaqueParameters = new Object[]{requiredType, inputType};
            if (failIfTypeMismatch && !ATypeHierarchy.isCompatible(requiredTypeTag = requiredType.getTypeTag(), actualTypeTag = TypeComputeUtils.getActualType(inputType).getTypeTag())) {
                FunctionIdentifier funcId = expr.getFunctionIdentifier();
                throw new IncompatibleTypeException(expr.getSourceLocation(), funcId, actualTypeTag, requiredTypeTag);
            }
            expr.setOpaqueParameters(opaqueParameters);
            changed = true;
        }
        return changed;
    }

    public static void resetRequiredAndInputTypes(AbstractFunctionCallExpression expr) {
        expr.setOpaqueParameters(null);
    }

    public static IAType getRequiredType(AbstractFunctionCallExpression expr) {
        Object[] type = expr.getOpaqueParameters();
        if (type != null) {
            IAType returnType = (IAType)type[0];
            return returnType;
        }
        return null;
    }
}

