/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common.dataflow;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameTupleAppender;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IDestroyable;
import org.apache.hyracks.api.dataflow.IIntrospectingOperator;
import org.apache.hyracks.api.dataflow.value.IMissingWriter;
import org.apache.hyracks.api.dataflow.value.IMissingWriterFactory;
import org.apache.hyracks.api.dataflow.value.ITuplePartitioner;
import org.apache.hyracks.api.dataflow.value.ITuplePartitionerFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.profiling.IOperatorStats;
import org.apache.hyracks.api.job.profiling.NoOpOperatorStats;
import org.apache.hyracks.api.util.CleanupUtils;
import org.apache.hyracks.api.util.ExceptionUtils;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.PermutingFrameTupleReference;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryInputUnaryOutputOperatorNodePushable;
import org.apache.hyracks.storage.am.common.api.IIndexDataflowHelper;
import org.apache.hyracks.storage.am.common.api.ILSMIndexCursor;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.api.ITupleFilter;
import org.apache.hyracks.storage.am.common.api.ITupleFilterFactory;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.impls.IndexAccessParameters;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.common.tuples.ReferenceFrameTupleReference;
import org.apache.hyracks.storage.am.common.util.ResourceReleaseUtils;
import org.apache.hyracks.storage.common.IIndex;
import org.apache.hyracks.storage.common.IIndexAccessParameters;
import org.apache.hyracks.storage.common.IIndexAccessor;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.projection.ITupleProjector;
import org.apache.hyracks.storage.common.projection.ITupleProjectorFactory;
import org.apache.hyracks.util.IThreadStatsCollector;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class IndexSearchOperatorNodePushable
extends AbstractUnaryInputUnaryOutputOperatorNodePushable
implements IIntrospectingOperator {
    static final Logger LOGGER = LogManager.getLogger();
    protected final IHyracksTaskContext ctx;
    protected FrameTupleAccessor accessor;
    protected FrameTupleAppender appender;
    protected ArrayTupleBuilder tb;
    protected DataOutput dos;
    protected ISearchPredicate searchPred;
    protected final IIndexDataflowHelper[] indexHelpers;
    protected final boolean[] indexHelpersOpen;
    protected IIndex[] indexes;
    protected IIndexAccessor[] indexAccessors;
    protected IIndexCursor[] cursors;
    protected final RecordDescriptor inputRecDesc;
    protected final boolean retainInput;
    protected FrameTupleReference frameTuple;
    protected final boolean retainMissing;
    protected ArrayTupleBuilder nonMatchTupleBuild;
    protected IMissingWriter nonMatchWriter;
    protected final int[] minFilterFieldIndexes;
    protected final int[] maxFilterFieldIndexes;
    protected PermutingFrameTupleReference minFilterKey;
    protected PermutingFrameTupleReference maxFilterKey;
    protected final boolean appendIndexFilter;
    protected ArrayTupleBuilder nonFilterTupleBuild;
    protected IMissingWriter nonFilterWriter;
    protected final ISearchOperationCallbackFactory searchCallbackFactory;
    protected boolean failed = false;
    protected IOperatorStats stats;
    protected boolean appendSearchCallbackProceedResult;
    protected byte[] searchCallbackProceedResultFalseValue;
    protected byte[] searchCallbackProceedResultTrueValue;
    protected final ITupleFilterFactory tupleFilterFactory;
    protected ReferenceFrameTupleReference referenceFilterTuple;
    protected ITupleFilter tupleFilter;
    protected final long outputLimit;
    protected long outputCount = 0L;
    protected boolean finished;
    protected final ITupleProjector tupleProjector;
    protected final ITuplePartitioner tuplePartitioner;
    protected final int[] partitions;
    private final Int2IntMap storagePartitionId2Index = new Int2IntOpenHashMap();

    public IndexSearchOperatorNodePushable(IHyracksTaskContext ctx, RecordDescriptor inputRecDesc, int partition, int[] minFilterFieldIndexes, int[] maxFilterFieldIndexes, IIndexDataflowHelperFactory indexHelperFactory, boolean retainInput, boolean retainMissing, IMissingWriterFactory nonMatchWriterFactory, ISearchOperationCallbackFactory searchCallbackFactory, boolean appendIndexFilter, IMissingWriterFactory nonFilterWriterFactory, ITupleFilterFactory tupleFilterFactory, long outputLimit, boolean appendSearchCallbackProceedResult, byte[] searchCallbackProceedResultFalseValue, byte[] searchCallbackProceedResultTrueValue, ITupleProjectorFactory projectorFactory, ITuplePartitionerFactory tuplePartitionerFactory, int[][] partitionsMap) throws HyracksDataException {
        int i;
        int[] nArray;
        this.ctx = ctx;
        this.appender = new FrameTupleAppender((IFrame)new VSizeFrame((IHyracksFrameMgrContext)ctx), true);
        if (partitionsMap != null) {
            nArray = partitionsMap[partition];
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = partition;
        }
        this.partitions = nArray;
        for (i = 0; i < this.partitions.length; ++i) {
            this.storagePartitionId2Index.put(this.partitions[i], i);
        }
        this.indexHelpers = new IIndexDataflowHelper[this.partitions.length];
        this.indexHelpersOpen = new boolean[this.partitions.length];
        this.indexes = new IIndex[this.partitions.length];
        this.indexAccessors = new IIndexAccessor[this.partitions.length];
        this.cursors = new IIndexCursor[this.partitions.length];
        for (i = 0; i < this.partitions.length; ++i) {
            this.indexHelpers[i] = indexHelperFactory.create(ctx.getJobletContext().getServiceContext(), this.partitions[i]);
        }
        this.retainInput = retainInput;
        this.retainMissing = retainMissing;
        this.appendIndexFilter = appendIndexFilter;
        if (this.retainMissing) {
            this.nonMatchWriter = nonMatchWriterFactory.createMissingWriter();
        }
        if (this.appendIndexFilter) {
            this.nonFilterWriter = nonFilterWriterFactory.createMissingWriter();
        }
        this.inputRecDesc = inputRecDesc;
        this.searchCallbackFactory = searchCallbackFactory;
        this.minFilterFieldIndexes = minFilterFieldIndexes;
        this.maxFilterFieldIndexes = maxFilterFieldIndexes;
        if (minFilterFieldIndexes != null && minFilterFieldIndexes.length > 0) {
            this.minFilterKey = new PermutingFrameTupleReference();
            this.minFilterKey.setFieldPermutation(minFilterFieldIndexes);
        }
        if (maxFilterFieldIndexes != null && maxFilterFieldIndexes.length > 0) {
            this.maxFilterKey = new PermutingFrameTupleReference();
            this.maxFilterKey.setFieldPermutation(maxFilterFieldIndexes);
        }
        this.appendSearchCallbackProceedResult = appendSearchCallbackProceedResult;
        this.searchCallbackProceedResultFalseValue = searchCallbackProceedResultFalseValue;
        this.searchCallbackProceedResultTrueValue = searchCallbackProceedResultTrueValue;
        this.tupleFilterFactory = tupleFilterFactory;
        this.outputLimit = outputLimit;
        this.stats = new NoOpOperatorStats();
        if (this.tupleFilterFactory != null && this.retainMissing) {
            throw new IllegalStateException("RetainMissing with tuple filter is not supported");
        }
        this.tupleProjector = projectorFactory.createTupleProjector(ctx);
        this.tuplePartitioner = tuplePartitionerFactory == null ? null : tuplePartitionerFactory.createPartitioner(ctx);
    }

    protected abstract ISearchPredicate createSearchPredicate(IIndex var1);

    protected abstract void resetSearchPredicate(int var1);

    protected abstract void addAdditionalIndexAccessorParams(IIndexAccessParameters var1) throws HyracksDataException;

    protected IIndexCursor createCursor(IIndex idx, IIndexAccessor idxAccessor) throws HyracksDataException {
        return idxAccessor.createSearchCursor(false);
    }

    protected abstract int getFieldCount(IIndex var1);

    public void open() throws HyracksDataException {
        this.writer.open();
        ISearchOperationCallback[] searchCallbacks = new ISearchOperationCallback[this.partitions.length];
        IndexAccessParameters[] iaps = new IndexAccessParameters[this.partitions.length];
        for (int i = 0; i < this.partitions.length; ++i) {
            this.indexHelpersOpen[i] = true;
            this.indexHelpers[i].open();
            this.indexes[i] = this.indexHelpers[i].getIndexInstance();
            searchCallbacks[i] = this.searchCallbackFactory.createSearchOperationCallback(this.indexHelpers[i].getResource().getId(), this.ctx, null);
            iaps[i] = new IndexAccessParameters(NoOpOperationCallback.INSTANCE, searchCallbacks[i]);
            this.addAdditionalIndexAccessorParams(iaps[i]);
            this.indexAccessors[i] = this.indexes[i].createAccessor((IIndexAccessParameters)iaps[i]);
            this.cursors[i] = this.createCursor(this.indexes[i], this.indexAccessors[i]);
        }
        this.subscribeForStats(this.indexes[0]);
        this.accessor = new FrameTupleAccessor(this.inputRecDesc);
        if (this.retainMissing) {
            int fieldCount = this.getFieldCount(this.indexes[0]);
            int finalFieldCount = this.appendSearchCallbackProceedResult ? fieldCount + 1 : fieldCount;
            this.nonMatchTupleBuild = new ArrayTupleBuilder(finalFieldCount);
            IndexSearchOperatorNodePushable.buildMissingTuple(fieldCount, this.nonMatchTupleBuild, this.nonMatchWriter);
            if (this.appendSearchCallbackProceedResult) {
                this.writeSearchCallbackProceedResult(this.nonMatchTupleBuild, true);
            }
        } else {
            this.nonMatchTupleBuild = null;
        }
        if (this.appendIndexFilter) {
            int numIndexFilterFields = this.indexes[0].getNumOfFilterFields();
            this.nonFilterTupleBuild = new ArrayTupleBuilder(numIndexFilterFields);
            IndexSearchOperatorNodePushable.buildMissingTuple(numIndexFilterFields, this.nonFilterTupleBuild, this.nonFilterWriter);
        }
        if (this.tupleFilterFactory != null) {
            this.tupleFilter = this.tupleFilterFactory.createTupleFilter(this.ctx);
            this.referenceFilterTuple = new ReferenceFrameTupleReference();
        }
        this.finished = false;
        this.outputCount = 0L;
        try {
            this.searchPred = this.createSearchPredicate(this.indexes[0]);
            this.tb = new ArrayTupleBuilder(this.recordDesc.getFieldCount());
            this.dos = this.tb.getDataOutput();
            if (this.retainInput) {
                this.frameTuple = new FrameTupleReference();
            }
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    protected void writeSearchResults(int tupleIndex, IIndexCursor cursor) throws Exception {
        long matchingTupleCount = 0L;
        while (cursor.hasNext()) {
            cursor.next();
            ++matchingTupleCount;
            ITupleReference tuple = cursor.getTuple();
            this.tb.reset();
            if (this.retainInput) {
                this.frameTuple.reset((IFrameTupleAccessor)this.accessor, tupleIndex);
                for (int i = 0; i < this.frameTuple.getFieldCount(); ++i) {
                    this.dos.write(this.frameTuple.getFieldData(i), this.frameTuple.getFieldStart(i), this.frameTuple.getFieldLength(i));
                    this.tb.addFieldEndOffset();
                }
            }
            if ((tuple = this.writeTupleToOutput(tuple)) == null) continue;
            if (this.tupleFilter != null) {
                this.referenceFilterTuple.reset(tuple);
                if (!this.tupleFilter.accept(this.referenceFilterTuple)) continue;
            }
            if (this.appendSearchCallbackProceedResult) {
                this.writeSearchCallbackProceedResult(this.tb, ((ILSMIndexCursor)cursor).getSearchOperationCallbackProceedResult());
            }
            if (this.appendIndexFilter) {
                this.writeFilterTupleToOutput(((ILSMIndexCursor)cursor).getFilterMinTuple());
                this.writeFilterTupleToOutput(((ILSMIndexCursor)cursor).getFilterMaxTuple());
            }
            FrameUtils.appendToWriter((IFrameWriter)this.writer, (IFrameTupleAppender)this.appender, (int[])this.tb.getFieldEndOffsets(), (byte[])this.tb.getByteArray(), (int)0, (int)this.tb.getSize());
            if (this.outputLimit < 0L || ++this.outputCount < this.outputLimit) continue;
            this.finished = true;
            break;
        }
        this.stats.getInputTupleCounter().update(matchingTupleCount);
        if (matchingTupleCount == 0L && this.retainInput && this.retainMissing) {
            FrameUtils.appendConcatToWriter((IFrameWriter)this.writer, (IFrameTupleAppender)this.appender, (IFrameTupleAccessor)this.accessor, (int)tupleIndex, (int[])this.nonMatchTupleBuild.getFieldEndOffsets(), (byte[])this.nonMatchTupleBuild.getByteArray(), (int)0, (int)this.nonMatchTupleBuild.getSize());
        }
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.accessor.reset(buffer);
        int tupleCount = this.accessor.getTupleCount();
        try {
            if (this.tuplePartitioner != null) {
                this.searchPartition(tupleCount);
            } else {
                this.searchAllPartitions(tupleCount);
            }
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public void flush() throws HyracksDataException {
        this.appender.flush(this.writer);
    }

    public void close() throws HyracksDataException {
        Throwable failure = this.flushFrame();
        failure = this.releaseResources(failure);
        if ((failure = CleanupUtils.close((IFrameWriter)this.writer, (Throwable)failure)) != null) {
            throw HyracksDataException.create((Throwable)failure);
        }
    }

    private Throwable flushFrame() {
        Throwable failure = null;
        if (!this.failed) {
            try {
                if (this.appender.getTupleCount() > 0) {
                    this.appender.write(this.writer, true);
                }
                this.stats.getPageReads().update(this.ctx.getThreadStats().getPinnedPagesCount());
                this.stats.coldReadCounter().update(this.ctx.getThreadStats().getColdReadCount());
            }
            catch (Throwable th) {
                failure = th;
            }
            if (failure != null) {
                try {
                    this.writer.fail();
                }
                catch (Throwable th) {
                    failure = ExceptionUtils.suppress((Throwable)failure, (Throwable)th);
                }
            }
        }
        return failure;
    }

    private Throwable releaseResources(Throwable failure) {
        for (int i = 0; i < this.indexes.length; ++i) {
            try {
                if (this.indexes[i] != null) {
                    failure = ResourceReleaseUtils.close(this.cursors[i], failure);
                    failure = CleanupUtils.destroy((Throwable)failure, (IDestroyable[])new IDestroyable[]{this.cursors[i], this.indexAccessors[i]});
                    failure = ResourceReleaseUtils.close(this.indexHelpers[i], failure);
                    continue;
                }
                if (!this.indexHelpersOpen[i]) continue;
                failure = ResourceReleaseUtils.close(this.indexHelpers[i], failure);
                continue;
            }
            catch (Throwable th) {
                failure = ExceptionUtils.suppress((Throwable)failure, (Throwable)th);
            }
        }
        return failure;
    }

    public void fail() throws HyracksDataException {
        this.failed = true;
        this.writer.fail();
    }

    private void subscribeForStats(IIndex index) {
        if (index.getBufferCache() instanceof IThreadStatsCollector) {
            this.ctx.subscribeThreadToStats((IThreadStatsCollector)index.getBufferCache());
        }
    }

    protected ITupleReference writeTupleToOutput(ITupleReference tuple) throws IOException {
        return this.tupleProjector.project(tuple, this.dos, this.tb);
    }

    private void writeSearchCallbackProceedResult(ArrayTupleBuilder atb, boolean searchCallbackProceedResult) throws HyracksDataException {
        if (!searchCallbackProceedResult) {
            atb.addField(this.searchCallbackProceedResultFalseValue, 0, this.searchCallbackProceedResultFalseValue.length);
        } else {
            atb.addField(this.searchCallbackProceedResultTrueValue, 0, this.searchCallbackProceedResultTrueValue.length);
        }
    }

    private void writeFilterTupleToOutput(ITupleReference tuple) throws IOException {
        if (tuple != null) {
            this.writeTupleToOutput(tuple);
        } else {
            int[] offsets = this.nonFilterTupleBuild.getFieldEndOffsets();
            for (int i = 0; i < offsets.length; ++i) {
                int start = i > 0 ? offsets[i - 1] : 0;
                this.tb.addField(this.nonFilterTupleBuild.getByteArray(), start, offsets[i]);
            }
        }
    }

    private static void buildMissingTuple(int numFields, ArrayTupleBuilder nullTuple, IMissingWriter nonMatchWriter) {
        DataOutput out = nullTuple.getDataOutput();
        for (int i = 0; i < numFields; ++i) {
            try {
                nonMatchWriter.writeMissing(out);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARN, e.getMessage(), (Throwable)e);
            }
            nullTuple.addFieldEndOffset();
        }
    }

    public String getDisplayName() {
        return "Index Search";
    }

    public void setOperatorStats(IOperatorStats stats) {
        this.stats = stats;
    }

    private void searchPartition(int tupleCount) throws Exception {
        for (int i = 0; i < tupleCount && !this.finished; ++i) {
            int storagePartition = this.tuplePartitioner.partition((IFrameTupleAccessor)this.accessor, i);
            int pIdx = this.storagePartitionId2Index.get(storagePartition);
            this.resetSearchPredicate(i);
            this.cursors[pIdx].close();
            this.indexAccessors[pIdx].search(this.cursors[pIdx], this.searchPred);
            this.writeSearchResults(i, this.cursors[pIdx]);
        }
    }

    private void searchAllPartitions(int tupleCount) throws Exception {
        for (int p = 0; p < this.partitions.length; ++p) {
            for (int i = 0; i < tupleCount && !this.finished; ++i) {
                this.resetSearchPredicate(i);
                this.cursors[p].close();
                this.indexAccessors[p].search(this.cursors[p], this.searchPred);
                this.writeSearchResults(i, this.cursors[p]);
            }
        }
    }
}

