/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.apache.axis2.kernel.OutTransportInfo;
import org.apache.axis2.transport.http.server.AxisHttpConnection;
import org.apache.axis2.transport.http.server.AxisHttpResponse;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.io.entity.BasicHttpEntity;
import org.apache.hc.core5.http.io.entity.EmptyInputStream;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;

public class AxisHttpResponseImpl
implements AxisHttpResponse,
OutTransportInfo {
    private final ClassicHttpResponse response;
    private final AxisHttpConnection conn;
    private final HttpProcessor httpproc;
    private final HttpContext context;
    private AutoCommitOutputStream outstream;
    private String contentType;
    private volatile boolean commited;

    public AxisHttpResponseImpl(AxisHttpConnection conn, ClassicHttpResponse response, HttpProcessor httpproc, HttpContext context) {
        if (response == null) {
            throw new IllegalArgumentException("HTTP response may not be null");
        }
        if (conn == null) {
            throw new IllegalArgumentException("HTTP connection may not be null");
        }
        if (httpproc == null) {
            throw new IllegalArgumentException("HTTP processor may not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        this.response = response;
        this.conn = conn;
        this.httpproc = httpproc;
        this.context = context;
    }

    private void assertNotCommitted() {
        if (this.commited) {
            throw new IllegalStateException("Response already committed");
        }
    }

    public boolean isCommitted() {
        return this.commited;
    }

    public void commit() throws IOException, HttpException {
        if (this.commited) {
            return;
        }
        this.commited = true;
        this.context.setAttribute("http.connection-endpoint", (Object)this.conn);
        this.context.setAttribute("http.response", (Object)this.response);
        ContentType contentTypeObj = null;
        if (this.contentType != null) {
            contentTypeObj = ContentType.parse((CharSequence)this.contentType);
        }
        this.response.removeHeaders("Content-Length");
        this.response.setEntity((HttpEntity)new BasicHttpEntity((InputStream)EmptyInputStream.INSTANCE, contentTypeObj, true));
        this.httpproc.process((HttpResponse)this.response, (EntityDetails)this.response.getEntity(), this.context);
        this.conn.sendResponse(this.response);
    }

    @Override
    public OutputStream getOutputStream() {
        if (this.outstream == null) {
            this.outstream = new AutoCommitOutputStream();
        }
        return this.outstream;
    }

    public Header getFirstHeader(String name) {
        return this.response.getFirstHeader(name);
    }

    public Header getLastHeader(String name) {
        return this.response.getLastHeader(name);
    }

    public Iterator<Header> headerIterator() {
        return this.response.headerIterator();
    }

    public Iterator<Header> headerIterator(String name) {
        return this.response.headerIterator(name);
    }

    public void setHeader(Header header) {
        this.assertNotCommitted();
        this.response.setHeader(header);
    }

    public void setHeader(String name, Object value) {
        this.assertNotCommitted();
        this.response.setHeader(name, value);
    }

    public void setHeaders(Header[] headers) {
        this.assertNotCommitted();
        this.response.setHeaders(headers);
    }

    @Override
    public void setStatus(int sc) {
        this.assertNotCommitted();
        this.response.setCode(sc);
    }

    @Override
    public void sendError(int sc, String msg) {
        this.assertNotCommitted();
        this.response.setCode(sc);
        this.response.setReasonPhrase(msg);
    }

    @Override
    public void sendError(int sc) {
        this.assertNotCommitted();
        this.response.setCode(sc);
    }

    @Override
    public void setContentType(String contentType) {
        this.assertNotCommitted();
        this.contentType = contentType;
    }

    public void addHeader(Header header) {
        this.assertNotCommitted();
        this.response.addHeader(header);
    }

    public void addHeader(String name, Object value) {
        this.assertNotCommitted();
        this.response.addHeader(name, value);
    }

    public ProtocolVersion getVersion() {
        return this.response.getVersion();
    }

    public void setVersion(ProtocolVersion version) {
        this.assertNotCommitted();
        this.response.setVersion(version);
    }

    public Header[] getHeaders(String name) {
        return this.response.getHeaders(name);
    }

    public Header[] getHeaders() {
        return this.response.getHeaders();
    }

    public boolean removeHeader(Header header) {
        this.assertNotCommitted();
        return this.response.removeHeader(header);
    }

    public boolean removeHeaders(String name) {
        this.assertNotCommitted();
        return this.response.removeHeaders(name);
    }

    public boolean containsHeader(String name) {
        return this.response.containsHeader(name);
    }

    public int countHeaders(String name) {
        return this.response.countHeaders(name);
    }

    public Header getHeader(String name) throws ProtocolException {
        return this.response.getHeader(name);
    }

    class AutoCommitOutputStream
    extends OutputStream {
        private OutputStream out;

        private void ensureCommitted() throws IOException {
            try {
                AxisHttpResponseImpl.this.commit();
            }
            catch (HttpException ex) {
                throw (IOException)new IOException().initCause(ex);
            }
            if (this.out == null) {
                this.out = AxisHttpResponseImpl.this.conn.getOutputStream();
            }
        }

        @Override
        public void close() throws IOException {
            this.ensureCommitted();
            this.out.close();
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.ensureCommitted();
            this.out.write(b, off, len);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.ensureCommitted();
            this.out.write(b);
        }

        @Override
        public void write(int b) throws IOException {
            this.ensureCommitted();
            this.out.write(b);
        }

        @Override
        public void flush() throws IOException {
            this.ensureCommitted();
            this.out.flush();
        }
    }
}

