/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.security.rampart;

import java.security.Principal;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisModule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.rahas.SimpleTokenStore;
import org.apache.rahas.TokenStorage;
import org.apache.rahas.TrustException;
import org.apache.rahas.TrustUtil;
import org.apache.rahas.client.STSClient;
import org.apache.rampart.RampartException;
import org.apache.rampart.policy.RampartPolicyBuilder;
import org.apache.rampart.policy.RampartPolicyData;
import org.apache.rampart.policy.model.RampartConfig;
import org.apache.rampart.util.RampartUtil;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.security.SecurityManager;
import org.apache.sandesha2.security.SecurityToken;
import org.apache.sandesha2.security.rampart.RampartSecurityToken;
import org.apache.ws.secpolicy.WSSPolicyException;
import org.apache.ws.secpolicy.model.SecureConversationToken;
import org.apache.ws.secpolicy.model.Token;
import org.apache.ws.security.WSDerivedKeyTokenPrincipal;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.message.token.Reference;

public class RampartBasedSecurityManager
extends SecurityManager {
    private static final Log log = LogFactory.getLog(RampartBasedSecurityManager.class);
    TokenStorage storage = null;

    public RampartBasedSecurityManager(ConfigurationContext context) {
        super(context);
        this.storage = (TokenStorage)context.getProperty("org.apache.rahas.TokenStorage");
        if (this.storage == null) {
            this.storage = new SimpleTokenStore();
            context.setProperty("org.apache.rahas.TokenStorage", (Object)this.storage);
        }
    }

    public void checkProofOfPossession(SecurityToken token, OMElement messagePart, MessageContext message) throws SandeshaException {
        List results = null;
        results = (List)message.getProperty("RECV_RESULTS");
        if (results == null) {
            String msg = SandeshaMessageHelper.getMessage((String)"noSecurityResults");
            throw new SandeshaException(msg);
        }
        boolean verified = false;
        block0: for (int i = 0; i < results.size() && !verified; ++i) {
            WSHandlerResult rResult = (WSHandlerResult)results.get(i);
            List wsSecEngineResults = rResult.getResults();
            for (int j = 0; j < wsSecEngineResults.size() && !verified; ++j) {
                String id;
                String baseTokenId;
                SecurityToken recoveredToken;
                Principal principal;
                WSSecurityEngineResult wser = (WSSecurityEngineResult)wsSecEngineResults.get(j);
                if ((Integer)wser.get((Object)"action") != 2 || wser.get((Object)"principal") == null || !((principal = (Principal)wser.get((Object)"principal")) instanceof WSDerivedKeyTokenPrincipal) || (recoveredToken = this.recoverSecurityToken(baseTokenId = ((WSDerivedKeyTokenPrincipal)principal).getBasetokenId())) == null) continue;
                org.apache.rahas.Token rahasToken = ((RampartSecurityToken)recoveredToken).getToken();
                String recoverdTokenId = rahasToken.getId();
                String attRefId = null;
                String unattrefId = null;
                if (rahasToken.getAttachedReference() != null) {
                    attRefId = this.getUriFromSTR(rahasToken.getAttachedReference());
                }
                if (rahasToken.getUnattachedReference() != null) {
                    unattrefId = this.getUriFromSTR(rahasToken.getUnattachedReference());
                }
                if (!recoverdTokenId.equals(id = ((RampartSecurityToken)token).getToken().getId()) && !attRefId.equals(id) && !unattrefId.equals(id)) continue;
                OMAttribute idattr = messagePart.getAttribute(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id"));
                String processedId = (String)wser.get((Object)"id");
                verified = processedId.equals(idattr.getAttributeValue());
                if (verified) continue block0;
            }
        }
        if (!verified) {
            String msg = SandeshaMessageHelper.getMessage((String)"proofOfPossessionNotVerified");
            throw new SandeshaException(msg);
        }
    }

    private String getUriFromSTR(OMElement str) {
        OMElement refElem = str.getFirstChildWithName(Reference.TOKEN);
        return refElem.getAttributeValue(new QName("URI")).substring(1);
    }

    public OMElement createSecurityTokenReference(SecurityToken token, MessageContext message) throws SandeshaException {
        OMFactory fac = message.getEnvelope().getOMFactory();
        RampartSecurityToken rampartToken = (RampartSecurityToken)token;
        OMElement element = rampartToken.getToken().getAttachedReference();
        if (element == null) {
            element = rampartToken.getToken().getUnattachedReference();
        }
        if (element == null) {
            element = fac.createOMElement("SecurityTokenReference", "Security", "wsse");
            OMElement refElem = fac.createOMElement(Reference.TOKEN, (OMContainer)element);
            refElem.addAttribute("ValueType", "http://schemas.xmlsoap.org/ws/2005/02/sc/sct", null);
            refElem.addAttribute("URI", rampartToken.getToken().getId(), null);
        }
        return this.convertOMElement(fac, element);
    }

    public SecurityToken getSecurityToken(MessageContext message) throws SandeshaException {
        String contextIdentifierKey = RampartUtil.getContextIdentifierKey((MessageContext)message);
        String identifier = (String)RampartUtil.getContextMap((MessageContext)message).get(contextIdentifierKey);
        if (identifier == null && !message.isServerSide()) {
            try {
                OMElement rstTmpl = RampartUtil.createRSTTempalteForSCT((int)1, (int)1);
                String action = TrustUtil.getActionValue((int)1, (String)"/RST/SCT");
                Policy servicePolicy = (Policy)message.getProperty("rampartPolicy");
                if (servicePolicy == null) {
                    return null;
                }
                List it = (List)servicePolicy.getAlternatives().next();
                RampartPolicyData rpd = RampartPolicyBuilder.build((List)it);
                SecureConversationToken secConvTok = null;
                Token encrtok = rpd.getEncryptionToken();
                SecureConversationToken secureConversationToken = secConvTok = encrtok != null && encrtok instanceof SecureConversationToken ? (SecureConversationToken)encrtok : null;
                if (secConvTok == null) {
                    Token sigtok = rpd.getSignatureToken();
                    SecureConversationToken secureConversationToken2 = secConvTok = sigtok != null && sigtok instanceof SecureConversationToken ? (SecureConversationToken)sigtok : null;
                }
                if (secConvTok == null) {
                    String msg = SandeshaMessageHelper.getMessage((String)"noSecConvTokenInPolicy");
                    log.debug((Object)msg);
                    return null;
                }
                Policy issuerPolicy = secConvTok.getBootstrapPolicy();
                issuerPolicy.addAssertion((Assertion)rpd.getRampartConfig());
                STSClient client = new STSClient(message.getConfigurationContext());
                Options op = new Options();
                op.setProperty("Sandesha2UnreliableMessage", (Object)"true");
                client.setOptions(op);
                client.setAction(action);
                client.setRstTemplate(rstTmpl);
                client.setCryptoInfo(RampartUtil.getEncryptionCrypto((RampartConfig)rpd.getRampartConfig(), (ClassLoader)message.getAxisService().getClassLoader()), RampartUtil.getPasswordCB((MessageContext)message, (RampartPolicyData)rpd));
                String address = message.getTo().getAddress();
                org.apache.rahas.Token tok = client.requestSecurityToken(servicePolicy, address, issuerPolicy, null);
                tok.setState(1);
                this.storage.add(tok);
                contextIdentifierKey = RampartUtil.getContextIdentifierKey((MessageContext)message);
                RampartUtil.getContextMap((MessageContext)message).put(contextIdentifierKey, tok.getId());
                identifier = tok.getId();
            }
            catch (RampartException e) {
                throw new SandeshaException(e.getMessage(), (Exception)((Object)e));
            }
            catch (TrustException e) {
                throw new SandeshaException(e.getMessage(), (Exception)((Object)e));
            }
            catch (WSSPolicyException e) {
                throw new SandeshaException(e.getMessage(), (Exception)((Object)e));
            }
        }
        return this.recoverSecurityToken(identifier);
    }

    public SecurityToken getSecurityToken(OMElement theSTR, MessageContext message) throws SandeshaException {
        String id;
        OMElement refElem = theSTR.getFirstChildWithName(Reference.TOKEN);
        String tokenId = id = refElem.getAttributeValue(new QName("URI"));
        if (!id.startsWith("urn:") && id.startsWith("#")) {
            tokenId = tokenId.substring(1);
        }
        return this.recoverSecurityToken(tokenId);
    }

    public String getTokenRecoveryData(SecurityToken token) throws SandeshaException {
        String id = ((RampartSecurityToken)token).getToken().getId();
        if (!id.startsWith("urn:") && id.startsWith("#")) {
            id = id.substring(1);
        }
        return id;
    }

    public void initSecurity(AxisModule moduleDesc) {
    }

    public SecurityToken recoverSecurityToken(String tokenData) throws SandeshaException {
        try {
            org.apache.rahas.Token token = this.storage.getToken(tokenData);
            if (token != null) {
                return new RampartSecurityToken(token);
            }
            String msg = SandeshaMessageHelper.getMessage((String)"errorRetrievingSecurityToken");
            throw new SandeshaException(msg);
        }
        catch (TrustException e) {
            String msg = SandeshaMessageHelper.getMessage((String)"errorRetrievingSecurityToken");
            throw new SandeshaException(msg);
        }
    }

    private OMElement convertOMElement(OMFactory fac, OMElement elem) {
        return new StAXOMBuilder(fac, elem.getXMLStreamReader()).getDocumentElement();
    }

    public void applySecurityToken(SecurityToken token, MessageContext outboundMessage) throws SandeshaException {
    }
}

