/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.messaging.qpid;

import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.sensor.AttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.PortAttributeSensorAndConfigKey;
import org.apache.brooklyn.entity.java.UsesJmx;
import org.apache.brooklyn.entity.messaging.MessageBroker;
import org.apache.brooklyn.entity.messaging.amqp.AmqpServer;
import org.apache.brooklyn.entity.messaging.jms.JMSBroker;
import org.apache.brooklyn.entity.messaging.qpid.QpidBrokerImpl;
import org.apache.brooklyn.entity.messaging.qpid.QpidQueue;
import org.apache.brooklyn.entity.messaging.qpid.QpidTopic;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.util.core.flags.SetFromFlag;

@Catalog(name="Qpid Broker", description="Apache Qpid is an open-source messaging system, implementing the Advanced Message Queuing Protocol (AMQP)", iconUrl="classpath:///qpid-logo.jpeg")
@ImplementedBy(value=QpidBrokerImpl.class)
public interface QpidBroker
extends SoftwareProcess,
MessageBroker,
UsesJmx,
AmqpServer,
JMSBroker<QpidQueue, QpidTopic> {
    public static final String CONFIG_XML = "etc/config.xml";
    public static final String VIRTUALHOSTS_XML = "etc/virtualhosts.xml";
    public static final String PASSWD = "etc/passwd";
    @SetFromFlag(value="version")
    public static final ConfigKey<String> SUGGESTED_VERSION = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.SUGGESTED_VERSION, (Object)"0.20");
    @SetFromFlag(value="archiveNameFormat")
    public static final ConfigKey<String> ARCHIVE_DIRECTORY_NAME_FORMAT = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.ARCHIVE_DIRECTORY_NAME_FORMAT, (Object)"qpid-broker-%s");
    @SetFromFlag(value="downloadUrl")
    public static final AttributeSensorAndConfigKey<String, String> DOWNLOAD_URL = ConfigKeys.newSensorAndConfigKeyWithDefault((AttributeSensorAndConfigKey)SoftwareProcess.DOWNLOAD_URL, (Object)"http://download.nextag.com/apache/qpid/${version}/qpid-java-broker-${version}.tar.gz");
    @SetFromFlag(value="amqpVersion")
    public static final AttributeSensorAndConfigKey<String, String> AMQP_VERSION = ConfigKeys.newSensorAndConfigKeyWithDefault(AmqpServer.AMQP_VERSION, (Object)"0-10");
    @SetFromFlag(value="httpManagementPort")
    public static final PortAttributeSensorAndConfigKey HTTP_MANAGEMENT_PORT = ConfigKeys.newPortSensorAndConfigKey((String)"qpid.http-management.port", (String)"Qpid HTTP management plugin port");
    @SetFromFlag(value="jmxUser")
    public static final AttributeSensorAndConfigKey<String, String> JMX_USER = ConfigKeys.newSensorAndConfigKeyWithDefault((AttributeSensorAndConfigKey)UsesJmx.JMX_USER, (Object)"admin");
    @SetFromFlag(value="jmxPassword")
    public static final AttributeSensorAndConfigKey<String, String> JMX_PASSWORD = ConfigKeys.newSensorAndConfigKeyWithDefault((AttributeSensorAndConfigKey)UsesJmx.JMX_PASSWORD, (Object)"admin");
}

