/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.text;

import java.util.Comparator;

public class NaturalOrderComparator
implements Comparator<String> {
    public static final NaturalOrderComparator INSTANCE = new NaturalOrderComparator();

    int compareRight(String a, String b) {
        int bias = 0;
        int ia = 0;
        int ib = 0;
        while (true) {
            char ca = NaturalOrderComparator.charAt(a, ia);
            char cb = NaturalOrderComparator.charAt(b, ib);
            if (!Character.isDigit(ca) && !Character.isDigit(cb)) {
                return bias;
            }
            if (!Character.isDigit(ca)) {
                return -1;
            }
            if (!Character.isDigit(cb)) {
                return 1;
            }
            if (ca < cb) {
                if (bias == 0) {
                    bias = -1;
                }
            } else if (ca > cb) {
                if (bias == 0) {
                    bias = 1;
                }
            } else if (ca == '\u0000' && cb == '\u0000') {
                return bias;
            }
            ++ia;
            ++ib;
        }
    }

    @Override
    public int compare(String a, String b) {
        int ia = 0;
        int ib = 0;
        int nza = 0;
        int nzb = 0;
        while (true) {
            nzb = 0;
            nza = 0;
            char ca = NaturalOrderComparator.charAt(a, ia);
            char cb = NaturalOrderComparator.charAt(b, ib);
            while (Character.isSpaceChar(ca) || ca == '0') {
                nza = ca == '0' ? ++nza : 0;
                ca = NaturalOrderComparator.charAt(a, ++ia);
            }
            while (Character.isSpaceChar(cb) || cb == '0') {
                nzb = cb == '0' ? ++nzb : 0;
                cb = NaturalOrderComparator.charAt(b, ++ib);
            }
            if (Character.isDigit(ca) && Character.isDigit(cb)) {
                boolean aDigitsDone;
                int result = this.compareRight(a.substring(ia), b.substring(ib));
                if (result != 0) {
                    return result;
                }
                do {
                    boolean bDigitsDone;
                    aDigitsDone = ++ia >= a.length() || !Character.isDigit(NaturalOrderComparator.charAt(a, ia));
                    boolean bl = bDigitsDone = ++ib >= b.length() || !Character.isDigit(NaturalOrderComparator.charAt(b, ib));
                    if (aDigitsDone == bDigitsDone) continue;
                    throw new IllegalStateException("Digit sequence lengths should have matched, '" + a + "' v '" + b + "'");
                } while (!aDigitsDone);
                if (ia < a.length() || ib < b.length()) {
                    if (ia >= a.length()) {
                        return -1;
                    }
                    if (ib >= b.length()) {
                        return 1;
                    }
                    result = this.compare(a.substring(ia), b.substring(ib));
                    if (result != 0) {
                        return result;
                    }
                }
                return nzb - nza;
            }
            if ((Character.isDigit(ca) || nza > 0) && (Character.isDigit(cb) || nzb > 0)) {
                if (nza == 0) {
                    return 1;
                }
                if (nzb == 0) {
                    return -1;
                }
            }
            if (ca == '\u0000' && cb == '\u0000') {
                return nza - nzb;
            }
            if (ca < cb) {
                return -1;
            }
            if (ca > cb) {
                return 1;
            }
            ++ia;
            ++ib;
        }
    }

    static char charAt(String s, int i) {
        if (i >= s.length()) {
            return '\u0000';
        }
        return s.charAt(i);
    }
}

