/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.impl.console.osgi.secured;

import java.nio.file.Path;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.felix.gogo.runtime.Closure;
import org.apache.felix.gogo.runtime.CommandNotFoundException;
import org.apache.felix.gogo.runtime.CommandSessionImpl;
import org.apache.felix.service.command.Function;
import org.apache.felix.service.threadio.ThreadIO;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;
import org.apache.karaf.service.guard.tools.ACLConfigurationParser;
import org.apache.karaf.shell.api.console.Command;
import org.apache.karaf.shell.impl.console.SessionFactoryImpl;
import org.apache.karaf.shell.impl.console.osgi.secured.AliasCommand;
import org.apache.karaf.shell.impl.console.osgi.secured.SecuredCommand;
import org.apache.karaf.util.tracker.SingleServiceTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecuredSessionFactoryImpl
extends SessionFactoryImpl
implements ConfigurationListener {
    private static final String PROXY_COMMAND_ACL_PID_PREFIX = "org.apache.karaf.command.acl.";
    private static final String CONFIGURATION_FILTER = "(service.pid=org.apache.karaf.command.acl.*)";
    private static final String SHELL_SCOPE = "shell";
    private static final String SHELL_INVOKE = ".invoke";
    private static final String SHELL_REDIRECT = ".redirect";
    private static final Logger LOGGER = LoggerFactory.getLogger(SecuredSessionFactoryImpl.class);
    private BundleContext bundleContext;
    private Map<String, Dictionary<String, Object>> scopes = new HashMap<String, Dictionary<String, Object>>();
    private SingleServiceTracker<ConfigurationAdmin> configAdminTracker;
    private ServiceRegistration<ConfigurationListener> registration;
    private ThreadLocal<Map<Object, Boolean>> serviceVisibleMap = new ThreadLocal();

    public SecuredSessionFactoryImpl(BundleContext bundleContext, ThreadIO threadIO) throws InvalidSyntaxException {
        super(threadIO);
        this.bundleContext = bundleContext;
        this.registration = bundleContext.registerService(ConfigurationListener.class, (Object)this, null);
        this.configAdminTracker = new SingleServiceTracker<ConfigurationAdmin>(bundleContext, ConfigurationAdmin.class, this::update);
        this.configAdminTracker.open();
    }

    @Override
    public void stop() {
        this.registration.unregister();
        this.configAdminTracker.close();
        super.stop();
    }

    @Override
    protected Object invoke(CommandSessionImpl session, Object target, String name, List<Object> args) throws Exception {
        this.checkSecurity(SHELL_SCOPE, SHELL_INVOKE, Arrays.asList(target, name, args));
        return super.invoke(session, target, name, args);
    }

    @Override
    protected Path redirect(CommandSessionImpl session, Path path, int mode) {
        this.checkSecurity(SHELL_SCOPE, SHELL_REDIRECT, Arrays.asList(path, mode));
        return super.redirect(session, path, mode);
    }

    @Override
    protected Function wrap(Command command) {
        return new SecuredCommand(this, command);
    }

    @Override
    protected boolean isVisible(Object service) {
        if (this.serviceVisibleMap.get() == null) {
            this.serviceVisibleMap.set(new HashMap());
        }
        if (this.serviceVisibleMap.get().get(service) != null) {
            return this.serviceVisibleMap.get().get(service);
        }
        if (service instanceof Command) {
            Command cmd = (Command)service;
            boolean ret = this.isVisible(cmd.getScope(), cmd.getName());
            this.serviceVisibleMap.get().put(service, ret);
            return ret;
        }
        boolean ret = super.isVisible(service);
        this.serviceVisibleMap.get().put(service, ret);
        return ret;
    }

    public boolean isVisible(String scope, String name) {
        AliasCommand aliasCommand;
        boolean visible = true;
        Dictionary<String, Object> config = this.getScopeConfig(scope);
        if (config != null) {
            visible = false;
            ArrayList<String> roles = new ArrayList<String>();
            ACLConfigurationParser.getRolesForInvocation(name, null, null, config, roles);
            if (roles.isEmpty()) {
                visible = true;
            } else {
                for (String role : roles) {
                    if (!SecuredSessionFactoryImpl.currentUserHasRole(role)) continue;
                    visible = true;
                }
            }
        }
        if ((aliasCommand = this.findAlias(scope, name)) != null) {
            visible = visible && this.isAliasVisible(aliasCommand.getScope(), aliasCommand.getName());
        }
        return visible;
    }

    public boolean isAliasVisible(String scope, String name) {
        Dictionary<String, Object> config = this.getScopeConfig(scope);
        if (config != null) {
            ArrayList<String> roles = new ArrayList<String>();
            ACLConfigurationParser.getRolesForInvocationForAlias(name, null, null, config, roles);
            if (roles.isEmpty()) {
                return true;
            }
            for (String role : roles) {
                if (!SecuredSessionFactoryImpl.currentUserHasRole(role)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private AliasCommand findAlias(String scope, String name) {
        if (this.session != null) {
            Set vars = (Set)this.session.get(null);
            HashSet aliases = new HashSet();
            String aliasScope = null;
            String aliasName = null;
            for (String var : vars) {
                int index;
                Object content = this.session.get(var);
                if (content == null || !"org.apache.felix.gogo.runtime.Closure".equals(content.getClass().getName()) || (index = var.indexOf(":")) <= 0) continue;
                aliasScope = var.substring(0, index);
                aliasName = var.substring(index + 1);
                String originalCmd = content.toString();
                index = originalCmd.indexOf(" ");
                Object securityCmd = null;
                if (index > 0) {
                    securityCmd = ((Closure)content).get(originalCmd.substring(0, index));
                }
                if (!(securityCmd instanceof SecuredCommand) || !((SecuredCommand)securityCmd).getScope().equals(scope) || !((SecuredCommand)securityCmd).getName().equals(name)) continue;
                return new AliasCommand(aliasScope, aliasName);
            }
        }
        return null;
    }

    void checkSecurity(String scope, String name, List<Object> arguments) {
        AliasCommand aliasCommand;
        ArrayList<String> roles;
        Dictionary<String, Object> config = this.getScopeConfig(scope);
        boolean passCheck = false;
        if (config != null) {
            if (!this.isVisible(scope, name)) {
                throw new CommandNotFoundException(scope + ":" + name);
            }
            roles = new ArrayList();
            Object s = ACLConfigurationParser.getRolesForInvocation(name, new Object[]{arguments.toString()}, null, config, roles);
            if (s == ACLConfigurationParser.Specificity.NO_MATCH) {
                passCheck = true;
            }
            for (String role : roles) {
                if (!SecuredSessionFactoryImpl.currentUserHasRole(role)) continue;
                passCheck = true;
            }
            if (!passCheck) {
                throw new SecurityException("Insufficient credentials.");
            }
        } else {
            roles = new ArrayList<String>();
            ACLConfigurationParser.getCompulsoryRoles(roles);
            if (roles.size() == 0) {
                passCheck = true;
            }
            for (String role : roles) {
                if (!SecuredSessionFactoryImpl.currentUserHasRole(role)) continue;
                passCheck = true;
            }
            if (!passCheck) {
                throw new SecurityException("Insufficient credentials.");
            }
        }
        if ((aliasCommand = this.findAlias(scope, name)) != null && config != null) {
            if (!this.isAliasVisible(aliasCommand.getScope(), aliasCommand.getName())) {
                throw new CommandNotFoundException(aliasCommand.getScope() + ":" + aliasCommand.getName());
            }
            ArrayList<String> roles2 = new ArrayList<String>();
            ACLConfigurationParser.Specificity s = ACLConfigurationParser.getRolesForInvocationForAlias(aliasCommand.getName(), new Object[]{arguments.toString()}, null, config, roles2);
            if (s == ACLConfigurationParser.Specificity.NO_MATCH) {
                return;
            }
            for (String role : roles2) {
                if (!SecuredSessionFactoryImpl.currentUserHasRole(role)) continue;
                return;
            }
            throw new SecurityException("Insufficient credentials.");
        }
    }

    static boolean currentUserHasRole(String requestedRole) {
        String role;
        String clazz;
        int index = requestedRole.indexOf(58);
        if (index > 0) {
            clazz = requestedRole.substring(0, index);
            role = requestedRole.substring(index + 1);
        } else {
            clazz = RolePrincipal.class.getName();
            role = requestedRole;
        }
        AccessControlContext acc = AccessController.getContext();
        if (acc == null) {
            return false;
        }
        Subject subject = Subject.getSubject(acc);
        if (subject == null) {
            return false;
        }
        for (Principal p : subject.getPrincipals()) {
            if (!clazz.equals(p.getClass().getName()) || !role.equals(p.getName())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configurationEvent(ConfigurationEvent event) {
        if (!event.getPid().startsWith(PROXY_COMMAND_ACL_PID_PREFIX)) {
            return;
        }
        try {
            ThreadLocal<Map<Object, Boolean>> threadLocal = this.serviceVisibleMap;
            synchronized (threadLocal) {
                if (this.serviceVisibleMap.get() != null) {
                    this.serviceVisibleMap.get().clear();
                }
            }
            switch (event.getType()) {
                case 2: {
                    this.removeScopeConfig(event.getPid().substring(PROXY_COMMAND_ACL_PID_PREFIX.length()));
                    break;
                }
                case 1: {
                    ConfigurationAdmin configAdmin = (ConfigurationAdmin)this.bundleContext.getService(event.getReference());
                    try {
                        this.addScopeConfig(configAdmin.getConfiguration(event.getPid(), null));
                        break;
                    }
                    finally {
                        this.bundleContext.ungetService(event.getReference());
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Problem processing Configuration Event {}", (Object)event, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addScopeConfig(Configuration config) {
        if (!config.getPid().startsWith(PROXY_COMMAND_ACL_PID_PREFIX)) {
            return;
        }
        String scope = config.getPid().substring(PROXY_COMMAND_ACL_PID_PREFIX.length());
        if (scope.indexOf(46) >= 0) {
            return;
        }
        scope = scope.trim();
        Map<String, Dictionary<String, Object>> map = this.scopes;
        synchronized (map) {
            if (scope.endsWith("*")) {
                scope = "star";
            }
            this.scopes.put(scope, config.getProperties());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeScopeConfig(String scope) {
        Map<String, Dictionary<String, Object>> map = this.scopes;
        synchronized (map) {
            this.scopes.remove(scope);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dictionary<String, Object> getScopeConfig(String scope) {
        Map<String, Dictionary<String, Object>> map = this.scopes;
        synchronized (map) {
            if (scope.equals("*")) {
                scope = "star";
            }
            return this.scopes.get(scope);
        }
    }

    protected void update(ConfigurationAdmin prev, ConfigurationAdmin configAdmin) {
        try {
            Configuration[] configs = configAdmin.listConfigurations(CONFIGURATION_FILTER);
            if (configs != null) {
                for (Configuration config : configs) {
                    this.addScopeConfig(config);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

