/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.nosql.couchbase;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.net.HostAndPort;
import com.google.common.net.MediaType;
import com.google.common.reflect.TypeToken;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.MachineProvisioningLocation;
import org.apache.brooklyn.api.location.PortRange;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.effector.EffectorBody;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.location.access.BrooklynAccessUtils;
import org.apache.brooklyn.core.location.cloud.CloudLocationConfig;
import org.apache.brooklyn.entity.nosql.couchbase.CouchbaseNode;
import org.apache.brooklyn.entity.nosql.couchbase.CouchbaseNodeDriver;
import org.apache.brooklyn.entity.software.base.SoftwareProcessImpl;
import org.apache.brooklyn.feed.http.HttpFeed;
import org.apache.brooklyn.feed.http.HttpPollConfig;
import org.apache.brooklyn.feed.http.HttpValueFunctions;
import org.apache.brooklyn.feed.http.JsonFunctions;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Functionals;
import org.apache.brooklyn.util.guava.MaybeFunctions;
import org.apache.brooklyn.util.guava.TypeTokens;
import org.apache.brooklyn.util.http.HttpTool;
import org.apache.brooklyn.util.http.HttpToolResponse;
import org.apache.brooklyn.util.net.Urls;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CouchbaseNodeImpl
extends SoftwareProcessImpl
implements CouchbaseNode {
    private static final Logger log = LoggerFactory.getLogger(CouchbaseNodeImpl.class);
    private volatile HttpFeed httpFeed;
    protected static final Function<HttpToolResponse, JsonElement> GET_THIS_NODE_STATS = Functionals.chain((Function)HttpValueFunctions.jsonContents(), (Function)JsonFunctions.walk((String)"nodes"), (Function)new Function<JsonElement, JsonElement>(){

        public JsonElement apply(JsonElement input) {
            JsonArray nodes = input.getAsJsonArray();
            for (JsonElement element : nodes) {
                JsonElement thisNode = element.getAsJsonObject().get("thisNode");
                if (thisNode == null || !Boolean.TRUE.equals(thisNode.getAsBoolean())) continue;
                return element.getAsJsonObject().get("interestingStats");
            }
            return null;
        }
    });

    public Class<CouchbaseNodeDriver> getDriverInterface() {
        return CouchbaseNodeDriver.class;
    }

    public CouchbaseNodeDriver getDriver() {
        return (CouchbaseNodeDriver)super.getDriver();
    }

    public void init() {
        super.init();
        this.subscriptions().subscribe((Entity)this, (Sensor)Attributes.SERVICE_UP, (SensorEventListener)new SensorEventListener<Boolean>(){

            public void onEvent(SensorEvent<Boolean> booleanSensorEvent) {
                if (Boolean.TRUE.equals(booleanSensorEvent.getValue())) {
                    Integer webPort = (Integer)CouchbaseNodeImpl.this.getAttribute((AttributeSensor)CouchbaseNode.COUCHBASE_WEB_ADMIN_PORT);
                    Preconditions.checkNotNull((Object)webPort, (String)(CouchbaseNode.COUCHBASE_WEB_ADMIN_PORT + " not set for %s; is an acceptable port available?"), (Object[])new Object[]{this});
                    String hostAndPort = BrooklynAccessUtils.getBrooklynAccessibleAddress((Entity)CouchbaseNodeImpl.this, (int)webPort).toString();
                    CouchbaseNodeImpl.this.sensors().set(CouchbaseNode.COUCHBASE_WEB_ADMIN_URL, (Object)URI.create(String.format("http://%s", hostAndPort)));
                }
            }
        });
        this.getMutableEntityType().addEffector(ADD_REPLICATION_RULE, (EffectorBody)new EffectorBody<Void>(){

            public Void call(ConfigBag parameters) {
                CouchbaseNodeImpl.this.addReplicationRule(parameters);
                return null;
            }
        });
    }

    protected Map<String, Object> obtainProvisioningFlags(MachineProvisioningLocation location) {
        ConfigBag result = ConfigBag.newInstance((Map)super.obtainProvisioningFlags(location));
        result.configure(CloudLocationConfig.OS_64_BIT, (Object)true);
        return result.getAllConfig();
    }

    protected Collection<Integer> getRequiredOpenPorts() {
        int erlangRangeStart = (Integer)((PortRange)this.getConfig((ConfigKey.HasConfigKey)NODE_DATA_EXCHANGE_PORT_RANGE_START)).iterator().next();
        int erlangRangeEnd = (Integer)((PortRange)this.getConfig((ConfigKey.HasConfigKey)NODE_DATA_EXCHANGE_PORT_RANGE_END)).iterator().next();
        MutableSet newPorts = MutableSet.copyOf((Iterable)super.getRequiredOpenPorts());
        newPorts.remove(erlangRangeStart);
        newPorts.remove(erlangRangeEnd);
        for (int i = erlangRangeStart; i <= erlangRangeEnd; ++i) {
            newPorts.add(i);
        }
        return newPorts;
    }

    @Override
    public void serverAdd(String serverToAdd, String username, String password) {
        this.getDriver().serverAdd(serverToAdd, username, password);
    }

    @Override
    public void serverAddAndRebalance(String serverToAdd, String username, String password) {
        this.getDriver().serverAddAndRebalance(serverToAdd, username, password);
    }

    @Override
    public void rebalance() {
        this.getDriver().rebalance();
    }

    protected static final <T> HttpPollConfig<T> getSensorFromNodeStat(AttributeSensor<T> sensor, String ... jsonPath) {
        return (HttpPollConfig)((HttpPollConfig)new HttpPollConfig(sensor).onSuccess(Functionals.chain(GET_THIS_NODE_STATS, (Function)MaybeFunctions.wrap(), (Function)JsonFunctions.walkM((String[])jsonPath), (Function)JsonFunctions.castM((Class)TypeTokens.getRawRawType((TypeToken)sensor.getTypeToken()), null)))).onFailureOrException(Functions.constant(null));
    }

    protected void postStart() {
        super.postStart();
        this.renameServerToPublicHostname();
    }

    protected void renameServerToPublicHostname() {
        URI apiUri = null;
        try {
            HostAndPort accessible = BrooklynAccessUtils.getBrooklynAccessibleAddress((Entity)this, (int)((Integer)this.getAttribute((AttributeSensor)COUCHBASE_WEB_ADMIN_PORT)));
            apiUri = URI.create(String.format("http://%s:%d/node/controller/rename", accessible.getHostText(), accessible.getPort()));
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials((String)this.getConfig(COUCHBASE_ADMIN_USERNAME), (String)this.getConfig(COUCHBASE_ADMIN_PASSWORD));
            HttpToolResponse response = HttpTool.httpPost((HttpClient)HttpTool.httpClientBuilder().uri(apiUri).credentials((Credentials)credentials).build(), (URI)apiUri, (Map)MutableMap.of((Object)"Content-Type", (Object)MediaType.FORM_DATA.toString(), (Object)"Accept", (Object)"*/*", (Object)"Authorization", (Object)HttpTool.toBasicAuthorizationValue((UsernamePasswordCredentials)credentials)), (byte[])Charsets.UTF_8.encode("hostname=" + Urls.encode((String)accessible.getHostText())).array());
            log.debug("Renamed Couchbase server " + this + " via " + apiUri + ": " + response);
            if (!HttpTool.isStatusCodeHealthy((int)response.getResponseCode())) {
                log.warn("Invalid response code, renaming {} ({}): {}", new Object[]{apiUri, response.getResponseCode(), response.getContentAsString()});
            }
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            log.warn("Error renaming server, using " + apiUri + ": " + e, (Throwable)e);
        }
    }

    public void connectSensors() {
        super.connectSensors();
        this.connectServiceUpIsRunning();
        HostAndPort hostAndPort = BrooklynAccessUtils.getBrooklynAccessibleAddress((Entity)this, (int)((Integer)this.getAttribute((AttributeSensor)CouchbaseNode.COUCHBASE_WEB_ADMIN_PORT)));
        this.httpFeed = HttpFeed.builder().entity((Entity)this).period(Duration.seconds((Number)3)).baseUri("http://" + hostAndPort + "/pools/nodes/").credentialsIfNotNull((String)this.getConfig(CouchbaseNode.COUCHBASE_ADMIN_USERNAME), (String)this.getConfig(CouchbaseNode.COUCHBASE_ADMIN_PASSWORD)).poll(CouchbaseNodeImpl.getSensorFromNodeStat(CouchbaseNode.OPS, "ops")).poll(CouchbaseNodeImpl.getSensorFromNodeStat(CouchbaseNode.COUCH_DOCS_DATA_SIZE, "couch_docs_data_size")).poll(CouchbaseNodeImpl.getSensorFromNodeStat(CouchbaseNode.COUCH_DOCS_ACTUAL_DISK_SIZE, "couch_docs_actual_disk_size")).poll(CouchbaseNodeImpl.getSensorFromNodeStat(CouchbaseNode.EP_BG_FETCHED, "ep_bg_fetched")).poll(CouchbaseNodeImpl.getSensorFromNodeStat(CouchbaseNode.MEM_USED, "mem_used")).poll(CouchbaseNodeImpl.getSensorFromNodeStat(CouchbaseNode.COUCH_VIEWS_ACTUAL_DISK_SIZE, "couch_views_actual_disk_size")).poll(CouchbaseNodeImpl.getSensorFromNodeStat(CouchbaseNode.CURR_ITEMS, "curr_items")).poll(CouchbaseNodeImpl.getSensorFromNodeStat(CouchbaseNode.VB_REPLICA_CURR_ITEMS, "vb_replica_curr_items")).poll(CouchbaseNodeImpl.getSensorFromNodeStat(CouchbaseNode.COUCH_VIEWS_DATA_SIZE, "couch_views_data_size")).poll(CouchbaseNodeImpl.getSensorFromNodeStat(CouchbaseNode.GET_HITS, "get_hits")).poll(CouchbaseNodeImpl.getSensorFromNodeStat(CouchbaseNode.CMD_GET, "cmd_get")).poll(CouchbaseNodeImpl.getSensorFromNodeStat(CouchbaseNode.CURR_ITEMS_TOT, "curr_items_tot")).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(CouchbaseNode.REBALANCE_STATUS).onSuccess(HttpValueFunctions.jsonContents((String)"rebalanceStatus", String.class))).onFailureOrException(Functions.constant((Object)"Could not retrieve"))).build();
    }

    public void disconnectSensors() {
        super.disconnectSensors();
        this.disconnectServiceUpIsRunning();
        if (this.httpFeed != null) {
            this.httpFeed.stop();
        }
    }

    @Override
    public void bucketCreate(String bucketName, String bucketType, Integer bucketPort, Integer bucketRamSize, Integer bucketReplica) {
        if (Strings.isBlank((CharSequence)bucketType)) {
            bucketType = "couchbase";
        }
        if (bucketRamSize == null || bucketRamSize <= 0) {
            bucketRamSize = 200;
        }
        if (bucketReplica == null || bucketReplica < 0) {
            bucketReplica = 1;
        }
        this.getDriver().bucketCreate(bucketName, bucketType, bucketPort, bucketRamSize, bucketReplica);
    }

    protected void addReplicationRule(ConfigBag ruleArgs) {
        Object toClusterO = Preconditions.checkNotNull((Object)ruleArgs.getStringKey("toCluster"), (Object)"toCluster must not be null");
        if (toClusterO instanceof String) {
            toClusterO = this.getManagementContext().lookup((String)toClusterO);
        }
        Entity toCluster = (Entity)Tasks.resolving((Object)toClusterO, Entity.class).context((Entity)this).get();
        String fromBucket = (String)Preconditions.checkNotNull((Object)((String)ruleArgs.getStringKey("fromBucket")), (Object)"fromBucket must be specified");
        String toBucket = (String)ruleArgs.getStringKey("toBucket");
        if (toBucket == null) {
            toBucket = fromBucket;
        }
        if (!ruleArgs.getUnusedConfig().isEmpty()) {
            throw new IllegalArgumentException("Unsupported replication rule data: " + ruleArgs.getUnusedConfig());
        }
        this.getDriver().addReplicationRule(toCluster, fromBucket, toBucket);
    }
}

