/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.elasticstack.domain.DriveInfo;
import org.jclouds.elasticstack.domain.WellKnownImage;

@Singleton
public class WellKnownImageToImage
implements Function<DriveInfo, Image> {
    private final Supplier<Location> locationSupplier;
    private final Supplier<Map<String, WellKnownImage>> preinstalledImages;
    private final Map<String, Credentials> credentialStore;

    @Inject
    public WellKnownImageToImage(Supplier<Location> locationSupplier, @Memoized Supplier<Map<String, WellKnownImage>> preinstalledImages, Map<String, Credentials> credentialStore) {
        this.locationSupplier = (Supplier)Preconditions.checkNotNull(locationSupplier, (Object)"locationSupplier cannot be null");
        this.preinstalledImages = (Supplier)Preconditions.checkNotNull(preinstalledImages, (Object)"preinstalledImages cannot be null");
        this.credentialStore = (Map)Preconditions.checkNotNull(credentialStore, (Object)"credentialStore cannot be null");
    }

    public Image apply(DriveInfo drive) {
        WellKnownImage input = (WellKnownImage)((Map)this.preinstalledImages.get()).get(drive.getUuid());
        this.credentialStore.put("image#" + drive.getUuid(), (Credentials)LoginCredentials.builder().user(input.getLoginUser()).build());
        return new ImageBuilder().ids(drive.getUuid()).userMetadata((Map)ImmutableMap.builder().putAll(drive.getUserMetadata()).put((Object)"size", (Object)(input.getSize() + "")).build()).location((Location)this.locationSupplier.get()).name(input.getDescription()).description(drive.getName()).status(Image.Status.AVAILABLE).operatingSystem(new OperatingSystem.Builder().family(input.getOsFamily()).version(input.getOsVersion()).name(input.getDescription()).description(drive.getName()).is64Bit(input.is64bit()).build()).version("").build();
    }
}

