/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.location.access;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Map;
import org.apache.brooklyn.api.internal.AbstractBrooklynObjectSpec;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.LocationRegistry;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.location.AbstractLocationResolver;
import org.apache.brooklyn.core.location.LocationConfigUtils;
import org.apache.brooklyn.core.location.LocationPredicates;
import org.apache.brooklyn.core.location.access.PortForwardManager;
import org.apache.brooklyn.core.location.access.PortForwardManagerImpl;
import org.apache.brooklyn.core.location.cloud.CloudLocationConfig;
import org.apache.brooklyn.core.location.internal.LocationInternal;
import org.apache.brooklyn.core.objs.proxy.SpecialBrooklynObjectConstructor;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortForwardManagerLocationResolver
extends AbstractLocationResolver {
    private static final Logger LOG = LoggerFactory.getLogger(PortForwardManagerLocationResolver.class);
    public static final String PREFIX = "portForwardManager";
    public static final String PFM_GLOBAL_SPEC = "portForwardManager(scope=global)";

    public String getPrefix() {
        return PREFIX;
    }

    @Override
    public LocationSpec<?> newLocationSpecFromString(String spec, Map<?, ?> locationFlags, LocationRegistry registry) {
        ConfigBag config = this.extractConfig(locationFlags, spec, registry);
        Map globalProperties = registry.getProperties();
        String namedLocation = (String)locationFlags.get(LocationInternal.NAMED_SPEC_NAME.getName());
        String scope = config.get(PortForwardManager.SCOPE);
        return (LocationSpec)((LocationSpec)((LocationSpec)((LocationSpec)LocationSpec.create(PortForwardManagerImpl.class).configure(config.getAllConfig())).configure(LocationConfigUtils.finalAndOriginalSpecs(spec, locationFlags, globalProperties, namedLocation))).configure(PortForwardManagerConstructor.SCOPE, (Object)scope)).configure(SpecialBrooklynObjectConstructor.Config.SPECIAL_CONSTRUCTOR, PortForwardManagerConstructor.class);
    }

    @Override
    protected Class<? extends Location> getLocationType() {
        return PortForwardManager.class;
    }

    @Override
    protected AbstractLocationResolver.SpecParser getSpecParser() {
        return new AbstractLocationResolver.SpecParser(this.getPrefix()).setExampleUsage("\"portForwardManager\" or \"portForwardManager(scope=global)\"");
    }

    @Override
    protected ConfigBag extractConfig(Map<?, ?> locationFlags, String spec, LocationRegistry registry) {
        ConfigBag config = super.extractConfig(locationFlags, spec, registry);
        config.putAsStringKeyIfAbsent("name", "localhost");
        return config;
    }

    public static class PortForwardManagerConstructor
    implements SpecialBrooklynObjectConstructor {
        public static ConfigKey<String> SCOPE = ConfigKeys.newConfigKeyWithPrefix("brooklyn.object.constructor.portforward.", PortForwardManager.SCOPE);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T create(ManagementContext mgmt, Class<T> type, AbstractBrooklynObjectSpec<?, ?> spec) {
            ConfigBag config = ConfigBag.newInstance(spec.getConfig());
            String scope = config.get(SCOPE);
            Optional<Location> result = this.findPortForwardManager(mgmt, scope);
            if (result.isPresent()) {
                return (T)result.get();
            }
            Class<PortForwardManager> clazz = PortForwardManager.class;
            synchronized (PortForwardManager.class) {
                result = this.findPortForwardManager(mgmt, scope);
                if (result.isPresent()) {
                    // ** MonitorExit[var7_7] (shouldn't be in output)
                    return (T)result.get();
                }
                Object callerContext = config.get(CloudLocationConfig.CALLER_CONTEXT);
                LOG.info("Creating PortForwardManager(scope=" + scope + ")" + (callerContext != null ? " for " + callerContext : ""));
                spec = LocationSpec.create((LocationSpec)spec);
                spec.configure(SpecialBrooklynObjectConstructor.Config.SPECIAL_CONSTRUCTOR, (Object)null);
                spec.configure(PortForwardManager.SCOPE, (Object)scope);
                // ** MonitorExit[var7_7] (shouldn't be in output)
                return (T)mgmt.getLocationManager().createLocation(spec);
            }
        }

        private Optional<Location> findPortForwardManager(ManagementContext mgmt, String scope) {
            return Iterables.tryFind((Iterable)mgmt.getLocationManager().getLocations(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(PortForwardManager.class), LocationPredicates.configEqualTo(PortForwardManager.SCOPE, scope)));
        }
    }
}

