/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.compute;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.Template;
import org.jclouds.digitalocean2.DigitalOcean2Api;
import org.jclouds.digitalocean2.compute.internal.ImageInRegion;
import org.jclouds.digitalocean2.compute.options.DigitalOcean2TemplateOptions;
import org.jclouds.digitalocean2.domain.Droplet;
import org.jclouds.digitalocean2.domain.DropletCreate;
import org.jclouds.digitalocean2.domain.Image;
import org.jclouds.digitalocean2.domain.Region;
import org.jclouds.digitalocean2.domain.Size;
import org.jclouds.digitalocean2.domain.options.CreateDropletOptions;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.logging.Logger;

public class DigitalOcean2ComputeServiceAdapter
implements ComputeServiceAdapter<Droplet, Size, ImageInRegion, Region> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final DigitalOcean2Api api;
    private final Predicate<Integer> nodeRunningPredicate;
    private final Predicate<Integer> nodeStoppedPredicate;
    private final Predicate<Integer> nodeTerminatedPredicate;

    @Inject
    DigitalOcean2ComputeServiceAdapter(DigitalOcean2Api api, @Named(value="jclouds.compute.timeout.node-running") Predicate<Integer> nodeRunningPredicate, @Named(value="jclouds.compute.timeout.node-suspended") Predicate<Integer> nodeStoppedPredicate, @Named(value="jclouds.compute.timeout.node-terminated") Predicate<Integer> nodeTerminatedPredicate) {
        this.api = api;
        this.nodeRunningPredicate = nodeRunningPredicate;
        this.nodeStoppedPredicate = nodeStoppedPredicate;
        this.nodeTerminatedPredicate = nodeTerminatedPredicate;
    }

    private void setUserDataIfSupported(Template template, CreateDropletOptions.Builder options, String userData) {
        List regionFeatures = (List)template.getLocation().getMetadata().get("features");
        if (regionFeatures.contains("metadata")) {
            options.userData(userData);
        } else {
            this.logger.debug(">> region %s does not support metadata, ignoring provided user data", new Object[]{template.getLocation().getId()});
        }
    }

    public ComputeServiceAdapter.NodeAndInitialCredentials<Droplet> createNodeWithGroupEncodedIntoName(String group, String name, Template template) {
        DigitalOcean2TemplateOptions templateOptions = (DigitalOcean2TemplateOptions)template.getOptions().as(DigitalOcean2TemplateOptions.class);
        CreateDropletOptions.Builder options = CreateDropletOptions.builder();
        options.privateNetworking(templateOptions.getPrivateNetworking());
        options.backupsEnabled(templateOptions.getBackupsEnabled());
        if (!templateOptions.getSshKeyIds().isEmpty()) {
            options.addSshKeyIds(templateOptions.getSshKeyIds());
        }
        if (null != templateOptions.getUserData()) {
            this.setUserDataIfSupported(template, options, new String(templateOptions.getUserData()));
        } else if (null != templateOptions.getUserMetadata().get("user_data")) {
            this.setUserDataIfSupported(template, options, templateOptions.getUserMetadata().get("user_data"));
        }
        DropletCreate dropletCreated = this.api.dropletApi().create(name, template.getLocation().getId(), template.getHardware().getProviderId(), template.getImage().getProviderId(), options.build());
        this.nodeRunningPredicate.apply((Object)dropletCreated.droplet().id());
        Droplet droplet = this.api.dropletApi().get(dropletCreated.droplet().id());
        LoginCredentials defaultCredentials = LoginCredentials.builder().user("root").privateKey(templateOptions.getLoginPrivateKey()).build();
        return new ComputeServiceAdapter.NodeAndInitialCredentials((Object)droplet, String.valueOf(droplet.id()), defaultCredentials);
    }

    public Iterable<ImageInRegion> listImages() {
        final HashSet availableRegionsIds = Sets.newHashSet((Iterable)Iterables.transform(this.listLocations(), (Function)new Function<Region, String>(){

            public String apply(Region input) {
                return input.slug();
            }
        }));
        return Iterables.concat((Iterable)Iterables.filter((Iterable)this.api.imageApi().list().concat().transform((Function)new Function<Image, Iterable<ImageInRegion>>(){

            public Iterable<ImageInRegion> apply(final Image image) {
                return Iterables.transform(image.regions(), (Function)new Function<String, ImageInRegion>(){

                    public ImageInRegion apply(String region) {
                        return availableRegionsIds.contains(region) ? ImageInRegion.create(image, region) : null;
                    }
                });
            }
        }), (Predicate)Predicates.notNull()));
    }

    public Iterable<Size> listHardwareProfiles() {
        return Iterables.filter((Iterable)this.api.sizeApi().list().concat(), (Predicate)new Predicate<Size>(){

            public boolean apply(Size size) {
                return size.available();
            }
        });
    }

    public Iterable<Region> listLocations() {
        return Iterables.filter((Iterable)this.api.regionApi().list().concat(), (Predicate)new Predicate<Region>(){

            public boolean apply(Region region) {
                return region.available();
            }
        });
    }

    public Iterable<Droplet> listNodes() {
        return this.api.dropletApi().list().concat();
    }

    public Iterable<Droplet> listNodesByIds(final Iterable<String> ids) {
        return Iterables.filter(this.listNodes(), (Predicate)new Predicate<Droplet>(){

            public boolean apply(Droplet droplet) {
                return Iterables.contains((Iterable)ids, (Object)String.valueOf(droplet.id()));
            }
        });
    }

    public ImageInRegion getImage(String id) {
        String region = ImageInRegion.extractRegion(id);
        String imageId = ImageInRegion.extractImageId(id);
        Integer numericId = Ints.tryParse((String)imageId);
        Image image = numericId == null ? this.api.imageApi().get(imageId) : this.api.imageApi().get(numericId);
        return image == null ? null : ImageInRegion.create(image, region);
    }

    public Droplet getNode(String id) {
        return this.api.dropletApi().get(Integer.parseInt(id));
    }

    public void destroyNode(String id) {
        int dropletId = Integer.parseInt(id);
        this.api.dropletApi().delete(dropletId);
        Preconditions.checkState((boolean)this.nodeTerminatedPredicate.apply((Object)dropletId), (Object)"node was not destroyed in the configured timeout");
    }

    public void rebootNode(String id) {
        int dropletId = Integer.parseInt(id);
        this.api.dropletApi().reboot(dropletId);
        Preconditions.checkState((boolean)this.nodeRunningPredicate.apply((Object)dropletId), (Object)"node did not restart in the configured timeout");
    }

    public void resumeNode(String id) {
        int dropletId = Integer.parseInt(id);
        this.api.dropletApi().powerOn(dropletId);
        Preconditions.checkState((boolean)this.nodeRunningPredicate.apply((Object)dropletId), (Object)"node did not started in the configured timeout");
    }

    public void suspendNode(String id) {
        int dropletId = Integer.parseInt(id);
        this.api.dropletApi().powerOff(dropletId);
        Preconditions.checkState((boolean)this.nodeStoppedPredicate.apply((Object)dropletId), (Object)"node did not stop in the configured timeout");
    }
}

