/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.beans.ConstructorProperties;
import java.net.URI;
import org.jclouds.javax.annotation.Nullable;

public class Endpoint {
    private final String id;
    private final String tenantId;
    private final String region;
    private final URI publicURL;
    private final URI internalURL;
    private final URI adminURL;
    private final String versionId;
    private final URI versionInfo;
    private final URI versionList;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromEndpoint(this);
    }

    @ConstructorProperties(value={"id", "versionId", "region", "publicURL", "internalURL", "adminURL", "versionInfo", "versionList", "tenantName", "tenantId"})
    protected Endpoint(@Nullable String id, @Nullable String versionId, @Nullable String region, @Nullable URI publicURL, @Nullable URI internalURL, @Nullable URI adminURL, @Nullable URI versionInfo, @Nullable URI versionList, @Nullable String tenantName, @Nullable String tenantId) {
        this.id = id;
        this.versionId = versionId;
        this.tenantId = tenantId != null ? tenantId : tenantName;
        this.region = region;
        this.publicURL = publicURL;
        this.internalURL = internalURL;
        this.adminURL = adminURL;
        this.versionInfo = versionInfo;
        this.versionList = versionList;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    @Nullable
    public String getVersionId() {
        return this.versionId;
    }

    @Nullable
    public String getRegion() {
        return this.region;
    }

    @Nullable
    public URI getPublicURL() {
        return this.publicURL;
    }

    @Nullable
    public URI getInternalURL() {
        return this.internalURL;
    }

    @Nullable
    public URI getAdminURL() {
        return this.adminURL;
    }

    @Nullable
    public URI getVersionInfo() {
        return this.versionInfo;
    }

    @Nullable
    public URI getVersionList() {
        return this.versionList;
    }

    @Nullable
    public String getTenantId() {
        return this.tenantId;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.versionId, this.region, this.publicURL, this.internalURL, this.adminURL, this.versionInfo, this.versionList, this.tenantId});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Endpoint that = (Endpoint)Endpoint.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.versionId, (Object)that.versionId) && Objects.equal((Object)this.region, (Object)that.region) && Objects.equal((Object)this.publicURL, (Object)that.publicURL) && Objects.equal((Object)this.internalURL, (Object)that.internalURL) && Objects.equal((Object)this.adminURL, (Object)that.adminURL) && Objects.equal((Object)this.versionInfo, (Object)that.versionInfo) && Objects.equal((Object)this.versionList, (Object)that.versionList) && Objects.equal((Object)this.tenantId, (Object)that.tenantId);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("versionId", (Object)this.versionId).add("region", (Object)this.region).add("publicURL", (Object)this.publicURL).add("internalURL", (Object)this.internalURL).add("adminURL", (Object)this.adminURL).add("versionInfo", (Object)this.versionInfo).add("versionList", (Object)this.versionList).add("tenantId", (Object)this.tenantId);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected String versionId;
        protected String region;
        protected URI publicURL;
        protected URI internalURL;
        protected URI adminURL;
        protected String tenantId;
        protected URI versionInfo;
        protected URI versionList;

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T versionId(String versionId) {
            this.versionId = versionId;
            return this.self();
        }

        public T region(String region) {
            this.region = region;
            return this.self();
        }

        public T publicURL(URI publicURL) {
            this.publicURL = publicURL;
            return this.self();
        }

        public T internalURL(URI internalURL) {
            this.internalURL = internalURL;
            return this.self();
        }

        public T adminURL(URI adminURL) {
            this.adminURL = adminURL;
            return this.self();
        }

        public T versionInfo(URI versionInfo) {
            this.versionInfo = versionInfo;
            return this.self();
        }

        public T versionList(URI versionList) {
            this.versionList = versionList;
            return this.self();
        }

        public T publicURL(String publicURL) {
            return this.publicURL(URI.create(publicURL));
        }

        public T internalURL(String internalURL) {
            return this.internalURL(URI.create(internalURL));
        }

        public T adminURL(String adminURL) {
            return this.adminURL(URI.create(adminURL));
        }

        public T versionInfo(String versionInfo) {
            return this.versionInfo(URI.create(versionInfo));
        }

        public T versionList(String versionList) {
            return this.versionList(URI.create(versionList));
        }

        public T tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this.self();
        }

        public Endpoint build() {
            return new Endpoint(this.id, this.versionId, this.region, this.publicURL, this.internalURL, this.adminURL, this.versionInfo, this.versionList, null, this.tenantId);
        }

        public T fromEndpoint(Endpoint in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.versionId(in.getVersionId())).region(in.getRegion())).publicURL(in.getPublicURL())).internalURL(in.getInternalURL())).adminURL(in.getAdminURL())).versionInfo(in.getVersionInfo())).versionList(in.getVersionList())).tenantId(in.getTenantId());
        }
    }
}

