/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.camp.server.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;

public class ApiErrorDto {
    private final String message;
    private final String details;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder fromThrowable(Throwable t) {
        Preconditions.checkNotNull((Object)t, (Object)"throwable");
        String message = (String)Optional.fromNullable((Object)t.getMessage()).or((Object)t.getClass().getName());
        return ApiErrorDto.builder().message(message).details(Throwables.getStackTraceAsString((Throwable)t));
    }

    public ApiErrorDto(@JsonProperty(value="message") String message, @JsonProperty(value="details") String details) {
        this.message = (String)Preconditions.checkNotNull((Object)message, (Object)"message");
        this.details = details != null ? details : "";
    }

    public String getMessage() {
        return this.message;
    }

    public String getDetails() {
        return this.details;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ApiErrorDto that = (ApiErrorDto)ApiErrorDto.class.cast(other);
        return Objects.equal((Object)this.message, (Object)that.message) && Objects.equal((Object)this.details, (Object)that.details);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.message, this.details});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("message", (Object)this.message).add("details", (Object)this.details).toString();
    }

    public static class Builder {
        private String message;
        private String details;

        public Builder message(String message) {
            this.message = (String)Preconditions.checkNotNull((Object)message, (Object)"message");
            return this;
        }

        public Builder details(String details) {
            this.details = (String)Preconditions.checkNotNull((Object)details, (Object)"details");
            return this;
        }

        public ApiErrorDto build() {
            return new ApiErrorDto(this.message, this.details);
        }

        public Builder fromApiErrorDto(ApiErrorDto error) {
            return this.message(error.message).details(error.details);
        }
    }
}

