/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecloudstorage.domain;

import java.util.Date;
import java.util.List;
import org.jclouds.googlecloud.internal.NullSafeCopies;
import org.jclouds.googlecloudstorage.domain.AutoValue_Bucket;
import org.jclouds.googlecloudstorage.domain.AutoValue_Bucket_Cors;
import org.jclouds.googlecloudstorage.domain.AutoValue_Bucket_LifeCycle;
import org.jclouds.googlecloudstorage.domain.AutoValue_Bucket_LifeCycle_Rule;
import org.jclouds.googlecloudstorage.domain.AutoValue_Bucket_LifeCycle_Rule_Action;
import org.jclouds.googlecloudstorage.domain.AutoValue_Bucket_LifeCycle_Rule_Condition;
import org.jclouds.googlecloudstorage.domain.AutoValue_Bucket_Logging;
import org.jclouds.googlecloudstorage.domain.AutoValue_Bucket_Versioning;
import org.jclouds.googlecloudstorage.domain.AutoValue_Bucket_Website;
import org.jclouds.googlecloudstorage.domain.BucketAccessControls;
import org.jclouds.googlecloudstorage.domain.DomainResourceReferences;
import org.jclouds.googlecloudstorage.domain.ObjectAccessControls;
import org.jclouds.googlecloudstorage.domain.Owner;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class Bucket {
    public abstract String id();

    public abstract String name();

    @Nullable
    public abstract Long projectNumber();

    public abstract Date timeCreated();

    public abstract Long metageneration();

    public abstract List<BucketAccessControls> acl();

    public abstract List<ObjectAccessControls> defaultObjectAcl();

    @Nullable
    public abstract Owner owner();

    @Nullable
    public abstract DomainResourceReferences.Location location();

    @Nullable
    public abstract Website website();

    @Nullable
    public abstract Logging logging();

    @Nullable
    public abstract Versioning versioning();

    public abstract List<Cors> cors();

    @Nullable
    public abstract LifeCycle lifeCycle();

    @Nullable
    public abstract DomainResourceReferences.StorageClass storageClass();

    @SerializedNames(value={"id", "name", "projectNumber", "timeCreated", "metageneration", "acl", "defaultObjectAcl", "owner", "location", "website", "logging", "versioning", "cors", "lifeCycle", "storageClass"})
    public static Bucket create(String id, String name, Long projectNumber, Date timeCreated, Long metageneration, List<BucketAccessControls> acl, List<ObjectAccessControls> defaultObjectAcl, Owner owner, DomainResourceReferences.Location location, Website website, Logging logging, Versioning versioning, List<Cors> cors, LifeCycle lifeCycle, DomainResourceReferences.StorageClass storageClass) {
        return new AutoValue_Bucket(id, name, projectNumber, timeCreated, metageneration, NullSafeCopies.copyOf(acl), NullSafeCopies.copyOf(defaultObjectAcl), owner, location, website, logging, versioning, NullSafeCopies.copyOf(cors), lifeCycle, storageClass);
    }

    public static abstract class Versioning {
        public abstract Boolean enabled();

        @SerializedNames(value={"enabled"})
        public static Versioning create(Boolean enabled) {
            return new AutoValue_Bucket_Versioning(enabled);
        }
    }

    public static abstract class Website {
        @Nullable
        public abstract String mainPageSuffix();

        @Nullable
        public abstract String notFoundPage();

        @SerializedNames(value={"mainPageSuffix", "notFoundPage"})
        public static Website create(String mainPageSuffix, String notFoundPage) {
            return new AutoValue_Bucket_Website(mainPageSuffix, notFoundPage);
        }
    }

    public static abstract class LifeCycle {
        public abstract List<Rule> rules();

        @SerializedNames(value={"rules"})
        public static LifeCycle create(List<Rule> rules) {
            return new AutoValue_Bucket_LifeCycle(NullSafeCopies.copyOf(rules));
        }

        public static abstract class Rule {
            public abstract Action action();

            public abstract Condition condition();

            @SerializedNames(value={"action", "condition"})
            public static Rule create(Action action, Condition condition) {
                return new AutoValue_Bucket_LifeCycle_Rule(action, condition);
            }

            public static abstract class Condition {
                @Nullable
                public abstract Integer age();

                @Nullable
                public abstract Date createdBefore();

                @Nullable
                public abstract Boolean isLive();

                @Nullable
                public abstract Integer numNewerVersions();

                @SerializedNames(value={"age", "createdBefore", "isLive", "numNewerVersions"})
                public static Condition create(Integer age, Date createdBefore, Boolean isLive, Integer numNewerVersions) {
                    return new AutoValue_Bucket_LifeCycle_Rule_Condition(age, createdBefore, isLive, numNewerVersions);
                }
            }

            public static abstract class Action {
                public abstract String type();

                @SerializedNames(value={"type"})
                public static Action create(String type) {
                    return new AutoValue_Bucket_LifeCycle_Rule_Action(type);
                }
            }
        }
    }

    public static abstract class Logging {
        public abstract String logBucket();

        @Nullable
        public abstract String logObjectPrefix();

        @SerializedNames(value={"logBucket", "logObjectPrefix"})
        public static Logging create(String logBucket, String logObjectPrefix) {
            return new AutoValue_Bucket_Logging(logBucket, logObjectPrefix);
        }
    }

    public static abstract class Cors {
        public abstract List<String> origin();

        public abstract List<String> method();

        public abstract List<String> responseHeader();

        public abstract Integer maxAgeSeconds();

        @SerializedNames(value={"origin", "method", "responseHeader", "maxAgeSeconds"})
        public static Cors create(List<String> origin, List<String> method, List<String> responseHeader, Integer maxAgeSeconds) {
            return new AutoValue_Bucket_Cors(NullSafeCopies.copyOf(origin), NullSafeCopies.copyOf(method), NullSafeCopies.copyOf(responseHeader), maxAgeSeconds);
        }
    }
}

