/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.filesystem.strategy.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingInputStream;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteSource;
import com.google.common.io.FileWriteMode;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserDefinedFileAttributeView;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.KeyNotFoundException;
import org.jclouds.blobstore.LocalStorageStrategy;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobAccess;
import org.jclouds.blobstore.domain.BlobBuilder;
import org.jclouds.blobstore.domain.ContainerAccess;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.domain.Tier;
import org.jclouds.blobstore.domain.internal.MutableStorageMetadataImpl;
import org.jclouds.blobstore.options.CreateContainerOptions;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.reference.BlobStoreConstants;
import org.jclouds.domain.Location;
import org.jclouds.filesystem.predicates.validators.FilesystemBlobKeyValidator;
import org.jclouds.filesystem.predicates.validators.FilesystemContainerNameValidator;
import org.jclouds.filesystem.util.Utils;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.io.Payload;
import org.jclouds.logging.Logger;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.annotations.ParamValidators;
import org.jclouds.util.Closeables2;

public class FilesystemStorageStrategyImpl
implements LocalStorageStrategy {
    private static final String XATTR_CACHE_CONTROL = "user.cache-control";
    private static final String XATTR_CONTENT_DISPOSITION = "user.content-disposition";
    private static final String XATTR_CONTENT_ENCODING = "user.content-encoding";
    private static final String XATTR_CONTENT_LANGUAGE = "user.content-language";
    private static final String XATTR_CONTENT_MD5 = "user.content-md5";
    private static final String XATTR_CONTENT_TYPE = "user.content-type";
    private static final String XATTR_EXPIRES = "user.expires";
    private static final String XATTR_STORAGE_TIER = "user.storage-tier";
    private static final String XATTR_USER_METADATA_PREFIX = "user.user-metadata.";
    private static final byte[] DIRECTORY_MD5 = Hashing.md5().hashBytes(new byte[0]).asBytes();
    @Resource
    protected Logger logger = Logger.NULL;
    protected final Provider<BlobBuilder> blobBuilders;
    protected final String baseDirectory;
    protected final boolean autoDetectContentType;
    protected final FilesystemContainerNameValidator filesystemContainerNameValidator;
    protected final FilesystemBlobKeyValidator filesystemBlobKeyValidator;
    private final Supplier<Location> defaultLocation;

    @Inject
    protected FilesystemStorageStrategyImpl(Provider<BlobBuilder> blobBuilders, @Named(value="jclouds.filesystem.basedir") String baseDir, @Named(value="jclouds.filesystem.auto-detect-content-type") boolean autoDetectContentType, FilesystemContainerNameValidator filesystemContainerNameValidator, FilesystemBlobKeyValidator filesystemBlobKeyValidator, Supplier<Location> defaultLocation) {
        this.blobBuilders = (Provider)Preconditions.checkNotNull(blobBuilders, (Object)"filesystem storage strategy blobBuilders");
        this.baseDirectory = (String)Preconditions.checkNotNull((Object)baseDir, (Object)"filesystem storage strategy base directory");
        this.autoDetectContentType = autoDetectContentType;
        this.filesystemContainerNameValidator = (FilesystemContainerNameValidator)((Object)Preconditions.checkNotNull((Object)((Object)filesystemContainerNameValidator), (Object)"filesystem container name validator"));
        this.filesystemBlobKeyValidator = (FilesystemBlobKeyValidator)((Object)Preconditions.checkNotNull((Object)((Object)filesystemBlobKeyValidator), (Object)"filesystem blob key validator"));
        this.defaultLocation = defaultLocation;
    }

    public boolean containerExists(String container) {
        this.filesystemContainerNameValidator.validate(container);
        return this.directoryExists(container, null);
    }

    public Collection<String> getAllContainerNames() {
        File[] files = new File(this.buildPathStartingFromBaseDir(new String[0])).listFiles();
        if (files == null) {
            return ImmutableList.of();
        }
        ImmutableList.Builder containers = ImmutableList.builder();
        for (File file : files) {
            if (!file.isDirectory()) continue;
            containers.add((Object)file.getName());
        }
        return containers.build();
    }

    public boolean createContainerInLocation(String container, Location location, CreateContainerOptions options) {
        this.logger.debug("Creating container %s", new Object[]{container});
        this.filesystemContainerNameValidator.validate(container);
        boolean created = this.createDirectoryWithResult(container, null);
        if (created) {
            this.setContainerAccess(container, options.isPublicRead() ? ContainerAccess.PUBLIC_READ : ContainerAccess.PRIVATE);
        }
        return created;
    }

    public ContainerAccess getContainerAccess(String container) {
        Set<PosixFilePermission> permissions;
        Path path = new File(this.buildPathStartingFromBaseDir(container)).toPath();
        if (Utils.isWindows()) {
            try {
                if (Utils.isPrivate(path)) {
                    return ContainerAccess.PRIVATE;
                }
                return ContainerAccess.PUBLIC_READ;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            permissions = Files.getPosixFilePermissions(path, new LinkOption[0]);
        }
        catch (IOException ioe) {
            throw Throwables.propagate((Throwable)ioe);
        }
        return permissions.contains((Object)PosixFilePermission.OTHERS_READ) ? ContainerAccess.PUBLIC_READ : ContainerAccess.PRIVATE;
    }

    public void setContainerAccess(String container, ContainerAccess access) {
        Path path = new File(this.buildPathStartingFromBaseDir(container)).toPath();
        if (Utils.isWindows()) {
            try {
                if (access == ContainerAccess.PRIVATE) {
                    Utils.setPrivate(path);
                }
                Utils.setPublic(path);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            try {
                Set<PosixFilePermission> permissions = Files.getPosixFilePermissions(path, new LinkOption[0]);
                if (access == ContainerAccess.PRIVATE) {
                    permissions.remove((Object)PosixFilePermission.OTHERS_READ);
                } else if (access == ContainerAccess.PUBLIC_READ) {
                    permissions.add(PosixFilePermission.OTHERS_READ);
                }
                Files.setPosixFilePermissions(path, permissions);
            }
            catch (IOException ioe) {
                throw Throwables.propagate((Throwable)ioe);
            }
        }
    }

    public void deleteContainer(String container) {
        this.filesystemContainerNameValidator.validate(container);
        if (!this.containerExists(container)) {
            return;
        }
        this.deleteDirectory(container, null);
    }

    public void clearContainer(String container) {
        this.clearContainer(container, ListContainerOptions.Builder.recursive());
    }

    public void clearContainer(String container, ListContainerOptions options) {
        this.filesystemContainerNameValidator.validate(container);
        Preconditions.checkArgument((options.getDir() == null || options.getPrefix() == null ? 1 : 0) != 0, (Object)"cannot specify both directory and prefix");
        String optsPrefix = Strings.nullToEmpty((String)(options.getDir() == null ? options.getPrefix() : options.getDir()));
        String normalizedOptsPath = FilesystemStorageStrategyImpl.normalize(optsPrefix);
        String basePath = this.buildPathStartingFromBaseDir(container, normalizedOptsPath);
        this.filesystemBlobKeyValidator.validate(basePath);
        try {
            File object = new File(basePath);
            if (object.isFile()) {
                Utils.delete(object);
            } else if (object.isDirectory() && (optsPrefix.endsWith(File.separator) || Strings.isNullOrEmpty((String)optsPrefix))) {
                File containerFile = this.openFolder(container + File.separator + normalizedOptsPath);
                File[] children = containerFile.listFiles();
                if (null != children) {
                    for (File child : children) {
                        if (options.isRecursive()) {
                            Utils.deleteRecursively(child);
                            continue;
                        }
                        if (!child.isFile()) continue;
                        Utils.delete(child);
                    }
                }
                if (!optsPrefix.isEmpty()) {
                    if (options.isRecursive()) {
                        this.deleteDirectory(container, optsPrefix);
                    }
                    this.removeDirectoriesTreeOfBlobKey(container, optsPrefix);
                }
            }
        }
        catch (IOException e) {
            this.logger.error((Throwable)e, "An error occurred while clearing container %s", new Object[]{container});
            Throwables.propagate((Throwable)e);
        }
    }

    public StorageMetadata getContainerMetadata(String container) {
        BasicFileAttributes attr;
        MutableStorageMetadataImpl metadata = new MutableStorageMetadataImpl();
        metadata.setName(container);
        metadata.setType((Enum)StorageType.CONTAINER);
        metadata.setLocation(this.getLocation(container));
        Path path = new File(this.buildPathStartingFromBaseDir(container)).toPath();
        try {
            attr = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (NoSuchFileException nsfe) {
            return null;
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        metadata.setCreationDate(new Date(attr.creationTime().toMillis()));
        return metadata;
    }

    public boolean blobExists(String container, String key) {
        this.filesystemContainerNameValidator.validate(container);
        this.filesystemBlobKeyValidator.validate(key);
        try {
            return this.buildPathAndChecksIfBlobExists(container, key);
        }
        catch (IOException e) {
            this.logger.error((Throwable)e, "An error occurred while checking key %s in container %s", new Object[]{container, key});
            throw Throwables.propagate((Throwable)e);
        }
    }

    public Iterable<String> getBlobKeysInsideContainer(String container, String prefix) throws IOException {
        this.filesystemContainerNameValidator.validate(container);
        HashSet blobNames = Sets.newHashSet();
        if (!this.containerExists(container)) {
            return blobNames;
        }
        File containerFile = this.openFolder(container);
        final int containerPathLength = containerFile.getAbsolutePath().length() + 1;
        FilesystemStorageStrategyImpl.populateBlobKeysInContainer(containerFile, blobNames, prefix, new Function<String, String>(){

            public String apply(String string) {
                return FilesystemStorageStrategyImpl.denormalize(string.substring(containerPathLength));
            }
        });
        return blobNames;
    }

    public Blob getBlob(String container, String key) {
        File file;
        BlobBuilder builder;
        block15: {
            ByteSource byteSource;
            builder = (BlobBuilder)this.blobBuilders.get();
            builder.name(key);
            file = this.getFileForBlobKey(container, key);
            if (FilesystemStorageStrategyImpl.getDirectoryBlobSuffix(key) != null) {
                if (!file.isDirectory()) {
                    return null;
                }
                this.logger.debug("%s - %s is a directory", new Object[]{container, key});
                byteSource = ByteSource.empty();
            } else {
                byteSource = com.google.common.io.Files.asByteSource((File)file);
            }
            try {
                String cacheControl = null;
                String contentDisposition = null;
                String contentEncoding = null;
                String contentLanguage = null;
                String contentType = null;
                HashCode hashCode = null;
                Date expires = null;
                Tier tier = Tier.STANDARD;
                ImmutableMap.Builder userMetadata = ImmutableMap.builder();
                UserDefinedFileAttributeView view = this.getUserDefinedFileAttributeView(file.toPath());
                if (view != null) {
                    try {
                        String tierString;
                        ByteBuffer buf;
                        ImmutableSet attributes = ImmutableSet.copyOf(view.list());
                        cacheControl = FilesystemStorageStrategyImpl.readStringAttributeIfPresent(view, (Set<String>)attributes, XATTR_CACHE_CONTROL);
                        contentDisposition = FilesystemStorageStrategyImpl.readStringAttributeIfPresent(view, (Set<String>)attributes, XATTR_CONTENT_DISPOSITION);
                        contentEncoding = FilesystemStorageStrategyImpl.readStringAttributeIfPresent(view, (Set<String>)attributes, XATTR_CONTENT_ENCODING);
                        contentLanguage = FilesystemStorageStrategyImpl.readStringAttributeIfPresent(view, (Set<String>)attributes, XATTR_CONTENT_LANGUAGE);
                        contentType = FilesystemStorageStrategyImpl.readStringAttributeIfPresent(view, (Set<String>)attributes, XATTR_CONTENT_TYPE);
                        if (contentType == null && this.autoDetectContentType) {
                            contentType = Files.probeContentType(file.toPath());
                        }
                        if (attributes.contains(XATTR_CONTENT_MD5)) {
                            buf = ByteBuffer.allocate(view.size(XATTR_CONTENT_MD5));
                            view.read(XATTR_CONTENT_MD5, buf);
                            hashCode = HashCode.fromBytes((byte[])buf.array());
                        }
                        if (attributes.contains(XATTR_EXPIRES)) {
                            buf = ByteBuffer.allocate(view.size(XATTR_EXPIRES));
                            view.read(XATTR_EXPIRES, buf);
                            buf.flip();
                            expires = new Date(buf.asLongBuffer().get());
                        }
                        if ((tierString = FilesystemStorageStrategyImpl.readStringAttributeIfPresent(view, (Set<String>)attributes, XATTR_STORAGE_TIER)) != null) {
                            tier = Tier.valueOf((String)tierString);
                        }
                        for (String attribute : attributes) {
                            if (!attribute.startsWith(XATTR_USER_METADATA_PREFIX)) continue;
                            String value = FilesystemStorageStrategyImpl.readStringAttributeIfPresent(view, (Set<String>)attributes, attribute);
                            userMetadata.put((Object)attribute.substring(XATTR_USER_METADATA_PREFIX.length()), (Object)value);
                        }
                    }
                    catch (IOException e) {
                        this.logger.debug("xattrs not supported on %s", new Object[]{file.toPath()});
                    }
                    builder.payload(byteSource).cacheControl(cacheControl).contentDisposition(contentDisposition).contentEncoding(contentEncoding).contentLanguage(contentLanguage).contentLength(byteSource.size()).contentMD5(hashCode).contentType(contentType).expires(expires).tier(tier).userMetadata((Map)userMetadata.build());
                    break block15;
                }
                builder.payload(byteSource).contentLength(byteSource.size()).contentMD5(byteSource.hash(Hashing.md5()).asBytes());
            }
            catch (FileNotFoundException fnfe) {
                return null;
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        Blob blob = builder.build();
        blob.getMetadata().setContainer(container);
        blob.getMetadata().setLastModified(new Date(file.lastModified()));
        blob.getMetadata().setSize(Long.valueOf(file.length()));
        if (blob.getPayload().getContentMetadata().getContentMD5() != null) {
            blob.getMetadata().setETag(BaseEncoding.base16().lowerCase().encode(blob.getPayload().getContentMetadata().getContentMD5()));
        }
        return blob;
    }

    private void writeCommonMetadataAttr(UserDefinedFileAttributeView view, Blob blob) throws IOException {
        MutableContentMetadata metadata = blob.getMetadata().getContentMetadata();
        FilesystemStorageStrategyImpl.writeStringAttributeIfPresent(view, XATTR_CACHE_CONTROL, metadata.getCacheControl());
        FilesystemStorageStrategyImpl.writeStringAttributeIfPresent(view, XATTR_CONTENT_DISPOSITION, metadata.getContentDisposition());
        FilesystemStorageStrategyImpl.writeStringAttributeIfPresent(view, XATTR_CONTENT_ENCODING, metadata.getContentEncoding());
        FilesystemStorageStrategyImpl.writeStringAttributeIfPresent(view, XATTR_CONTENT_LANGUAGE, metadata.getContentLanguage());
        FilesystemStorageStrategyImpl.writeStringAttributeIfPresent(view, XATTR_CONTENT_TYPE, metadata.getContentType());
        Date expires = metadata.getExpires();
        if (expires != null) {
            ByteBuffer buf = ByteBuffer.allocate(8).putLong(expires.getTime());
            buf.flip();
            view.write(XATTR_EXPIRES, buf);
        }
        FilesystemStorageStrategyImpl.writeStringAttributeIfPresent(view, XATTR_STORAGE_TIER, blob.getMetadata().getTier().toString());
        for (Map.Entry entry : blob.getMetadata().getUserMetadata().entrySet()) {
            FilesystemStorageStrategyImpl.writeStringAttributeIfPresent(view, XATTR_USER_METADATA_PREFIX + (String)entry.getKey(), (String)entry.getValue());
        }
    }

    private String putDirectoryBlob(String containerName, Blob blob) throws IOException {
        String blobKey = blob.getMetadata().getName();
        MutableContentMetadata metadata = blob.getMetadata().getContentMetadata();
        Long contentLength = metadata.getContentLength();
        if (contentLength != null && contentLength != 0L) {
            throw new IllegalArgumentException("Directory blob cannot have content: " + blobKey);
        }
        File outputFile = this.getFileForBlobKey(containerName, blobKey);
        Path outputPath = outputFile.toPath();
        if (!outputFile.isDirectory() && !outputFile.mkdirs()) {
            throw new IOException("Unable to mkdir: " + outputPath);
        }
        UserDefinedFileAttributeView view = this.getUserDefinedFileAttributeView(outputPath);
        if (view != null) {
            try {
                view.write(XATTR_CONTENT_MD5, ByteBuffer.wrap(DIRECTORY_MD5));
                this.writeCommonMetadataAttr(view, blob);
            }
            catch (IOException e) {
                this.logger.debug("xattrs not supported on %s", new Object[]{outputPath});
            }
        } else {
            this.logger.warn("xattr not supported on %s", new Object[]{blobKey});
        }
        return BaseEncoding.base16().lowerCase().encode(DIRECTORY_MD5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String putBlob(String containerName, Blob blob) throws IOException {
        String string;
        HashingInputStream his;
        Payload payload;
        block17: {
            String blobKey = blob.getMetadata().getName();
            payload = blob.getPayload();
            this.filesystemContainerNameValidator.validate(containerName);
            this.filesystemBlobKeyValidator.validate(blobKey);
            if (FilesystemStorageStrategyImpl.getDirectoryBlobSuffix(blobKey) != null) {
                return this.putDirectoryBlob(containerName, blob);
            }
            File outputFile = this.getFileForBlobKey(containerName, blobKey);
            String tmpBlobName = blobKey + "-" + UUID.randomUUID();
            File tmpFile = this.getFileForBlobKey(containerName, tmpBlobName);
            Path tmpPath = tmpFile.toPath();
            his = null;
            try {
                UserDefinedFileAttributeView view;
                com.google.common.io.Files.createParentDirs((File)tmpFile);
                his = new HashingInputStream(Hashing.md5(), payload.openStream());
                long actualSize = com.google.common.io.Files.asByteSink((File)tmpFile, (FileWriteMode[])new FileWriteMode[0]).writeFrom((InputStream)his);
                Long expectedSize = blob.getMetadata().getContentMetadata().getContentLength();
                if (expectedSize != null && actualSize != expectedSize) {
                    throw new IOException("Content-Length mismatch, actual: " + actualSize + " expected: " + expectedSize);
                }
                HashCode actualHashCode = his.hash();
                HashCode expectedHashCode = payload.getContentMetadata().getContentMD5AsHashCode();
                if (expectedHashCode != null && !actualHashCode.equals((Object)expectedHashCode)) {
                    throw new IOException("MD5 hash code mismatch, actual: " + actualHashCode + " expected: " + expectedHashCode);
                }
                payload.getContentMetadata().setContentMD5(actualHashCode);
                if (outputFile.exists()) {
                    Utils.delete(outputFile);
                }
                if ((view = this.getUserDefinedFileAttributeView(tmpPath)) != null) {
                    try {
                        view.write(XATTR_CONTENT_MD5, ByteBuffer.wrap(actualHashCode.asBytes()));
                        this.writeCommonMetadataAttr(view, blob);
                    }
                    catch (IOException e) {
                        this.logger.debug("xattrs not supported on %s", new Object[]{tmpPath});
                    }
                }
                this.setBlobAccess(containerName, tmpBlobName, BlobAccess.PRIVATE);
                if (!tmpFile.renameTo(outputFile)) {
                    throw new IOException("Could not rename file " + tmpFile + " to " + outputFile);
                }
                tmpFile = null;
                string = BaseEncoding.base16().lowerCase().encode(actualHashCode.asBytes());
                if (tmpFile == null) break block17;
            }
            catch (Throwable throwable) {
                if (tmpFile != null) {
                    try {
                        Utils.delete(tmpFile);
                    }
                    catch (IOException e) {
                        this.logger.debug("Could not delete %s: %s", new Object[]{tmpFile, e});
                    }
                }
                Closeables2.closeQuietly(his);
                if (payload != null) {
                    payload.release();
                }
                throw throwable;
            }
            try {
                Utils.delete(tmpFile);
            }
            catch (IOException e) {
                this.logger.debug("Could not delete %s: %s", new Object[]{tmpFile, e});
            }
        }
        Closeables2.closeQuietly((Closeable)his);
        if (payload != null) {
            payload.release();
        }
        return string;
    }

    public void removeBlob(String container, String blobKey) {
        this.filesystemContainerNameValidator.validate(container);
        this.filesystemBlobKeyValidator.validate(blobKey);
        String fileName = this.buildPathStartingFromBaseDir(container, blobKey);
        this.logger.debug("Deleting blob %s", new Object[]{fileName});
        File fileToBeDeleted = new File(fileName);
        if (fileToBeDeleted.isDirectory()) {
            try {
                UserDefinedFileAttributeView view = this.getUserDefinedFileAttributeView(fileToBeDeleted.toPath());
                if (view != null) {
                    for (String s : view.list()) {
                        view.delete(s);
                    }
                }
            }
            catch (IOException e) {
                this.logger.debug("Could not delete attributes from %s: %s", new Object[]{fileToBeDeleted, e});
            }
        }
        try {
            Utils.delete(fileToBeDeleted);
        }
        catch (IOException e) {
            this.logger.debug("Could not delete %s: %s", new Object[]{fileToBeDeleted, e});
        }
        this.removeDirectoriesTreeOfBlobKey(container, blobKey);
    }

    public BlobAccess getBlobAccess(String containerName, String blobName) {
        Set<PosixFilePermission> permissions;
        if (!new File(this.buildPathStartingFromBaseDir(containerName)).exists()) {
            throw new ContainerNotFoundException(containerName, "in getBlobAccess");
        }
        File file = new File(this.buildPathStartingFromBaseDir(containerName, blobName));
        if (!file.exists()) {
            throw new KeyNotFoundException(containerName, blobName, "in getBlobAccess");
        }
        Path path = file.toPath();
        if (Utils.isWindows()) {
            try {
                if (Utils.isPrivate(path)) {
                    return BlobAccess.PRIVATE;
                }
                return BlobAccess.PUBLIC_READ;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            permissions = Files.getPosixFilePermissions(path, new LinkOption[0]);
        }
        catch (IOException ioe) {
            throw Throwables.propagate((Throwable)ioe);
        }
        return permissions.contains((Object)PosixFilePermission.OTHERS_READ) ? BlobAccess.PUBLIC_READ : BlobAccess.PRIVATE;
    }

    public void setBlobAccess(String container, String name, BlobAccess access) {
        Path path = new File(this.buildPathStartingFromBaseDir(container, name)).toPath();
        if (Utils.isWindows()) {
            try {
                if (access == BlobAccess.PRIVATE) {
                    Utils.setPrivate(path);
                }
                Utils.setPublic(path);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            try {
                Set<PosixFilePermission> permissions = Files.getPosixFilePermissions(path, new LinkOption[0]);
                if (access == BlobAccess.PRIVATE) {
                    permissions.remove((Object)PosixFilePermission.OTHERS_READ);
                } else if (access == BlobAccess.PUBLIC_READ) {
                    permissions.add(PosixFilePermission.OTHERS_READ);
                }
                Files.setPosixFilePermissions(path, permissions);
            }
            catch (IOException ioe) {
                throw Throwables.propagate((Throwable)ioe);
            }
        }
    }

    public Location getLocation(String containerName) {
        return (Location)this.defaultLocation.get();
    }

    public String getSeparator() {
        return "/";
    }

    public boolean createContainer(String container) {
        this.filesystemContainerNameValidator.validate(container);
        return this.createContainerInLocation(container, null, (CreateContainerOptions)CreateContainerOptions.NONE);
    }

    public Blob newBlob(@ParamValidators(value={FilesystemBlobKeyValidator.class}) String name) {
        this.filesystemBlobKeyValidator.validate(name);
        return ((BlobBuilder)this.blobBuilders.get()).name(name).build();
    }

    public File getFileForBlobKey(String container, String blobKey) {
        this.filesystemContainerNameValidator.validate(container);
        this.filesystemBlobKeyValidator.validate(blobKey);
        String fileName = this.buildPathStartingFromBaseDir(container, blobKey);
        File blobFile = new File(fileName);
        return blobFile;
    }

    public boolean directoryExists(String container, String directory) {
        return this.buildPathAndChecksIfDirectoryExists(container, directory);
    }

    public void createDirectory(String container, String directory) {
        this.createDirectoryWithResult(container, directory);
    }

    public void deleteDirectory(String container, String directory) {
        String fullDirPath = this.buildPathStartingFromBaseDir(container, directory);
        try {
            Utils.deleteRecursively(new File(fullDirPath));
        }
        catch (IOException ex) {
            this.logger.error("An error occurred removing directory %s.", new Object[]{fullDirPath});
            Throwables.propagate((Throwable)ex);
        }
    }

    public long countBlobs(String container, ListContainerOptions options) {
        try {
            return Iterables.size(this.getBlobKeysInsideContainer(container, null));
        }
        catch (IOException ioe) {
            throw Throwables.propagate((Throwable)ioe);
        }
    }

    private boolean buildPathAndChecksIfBlobExists(String ... tokens) throws IOException {
        boolean exists;
        String path = this.buildPathStartingFromBaseDir(tokens);
        File file = new File(path);
        boolean bl = exists = file.exists() && file.isFile();
        if (!exists && FilesystemStorageStrategyImpl.getDirectoryBlobSuffix(tokens[tokens.length - 1]) != null && file.isDirectory()) {
            UserDefinedFileAttributeView view = this.getUserDefinedFileAttributeView(file.toPath());
            try {
                exists = view != null && view.list().contains(XATTR_CONTENT_MD5);
            }
            catch (IOException ioe) {
                this.logger.debug("xattrs not supported on %s", new Object[]{file.toPath()});
            }
        }
        return exists;
    }

    private static String getDirectoryBlobSuffix(String key) {
        for (String suffix : BlobStoreConstants.DIRECTORY_SUFFIXES) {
            if (!key.endsWith(suffix)) continue;
            return suffix;
        }
        return null;
    }

    private static String directoryBlobName(String key) {
        String suffix = FilesystemStorageStrategyImpl.getDirectoryBlobSuffix(key);
        if (suffix != null) {
            if (!"/".equals(suffix)) {
                key = key.substring(0, key.lastIndexOf(suffix));
            }
            return key + "/";
        }
        return null;
    }

    protected UserDefinedFileAttributeView getUserDefinedFileAttributeView(Path path) throws IOException {
        return Files.getFileAttributeView(path, UserDefinedFileAttributeView.class, new LinkOption[0]);
    }

    private boolean buildPathAndChecksIfDirectoryExists(String ... tokens) {
        String path = this.buildPathStartingFromBaseDir(tokens);
        File file = new File(path);
        boolean exists = file.exists() || file.isDirectory();
        return exists;
    }

    protected String buildPathStartingFromBaseDir(String ... pathTokens) {
        String normalizedToken = this.removeFileSeparatorFromBorders(FilesystemStorageStrategyImpl.normalize(this.baseDirectory), true);
        StringBuilder completePath = new StringBuilder(normalizedToken);
        if (pathTokens != null && pathTokens.length > 0) {
            for (int i = 0; i < pathTokens.length; ++i) {
                if (pathTokens[i] == null) continue;
                normalizedToken = this.removeFileSeparatorFromBorders(FilesystemStorageStrategyImpl.normalize(pathTokens[i]), false);
                completePath.append(File.separator).append(normalizedToken);
            }
        }
        return completePath.toString();
    }

    private static String normalize(String path) {
        if (null != path) {
            if (Utils.isWindows()) {
                path = path.replace("\\", File.separator);
            }
            return path.replace("/", File.separator);
        }
        return path;
    }

    private static String denormalize(String path) {
        if (null != path && Utils.isWindows()) {
            return path.replace("\\", "/");
        }
        return path;
    }

    private String removeFileSeparatorFromBorders(String pathToBeCleaned, boolean onlyTrailing) {
        if (null == pathToBeCleaned || pathToBeCleaned.equals("")) {
            return pathToBeCleaned;
        }
        int beginIndex = 0;
        int endIndex = pathToBeCleaned.length();
        if (!onlyTrailing && (pathToBeCleaned.charAt(0) == '/' || pathToBeCleaned.charAt(0) == '\\' && Utils.isWindows())) {
            beginIndex = 1;
        }
        if (pathToBeCleaned.charAt(pathToBeCleaned.length() - 1) == '/' || pathToBeCleaned.charAt(pathToBeCleaned.length() - 1) == '\\' && Utils.isWindows()) {
            --endIndex;
        }
        return pathToBeCleaned.substring(beginIndex, endIndex);
    }

    private boolean isDirEmpty(String directoryPath) throws IOException {
        Path path = new File(directoryPath).toPath();
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(path);){
            boolean bl = !dirStream.iterator().hasNext();
            return bl;
        }
    }

    private void removeDirectoriesTreeOfBlobKey(String container, String blobKey) {
        block10: {
            String normalizedBlobKey = FilesystemStorageStrategyImpl.normalize(blobKey);
            File file = new File(normalizedBlobKey);
            String parentPath = file.getParent();
            if (!Strings.isNullOrEmpty((String)parentPath)) {
                File directory = new File(this.buildPathStartingFromBaseDir(container, parentPath));
                try {
                    UserDefinedFileAttributeView view = this.getUserDefinedFileAttributeView(directory.toPath());
                    if (view == null) {
                        this.logger.debug("Could not look for attributes from %s", new Object[]{directory});
                    } else if (!view.list().isEmpty()) {
                        return;
                    }
                }
                catch (IOException e) {
                    this.logger.debug("Could not look for attributes from %s: %s", new Object[]{directory, e});
                }
                try {
                    if (!this.isDirEmpty(directory.getPath())) break block10;
                    try {
                        Utils.delete(directory);
                    }
                    catch (IOException e) {
                        this.logger.debug("Could not delete %s: %s", new Object[]{directory, e});
                        return;
                    }
                    this.removeDirectoriesTreeOfBlobKey(container, parentPath);
                }
                catch (IOException e) {
                    this.logger.debug("Could not locate directory %s", new Object[]{directory, e});
                    return;
                }
            }
        }
    }

    private File openFolder(String folderName) throws IOException {
        String baseFolderName = this.buildPathStartingFromBaseDir(folderName);
        File folder = new File(baseFolderName);
        if (folder.exists() && !folder.isDirectory()) {
            throw new IOException("Resource " + baseFolderName + " isn't a folder.");
        }
        return folder;
    }

    private static void populateBlobKeysInContainer(File directory, Set<String> blobNames, String prefix, Function<String, String> function) {
        File[] children = directory.listFiles();
        if (children == null) {
            return;
        }
        for (File child : children) {
            String fullPath = (String)function.apply((Object)child.getAbsolutePath());
            if (child.isFile()) {
                if (prefix != null && !fullPath.startsWith(prefix)) continue;
                blobNames.add(fullPath);
                continue;
            }
            if (!child.isDirectory() || prefix != null && !fullPath.startsWith(prefix) && !prefix.startsWith(fullPath + "/")) continue;
            blobNames.add(fullPath + File.separator);
            FilesystemStorageStrategyImpl.populateBlobKeysInContainer(child, blobNames, prefix, function);
        }
    }

    protected boolean createDirectoryWithResult(String container, String directory) {
        String directoryFullName = this.buildPathStartingFromBaseDir(container, directory);
        this.logger.debug("Creating directory %s", new Object[]{directoryFullName});
        if (this.buildPathAndChecksIfDirectoryExists(container, directory)) {
            this.logger.debug("Directory %s already exists", new Object[]{directoryFullName});
            return false;
        }
        File directoryToCreate = new File(directoryFullName);
        try {
            Files.createDirectories(directoryToCreate.toPath(), new FileAttribute[0]);
        }
        catch (AccessDeniedException ade) {
            throw new AuthorizationException((Throwable)ade);
        }
        catch (IOException ioe) {
            this.logger.debug("Could not create directory: %s", new Object[]{ioe.getMessage()});
            return false;
        }
        return true;
    }

    private static String readStringAttributeIfPresent(UserDefinedFileAttributeView view, Set<String> attributes, String name) throws IOException {
        if (!attributes.contains(name)) {
            return null;
        }
        ByteBuffer buf = ByteBuffer.allocate(view.size(name));
        view.read(name, buf);
        return new String(buf.array(), StandardCharsets.UTF_8);
    }

    private static void writeStringAttributeIfPresent(UserDefinedFileAttributeView view, String name, String value) throws IOException {
        if (value != null) {
            view.write(name, ByteBuffer.wrap(value.getBytes(StandardCharsets.UTF_8)));
        }
    }

    private static void copyStringAttributeIfPresent(UserDefinedFileAttributeView view, String name, Map<String, String> attrs) throws IOException {
        FilesystemStorageStrategyImpl.writeStringAttributeIfPresent(view, name, attrs.get(name));
    }
}

