/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.policy.jclouds.os;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.AbstractEntity;
import org.apache.brooklyn.core.policy.AbstractPolicy;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.core.file.BrooklynOsCommands;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.core.internal.ssh.SshTool;
import org.apache.brooklyn.util.ssh.BashCommandsConfigurable;
import org.apache.brooklyn.util.text.Identifiers;
import org.jclouds.compute.config.AdminAccessConfiguration;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.functions.InitAdminAccess;
import org.jclouds.scriptbuilder.statements.login.AdminAccess;
import org.jclouds.scriptbuilder.statements.ssh.SshdConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class CreateUserPolicy
extends AbstractPolicy
implements SensorEventListener<Location> {
    private static final Logger LOG = LoggerFactory.getLogger(CreateUserPolicy.class);
    @SetFromFlag(value="user")
    public static final ConfigKey<String> VM_USERNAME = ConfigKeys.newStringConfigKey((String)"createuser.vm.user.name");
    @SetFromFlag(value="grantSudo")
    public static final ConfigKey<Boolean> GRANT_SUDO = ConfigKeys.newBooleanConfigKey((String)"createuser.vm.user.grantSudo", (String)"Whether to give the new user sudo rights", (Boolean)false);
    public static final AttributeSensor<String> VM_USER_CREDENTIALS = Sensors.newStringSensor((String)"createuser.vm.user.credentials", (String)"The \"<user> : <password> @ <hostname>:<port>\"");
    @SetFromFlag(value="resetLoginUser")
    public static final ConfigKey<Boolean> RESET_LOGIN_USER = ConfigKeys.newBooleanConfigKey((String)"createuser.vm.user.resetLoginUser", (String)"Whether to reset the password used for user login", (Boolean)false);

    public void setEntity(EntityLocal entity) {
        super.setEntity(entity);
        this.subscriptions().subscribe((Entity)entity, (Sensor)AbstractEntity.LOCATION_ADDED, (SensorEventListener)this);
    }

    public void onEvent(SensorEvent<Location> event) {
        Entity entity = event.getSource();
        Location loc = (Location)event.getValue();
        if (loc instanceof SshMachineLocation) {
            this.addUserAsync(entity, (SshMachineLocation)loc);
        }
    }

    protected void addUserAsync(Entity entity, SshMachineLocation machine) {
        this.getExecutionContext().execute(() -> this.addUser(entity, machine));
    }

    protected void addUser(Entity entity, SshMachineLocation machine) {
        boolean grantSudo = (Boolean)this.getRequiredConfig(GRANT_SUDO);
        boolean resetPassword = (Boolean)this.getRequiredConfig(RESET_LOGIN_USER);
        String user = (String)this.getRequiredConfig(VM_USERNAME);
        String password = Identifiers.makeRandomId((int)12);
        String hostname = machine.getAddress().getHostName();
        int port = machine.getPort();
        String creds = user + " : " + password + " @ " + hostname + ":" + port;
        LOG.info("Adding auto-generated user " + user + " @ " + hostname + ":" + port);
        AdminAccess adminAccess = AdminAccess.builder().adminUsername(user).adminPassword(password).grantSudoToAdminUser(false).resetLoginPassword(resetPassword).loginPassword(password).authorizeAdminPublicKey(false).adminPublicKey("ignored").installAdminPrivateKey(false).adminPrivateKey("ignore").lockSsh(false).build();
        OsFamily scriptOsFamily = machine.getMachineDetails().getOsDetails().isWindows() ? OsFamily.WINDOWS : OsFamily.UNIX;
        InitAdminAccess initAdminAccess = new InitAdminAccess((AdminAccess.Configuration)new AdminAccessConfiguration.Default());
        initAdminAccess.visit(adminAccess);
        String cmd = adminAccess.render(scriptOsFamily);
        BashCommandsConfigurable bash = BrooklynOsCommands.bash((Location)machine);
        int result = machine.execScript((Map)ImmutableMap.of((Object)SshTool.PROP_RUN_AS_ROOT.getName(), (Object)true), "create-user-" + user, (List)ImmutableList.of((Object)cmd), (Map)ImmutableMap.of((Object)"PATH", (Object)bash.sbinPath()));
        if (result != 0) {
            throw new IllegalStateException("Failed to auto-generate user, using command " + cmd);
        }
        cmd = new SshdConfig((Map)ImmutableMap.of((Object)"PasswordAuthentication", (Object)"yes")).render(scriptOsFamily);
        result = machine.execScript((Map)ImmutableMap.of((Object)SshTool.PROP_RUN_AS_ROOT.getName(), (Object)true), "create-user-" + user, (List)ImmutableList.of((Object)cmd), (Map)ImmutableMap.of((Object)"PATH", (Object)bash.sbinPath()));
        if (result != 0) {
            throw new IllegalStateException("Failed to enable ssh-login-with-password, using command " + cmd);
        }
        if (grantSudo) {
            ImmutableList cmds = ImmutableList.of((Object)("cat >> /etc/sudoers <<-'END_OF_JCLOUDS_FILE'\n" + user + " ALL = (ALL) NOPASSWD:ALL\nEND_OF_JCLOUDS_FILE\n"), (Object)"chmod 0440 /etc/sudoers");
            result = machine.execScript((Map)ImmutableMap.of((Object)SshTool.PROP_RUN_AS_ROOT.getName(), (Object)true), "add-user-to-sudoers-" + user, (List)cmds, (Map)ImmutableMap.of((Object)"PATH", (Object)bash.sbinPath()));
            if (result != 0) {
                throw new IllegalStateException("Failed to auto-generate user, using command " + cmds);
            }
        }
        entity.sensors().set(VM_USER_CREDENTIALS, (Object)creds);
    }
}

