/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.components.jaspi.model;

import java.util.Collections;
import java.util.List;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.config.AuthConfigProvider;
import javax.security.auth.message.module.ClientAuthModule;
import javax.security.auth.message.module.ServerAuthModule;
import org.apache.geronimo.components.jaspi.impl.ConfigProviderImpl;
import org.apache.geronimo.components.jaspi.model.AuthModuleType;
import org.apache.geronimo.components.jaspi.model.ClientAuthConfigType;
import org.apache.geronimo.components.jaspi.model.ClientAuthContextType;
import org.apache.geronimo.components.jaspi.model.ConfigProviderType;
import org.apache.geronimo.components.jaspi.model.ServerAuthConfigType;
import org.apache.geronimo.components.jaspi.model.ServerAuthContextType;

public class JaspiUtil {
    private JaspiUtil() {
    }

    public static AuthConfigProvider wrapAuthConfigProvider(ConfigProviderType configProviderType) {
        return new ConfigProviderImpl(configProviderType.getClientAuthConfig(), configProviderType.getServerAuthConfig());
    }

    public static AuthConfigProvider wrapClientAuthConfig(ClientAuthConfigType clientAuthConfigType) throws AuthException {
        List<ClientAuthConfigType> clientAuthConfig = Collections.singletonList(clientAuthConfigType);
        return new ConfigProviderImpl(clientAuthConfig, Collections.<ServerAuthConfigType>emptyList());
    }

    public static AuthConfigProvider wrapClientAuthContext(ClientAuthContextType clientAuthContextType, boolean _protected) throws AuthException {
        ClientAuthConfigType clientAuthConfigType = new ClientAuthConfigType(clientAuthContextType, _protected);
        return JaspiUtil.wrapClientAuthConfig(clientAuthConfigType);
    }

    public static AuthConfigProvider wrapClientAuthModule(String messageLayer, String appContext, String authenticationContextID, AuthModuleType<ClientAuthModule> clientAuthModuleType, boolean _protected) throws AuthException {
        ClientAuthContextType clientAuthContextType = new ClientAuthContextType(messageLayer, appContext, authenticationContextID, clientAuthModuleType);
        return JaspiUtil.wrapClientAuthContext(clientAuthContextType, _protected);
    }

    public static AuthConfigProvider wrapServerAuthConfig(ServerAuthConfigType serverAuthConfigType) throws AuthException {
        List<ServerAuthConfigType> serverAuthConfig = Collections.singletonList(serverAuthConfigType);
        return new ConfigProviderImpl(Collections.<ClientAuthConfigType>emptyList(), serverAuthConfig);
    }

    public static AuthConfigProvider wrapServerAuthContext(ServerAuthContextType serverAuthContextType, boolean _protected) throws AuthException {
        ServerAuthConfigType serverAuthConfigType = new ServerAuthConfigType(serverAuthContextType, _protected);
        return JaspiUtil.wrapServerAuthConfig(serverAuthConfigType);
    }

    public static AuthConfigProvider wrapServerAuthModule(String messageLayer, String appContext, String authenticationContextID, AuthModuleType<ServerAuthModule> serverAuthModuleType, boolean _protected) throws AuthException {
        ServerAuthContextType serverAuthContextType = new ServerAuthContextType(messageLayer, appContext, authenticationContextID, serverAuthModuleType);
        return JaspiUtil.wrapServerAuthContext(serverAuthContextType, _protected);
    }
}

