/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.text;

import com.google.common.base.Preconditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.brooklyn.util.text.Strings;

public class BrooklynVersionSyntax {
    private static final String SNAPSHOT = "SNAPSHOT";
    public static final String USABLE_REGEX = "[^:\\s/\\\\]+";
    public static final String DOT = "\\.";
    public static final String OSGI_TOKEN_CHARS = "A-Za-z0-9_-";
    public static final String OSGI_TOKEN_REGEX = "[A-Za-z0-9_-]+";
    public static final String NUMBER = "[0-9]+";
    public static final String QUALIFIER = "[A-Za-z0-9_-]+";
    public static final String BROOKLYN_QUALIFIER = "[.A-Za-z0-9_-]+";
    public static final String VALID_OSGI_VERSION_REGEX = "[0-9]+(\\.[0-9]+(\\.[0-9]+(\\.[A-Za-z0-9_-]+)?)?)?";
    public static final String GOOD_BROOKLYN_VERSION_REGEX = "[0-9]+(\\.[0-9]+(\\.[0-9]+)?)?(-[.A-Za-z0-9_-]+)?";

    private static boolean isUsable(String candidate) {
        return candidate != null && candidate.matches(USABLE_REGEX);
    }

    public static boolean isUsableVersion(String candidate) {
        return BrooklynVersionSyntax.isUsable(candidate);
    }

    public static boolean isGoodBrooklynVersion(String candidate) {
        return candidate != null && candidate.matches(GOOD_BROOKLYN_VERSION_REGEX);
    }

    public static boolean isValidOsgiVersion(String candidate) {
        return candidate != null && candidate.matches(VALID_OSGI_VERSION_REGEX);
    }

    public static String toValidOsgiVersion(String input) {
        Preconditions.checkNotNull((Object)input);
        return BrooklynVersionSyntax.toGoodVersion(input, ".", true);
    }

    public static String toValidOsgiVersionRange(String input) {
        String beginning = "";
        String ending = "";
        if (input.startsWith("[") || input.startsWith("(")) {
            beginning = input.substring(0, 1);
        }
        if (input.endsWith("]") || input.endsWith(")")) {
            ending = input.substring(input.length() - 1, input.length());
        }
        String middle = input.substring(beginning.length(), input.length() - ending.length());
        String[] middleParts = middle.split(",");
        StringBuilder result = new StringBuilder();
        result.append(beginning);
        for (int i = 0; i < middleParts.length; ++i) {
            String middlePart = middleParts[i];
            if (i != 0) {
                result.append(",");
            }
            result.append(BrooklynVersionSyntax.toValidOsgiVersion(middlePart.trim()));
        }
        result.append(ending);
        return result.toString();
    }

    public static String toGoodBrooklynVersion(String input) {
        return BrooklynVersionSyntax.toGoodVersion(input, "-", false);
    }

    private static String toGoodVersion(String input, String qualifierSeparator, boolean requireMinorAndPatch) {
        Preconditions.checkNotNull((Object)input);
        String FUZZY_REGEX = "([0-9]+(\\.[0-9]+(\\.[0-9]+)?)?)?(.*)";
        Matcher m = Pattern.compile("([0-9]+(\\.[0-9]+(\\.[0-9]+)?)?)?(.*)").matcher(input);
        if (!m.matches()) {
            throw new IllegalStateException("fuzzy matcher should match anything: '" + input + "'");
        }
        StringBuilder result = new StringBuilder();
        if (Strings.isEmpty(m.group(1))) {
            result.append("0.0.0");
        } else {
            result.append(m.group(1));
            if (requireMinorAndPatch) {
                if (Strings.isEmpty(m.group(2))) {
                    result.append(".0");
                }
                if (Strings.isEmpty(m.group(3))) {
                    result.append(".0");
                }
            }
        }
        String q = m.group(4);
        if (Strings.isNonEmpty(q)) {
            boolean collapsedUnsupported = false;
            boolean starting = true;
            result.append(qualifierSeparator);
            for (int i = 0; i < q.length(); ++i) {
                boolean include;
                char c = q.charAt(i);
                boolean unsupported = false;
                if (starting) {
                    include = 'A' <= c && 'Z' >= c || 'a' <= c && 'z' >= c || '0' <= c && '9' >= c;
                    starting = false;
                    if (!include) {
                        if (c == '-' || c == '_' || c == '.') {
                            if (q.length() == 1) {
                                unsupported = true;
                            }
                        } else {
                            unsupported = true;
                        }
                    }
                } else {
                    boolean bl = include = 'A' <= c && 'Z' >= c || 'a' <= c && 'z' >= c || '0' <= c && '9' >= c || c == '-' || c == '_';
                    if (!include && !collapsedUnsupported) {
                        unsupported = true;
                    }
                }
                if (include) {
                    result.append(c);
                    collapsedUnsupported = false;
                    continue;
                }
                if (!unsupported) continue;
                result.append('_');
                collapsedUnsupported = true;
            }
        }
        return result.toString();
    }

    public static boolean equalAsOsgiVersions(String v1, String v2) {
        if (v1 == null || v2 == null) {
            return v1 == null && v2 == null;
        }
        return BrooklynVersionSyntax.toValidOsgiVersion(v1).equals(BrooklynVersionSyntax.toValidOsgiVersion(v2));
    }

    public static boolean isSnapshot(String version) {
        if (version == null) {
            return false;
        }
        return version.toUpperCase().contains(SNAPSHOT);
    }

    public static String stripSnapshot(String input) {
        if (input == null) {
            return input;
        }
        int stripIndex = input.toUpperCase().indexOf(SNAPSHOT);
        if (stripIndex <= 0) {
            return input;
        }
        char charBeforeSnapshot = input.charAt(stripIndex - 1);
        if (charBeforeSnapshot == '.' || charBeforeSnapshot == '_' || charBeforeSnapshot == '-') {
            --stripIndex;
        }
        return stripIndex <= 0 ? input : input.substring(0, stripIndex);
    }
}

