/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.binder.firewall;

import org.jclouds.profitbricks.binder.BaseProfitBricksRequestBinder;
import org.jclouds.profitbricks.domain.Firewall;

public class AddFirewallRuleToNicRequestBinder
extends BaseProfitBricksRequestBinder<Firewall.Request.AddRulePayload> {
    private final StringBuilder requestBuilder = new StringBuilder(128);

    AddFirewallRuleToNicRequestBinder() {
        super("firewall");
    }

    @Override
    protected String createPayload(Firewall.Request.AddRulePayload payload) {
        this.requestBuilder.append("<ws:addFirewallRulesToNic>").append(String.format("<nicId>%s</nicId>", payload.nicId()));
        for (Firewall.Rule rule : payload.rules()) {
            this.requestBuilder.append("<request>").append(AddFirewallRuleToNicRequestBinder.formatIfNotEmpty("<icmpCode>%s</icmpCode>", rule.icmpCode())).append(AddFirewallRuleToNicRequestBinder.formatIfNotEmpty("<icmpType>%s</icmpType>", rule.icmpType())).append(AddFirewallRuleToNicRequestBinder.formatIfNotEmpty("<name>%s</name>", rule.name())).append(AddFirewallRuleToNicRequestBinder.formatIfNotEmpty("<portRangeEnd>%s</portRangeEnd>", rule.portRangeEnd())).append(AddFirewallRuleToNicRequestBinder.formatIfNotEmpty("<portRangeStart>%s</portRangeStart>", rule.portRangeStart())).append(AddFirewallRuleToNicRequestBinder.formatIfNotEmpty("<protocol>%s</protocol>", (Object)rule.protocol())).append(AddFirewallRuleToNicRequestBinder.formatIfNotEmpty("<sourceIp>%s</sourceIp>", rule.sourceIp())).append(AddFirewallRuleToNicRequestBinder.formatIfNotEmpty("<sourceMac>%s</sourceMac>", rule.sourceMac())).append(AddFirewallRuleToNicRequestBinder.formatIfNotEmpty("<targetIp>%s</targetIp>", rule.targetIp())).append("</request>");
        }
        this.requestBuilder.append("</ws:addFirewallRulesToNic>");
        return this.requestBuilder.toString();
    }
}

