/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.loadbalancer.internal;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.io.Closeable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.Context;
import org.jclouds.internal.BaseView;
import org.jclouds.loadbalancer.LoadBalancerService;
import org.jclouds.loadbalancer.LoadBalancerServiceContext;
import org.jclouds.location.Provider;
import org.jclouds.rest.Utils;
import org.jclouds.util.Closeables2;

@Singleton
public class LoadBalancerServiceContextImpl
extends BaseView
implements LoadBalancerServiceContext {
    private final LoadBalancerService loadBalancerService;
    private final Utils utils;

    @Inject
    public LoadBalancerServiceContextImpl(@Provider Context backend, @Provider TypeToken<? extends Context> backendType, LoadBalancerService loadBalancerService, Utils utils) {
        super(backend, backendType);
        this.utils = utils;
        this.loadBalancerService = (LoadBalancerService)Preconditions.checkNotNull((Object)loadBalancerService, (Object)"loadBalancerService");
    }

    @Override
    public LoadBalancerService getLoadBalancerService() {
        return this.loadBalancerService;
    }

    @Override
    public Utils utils() {
        return this.utils;
    }

    @Override
    public void close() {
        Closeables2.closeQuietly((Closeable)this.delegate());
    }

    public int hashCode() {
        return this.delegate().hashCode();
    }

    public String toString() {
        return this.delegate().toString();
    }

    public boolean equals(Object obj) {
        return this.delegate().equals(obj);
    }
}

