/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.java;

import com.google.common.annotations.Beta;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import java.util.concurrent.Callable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Feed;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.effector.AddSensorInitializer;
import org.apache.brooklyn.core.entity.EntityInitializers;
import org.apache.brooklyn.core.sensor.AbstractAddSensorFeed;
import org.apache.brooklyn.core.sensor.DependentConfiguration;
import org.apache.brooklyn.entity.java.UsesJmx;
import org.apache.brooklyn.feed.jmx.JmxAttributePollConfig;
import org.apache.brooklyn.feed.jmx.JmxFeed;
import org.apache.brooklyn.feed.jmx.JmxHelper;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class JmxAttributeSensor<T>
extends AbstractAddSensorFeed<T> {
    private static final Logger LOG = LoggerFactory.getLogger(JmxAttributeSensor.class);
    public static final ConfigKey<String> OBJECT_NAME = ConfigKeys.newStringConfigKey((String)"objectName", (String)"JMX object name for sensor lookup");
    public static final ConfigKey<String> ATTRIBUTE = ConfigKeys.newStringConfigKey((String)"attribute", (String)"JMX attribute to poll in object");
    public static final ConfigKey<Object> DEFAULT_VALUE = ConfigKeys.newConfigKey(Object.class, (String)"defaultValue", (String)"Default value for sensor; normally null");

    public JmxAttributeSensor() {
    }

    public JmxAttributeSensor(ConfigBag params) {
        super(params);
    }

    public void apply(final EntityLocal entity) {
        final AttributeSensor sensor = this.addSensor(entity);
        final ConfigBag params = this.initParams();
        final String objectName = (String)Preconditions.checkNotNull((Object)params.get(OBJECT_NAME), (Object)"objectName");
        final String attribute = (String)Preconditions.checkNotNull((Object)params.get(ATTRIBUTE), (Object)"attribute");
        final Object defaultValue = params.get(DEFAULT_VALUE);
        try {
            ObjectName.getInstance(objectName);
        }
        catch (MalformedObjectNameException mone) {
            throw new IllegalArgumentException("Malformed JMX object name: " + objectName, mone);
        }
        final Boolean suppressDuplicates = (Boolean)EntityInitializers.resolve((ConfigBag)params, (ConfigKey)SUPPRESS_DUPLICATES);
        final Duration logWarningGraceTimeOnStartup = (Duration)EntityInitializers.resolve((ConfigBag)params, (ConfigKey)LOG_WARNING_GRACE_TIME_ON_STARTUP);
        final Duration logWarningGraceTime = (Duration)EntityInitializers.resolve((ConfigBag)params, (ConfigKey)LOG_WARNING_GRACE_TIME);
        if (entity instanceof UsesJmx) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Submitting task to add JMX sensor {} to {}", params.get(SENSOR_NAME), (Object)entity);
            }
        } else {
            throw new IllegalStateException(String.format("Entity %s does not support JMX", entity));
        }
        Task jmxPortTask = DependentConfiguration.attributeWhenReady((Entity)entity, (AttributeSensor)UsesJmx.JMX_PORT);
        Task jmxFeedTask = Tasks.builder().description("Add JMX feed").body((Callable)new Callable<JmxFeed>(){

            @Override
            public JmxFeed call() throws Exception {
                JmxHelper helper = new JmxHelper((Entity)entity);
                JmxFeed feed = JmxFeed.builder().entity((Entity)entity).period((Duration)params.get(AddSensorInitializer.SENSOR_PERIOD)).helper(helper).pollAttribute((JmxAttributePollConfig)((JmxAttributePollConfig)((JmxAttributePollConfig)((JmxAttributePollConfig)new JmxAttributePollConfig(sensor).objectName(objectName).attributeName(attribute).suppressDuplicates(Boolean.TRUE.equals(suppressDuplicates))).onFailureOrException(Functions.constant((Object)defaultValue))).logWarningGraceTimeOnStartup(logWarningGraceTimeOnStartup)).logWarningGraceTime(logWarningGraceTime)).build();
                entity.addFeed((Feed)feed);
                return feed;
            }
        }).build();
        DynamicTasks.submit((TaskAdaptable)Tasks.sequential((String)("Add JMX Sensor " + sensor.getName()), (TaskAdaptable[])new TaskAdaptable[]{jmxPortTask, jmxFeedTask}), (Entity)entity);
    }
}

