/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.util.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.google.common.base.Preconditions;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.camp.brooklyn.spi.dsl.methods.BrooklynDslCommon;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.util.core.json.BrooklynObjectsJsonMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class BrooklynJacksonJsonProvider
extends JacksonJsonProvider
implements MessageBodyWriter<Object>,
MessageBodyReader<Object> {
    private static final Logger log = LoggerFactory.getLogger(BrooklynJacksonJsonProvider.class);
    public static final String BROOKLYN_REST_OBJECT_MAPPER = "brooklyn.rest.objectMapper";
    protected ObjectMapper ourMapper;
    protected boolean notFound = false;
    @Context
    private ContextResolver<ManagementContext> mgmt;

    public ObjectMapper locateMapper(Class<?> type, MediaType mediaType) {
        if (this.ourMapper != null) {
            return this.ourMapper;
        }
        this.findSharedMapper();
        if (this.ourMapper != null) {
            return this.ourMapper;
        }
        if (!this.notFound) {
            log.warn("Management context not available; using default ObjectMapper in " + (Object)((Object)this));
            this.notFound = true;
        }
        return super.locateMapper(Object.class, MediaType.APPLICATION_JSON_TYPE);
    }

    protected synchronized ObjectMapper findSharedMapper() {
        if (this.ourMapper != null || this.notFound) {
            return this.ourMapper;
        }
        this.ourMapper = BrooklynJacksonJsonProvider.findSharedObjectMapper(this.mgmt());
        if (this.ourMapper == null) {
            return null;
        }
        if (this.notFound) {
            this.notFound = false;
        }
        log.debug("Found mapper " + this.ourMapper + " for " + (Object)((Object)this) + ", creating custom Brooklyn mapper");
        return this.ourMapper;
    }

    private ManagementContext mgmt() {
        return (ManagementContext)this.mgmt.getContext(ManagementContext.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectMapper findSharedObjectMapper(ManagementContext mgmt) {
        Preconditions.checkNotNull((Object)mgmt, (Object)"mgmt");
        ManagementContext managementContext = mgmt;
        synchronized (managementContext) {
            ConfigKey key = ConfigKeys.newConfigKey(ObjectMapper.class, (String)BROOKLYN_REST_OBJECT_MAPPER);
            ObjectMapper mapper = (ObjectMapper)mgmt.getScratchpad().get(key);
            if (mapper != null) {
                return mapper;
            }
            mapper = BrooklynJacksonJsonProvider.newPrivateObjectMapper(mgmt);
            log.debug("Storing new ObjectMapper against " + mgmt + " because no ServletContext available: " + mapper);
            mgmt.getScratchpad().put(key, (Object)mapper);
            return mapper;
        }
    }

    public static ObjectMapper findAnyObjectMapper(ManagementContext mgmt) {
        ObjectMapper mapper = BrooklynJacksonJsonProvider.findSharedObjectMapper(mgmt);
        if (mapper != null) {
            return mapper;
        }
        return BrooklynJacksonJsonProvider.newPrivateObjectMapper(mgmt);
    }

    public static ObjectMapper newPrivateObjectMapper(ManagementContext mgmt) {
        if (mgmt == null) {
            throw new IllegalStateException("No management context available for creating ObjectMapper");
        }
        BrooklynDslCommon.registerSerializationHooks();
        return BrooklynObjectsJsonMapper.newDslToStringSerializingMapper((ManagementContext)mgmt);
    }
}

