/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.domain;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import java.util.Properties;
import java.util.Set;

public class Region {
    public static final String EU_WEST_1 = "eu-west-1";
    public static final String EU_WEST_2 = "eu-west-2";
    public static final String EU_WEST_3 = "eu-west-3";
    public static final String EU_CENTRAL_1 = "eu-central-1";
    public static final String EU_NORTH_1 = "eu-north-1";
    public static final String US_STANDARD = "us-standard";
    public static final String US_EAST_1 = "us-east-1";
    public static final String US_EAST_2 = "us-east-2";
    public static final String US_WEST_1 = "us-west-1";
    public static final String US_WEST_2 = "us-west-2";
    public static final String CA_CENTRAL_1 = "ca-central-1";
    public static final String SA_EAST_1 = "sa-east-1";
    public static final String AP_SOUTHEAST_2 = "ap-southeast-2";
    public static final String AP_SOUTHEAST_1 = "ap-southeast-1";
    public static final String AP_SOUTH_1 = "ap-south-1";
    public static final String AP_NORTHEAST_1 = "ap-northeast-1";
    public static final String AP_NORTHEAST_2 = "ap-northeast-2";
    public static final String CN_NORTH_1 = "cn-north-1";
    public static final String CN_NORTHWEST_1 = "cn-northwest-1";
    public static final String ME_SOUTH_1 = "me-south-1";
    public static final Set<String> DEFAULT_S3 = ImmutableSet.of((Object)"us-standard", (Object)"us-east-2", (Object)"us-west-1", (Object)"us-west-2", (Object)"ca-central-1", (Object)"eu-west-1", (Object[])new String[]{"eu-west-2", "eu-west-3", "eu-central-1", "eu-north-1", "sa-east-1", "ap-southeast-1", "ap-southeast-2", "ap-south-1", "ap-northeast-1", "ap-northeast-2", "cn-north-1", "cn-northwest-1", "me-south-1"});
    public static final Set<String> DEFAULT_REGIONS = ImmutableSet.of((Object)"us-east-1", (Object)"us-east-2", (Object)"us-west-1", (Object)"us-west-2", (Object)"ca-central-1", (Object)"sa-east-1", (Object[])new String[]{"eu-west-1", "eu-west-2", "eu-west-3", "eu-central-1", "eu-north-1", "ap-southeast-1", "ap-southeast-2", "ap-south-1", "ap-northeast-1", "ap-northeast-2", "cn-north-1", "cn-northwest-1", "me-south-1"});

    public static Properties regionPropertiesS3() {
        Properties properties = Region.regionProperties();
        properties.setProperty("jclouds.regions", Joiner.on((char)',').join(DEFAULT_S3));
        properties.setProperty("jclouds.iso3166-codes", "US,US-OH,US-CA,US-OR,CA,BR-SP,IE,GB-LND,FR-IDF,DE-HE,SE-AB,SG,AU-NSW,IN-MH,JP-13,KR-11,CN-BJ,CN-NX,BH");
        properties.setProperty("jclouds.region.us-standard.iso3166-codes", "US");
        return properties;
    }

    public static Properties regionProperties() {
        Properties properties = new Properties();
        properties.setProperty("jclouds.regions", Joiner.on((char)',').join(DEFAULT_REGIONS));
        properties.setProperty("jclouds.iso3166-codes", "US-VA,US-OH,US-CA,US-OR,CA,BR-SP,IE,GB-LND,FR-IDF,DE-HE,SG,AU-NSW,IN-MH,JP-13,KR-11,CN-BJ,CN-NX,BH");
        properties.setProperty("jclouds.region.us-east-1.iso3166-codes", "US-VA");
        properties.setProperty("jclouds.region.us-east-2.iso3166-codes", "US-OH");
        properties.setProperty("jclouds.region.us-west-1.iso3166-codes", "US-CA");
        properties.setProperty("jclouds.region.us-west-2.iso3166-codes", "US-OR");
        properties.setProperty("jclouds.region.ca-central-1.iso3166-codes", "CA");
        properties.setProperty("jclouds.region.sa-east-1.iso3166-codes", "BR-SP");
        properties.setProperty("jclouds.region.eu-west-1.iso3166-codes", "IE");
        properties.setProperty("jclouds.region.eu-west-2.iso3166-codes", "GB-LND");
        properties.setProperty("jclouds.region.eu-west-3.iso3166-codes", "FR-IDF");
        properties.setProperty("jclouds.region.eu-central-1.iso3166-codes", "DE-HE");
        properties.setProperty("jclouds.region.eu-north-1.iso3166-codes", "SE-AB");
        properties.setProperty("jclouds.region.ap-southeast-1.iso3166-codes", "SG");
        properties.setProperty("jclouds.region.ap-southeast-2.iso3166-codes", "AU-NSW");
        properties.setProperty("jclouds.region.ap-south-1.iso3166-codes", "IN-MH");
        properties.setProperty("jclouds.region.ap-northeast-1.iso3166-codes", "JP-13");
        properties.setProperty("jclouds.region.ap-northeast-2.iso3166-codes", "KR-11");
        properties.setProperty("jclouds.region.cn-north-1.iso3166-codes", "CN-BJ");
        properties.setProperty("jclouds.region.cn-northwest-1.iso3166-codes", "CN-NX");
        properties.setProperty("jclouds.region.me-south-1.iso3166-codes", "BH");
        return properties;
    }
}

