/*
 * Decompiled with CFR 0.152.
 */
package io.cloudsoft.winrm4j.client.ntlm;

import io.cloudsoft.winrm4j.client.PayloadEncryptionMode;
import io.cloudsoft.winrm4j.client.ntlm.forks.httpclient.NTLMEngine;
import io.cloudsoft.winrm4j.client.ntlm.forks.httpclient.NTLMEngineImpl;
import io.cloudsoft.winrm4j.client.ntlm.forks.httpclient.NTLMScheme;
import java.util.function.Function;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.message.BasicHeader;

public class NtlmMasqAsSpnegoScheme
extends NTLMScheme {
    public NtlmMasqAsSpnegoScheme(NTLMEngine engine) {
        super(engine);
    }

    public NtlmMasqAsSpnegoScheme() {
        this(PayloadEncryptionMode.OPTIONAL);
    }

    public NtlmMasqAsSpnegoScheme(PayloadEncryptionMode payloadEncryptionMode) {
        this(NtlmMasqAsSpnegoScheme.newDefaultNtlmEngine(!payloadEncryptionMode.isPermitted() ? null : flags -> flags | 0x10L | 0x20L | 0x40000000L));
    }

    static NTLMEngine newDefaultNtlmEngine(final Function<Long, Long> flagModifier) {
        return new NTLMEngineImpl(){

            @Override
            protected Integer getDefaultFlags() {
                Long flags = (long)super.getDefaultFlags();
                if (flagModifier != null) {
                    flags = (Long)flagModifier.apply(flags);
                }
                return flags.intValue();
            }
        };
    }

    @Override
    public String getSchemeName() {
        return "Negotiate";
    }

    @Override
    public Header authenticate(Credentials credentials, HttpRequest request) throws AuthenticationException {
        Header hdr = super.authenticate(credentials, request);
        return new BasicHeader(hdr.getName(), hdr.getValue().replace("NTLM", this.getSchemeName()));
    }
}

