/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rt.felix;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.jar.Manifest;
import javax.annotation.Nullable;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.stream.Streams;
import org.apache.felix.framework.util.StringMap;
import org.apache.felix.framework.util.manifestparser.ManifestParser;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleCapability;

public class ManifestHelper {
    private static ManifestParser parse;
    private Manifest manifest;
    private String source;
    private static final String WIRING_PACKAGE = "osgi.wiring.package";

    public static ManifestHelper forManifestContents(String contents) throws IOException, BundleException {
        ManifestHelper result = ManifestHelper.forManifest(Streams.newInputStreamWithContents((String)contents));
        result.source = contents;
        return result;
    }

    public static ManifestHelper forManifest(URL url) throws IOException, BundleException {
        try (InputStream in = null;){
            in = url.openStream();
            ManifestHelper manifestHelper = ManifestHelper.forManifest(in);
            return manifestHelper;
        }
    }

    public static ManifestHelper forManifest(InputStream in) throws IOException, BundleException {
        return ManifestHelper.forManifest(new Manifest(in));
    }

    public static ManifestHelper forManifest(Manifest manifest) throws BundleException {
        ManifestHelper result = new ManifestHelper();
        result.manifest = manifest;
        parse = new ManifestParser(null, null, null, (Map)new StringMap((Map)manifest.getMainAttributes()));
        return result;
    }

    public String getSymbolicName() {
        return parse.getSymbolicName();
    }

    public Version getVersion() {
        return parse.getBundleVersion();
    }

    public String getSymbolicNameVersion() {
        return this.getSymbolicName() + ":" + this.getVersion();
    }

    public List<String> getExportedPackages() {
        MutableList result = MutableList.of();
        for (BundleCapability c : parse.getCapabilities()) {
            if (!WIRING_PACKAGE.equals(c.getNamespace())) continue;
            result.add((Object)((String)c.getAttributes().get(WIRING_PACKAGE)));
        }
        return result;
    }

    @Nullable
    public String getSource() {
        return this.source;
    }

    public Manifest getManifest() {
        return this.manifest;
    }
}

