/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.rebind;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Map;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.api.mgmt.rebind.RebindContext;
import org.apache.brooklyn.api.mgmt.rebind.mementos.EntityMemento;
import org.apache.brooklyn.api.policy.Policy;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Enricher;
import org.apache.brooklyn.api.sensor.Feed;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.enricher.AbstractEnricher;
import org.apache.brooklyn.core.entity.AbstractEntity;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.entity.internal.AttributesInternal;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.entity.lifecycle.ServiceStateLogic;
import org.apache.brooklyn.core.entity.trait.AsyncStartable;
import org.apache.brooklyn.core.feed.AbstractFeed;
import org.apache.brooklyn.core.location.Machines;
import org.apache.brooklyn.core.mgmt.rebind.AbstractBrooklynObjectRebindSupport;
import org.apache.brooklyn.core.objs.AbstractBrooklynObject;
import org.apache.brooklyn.core.policy.AbstractPolicy;
import org.apache.brooklyn.entity.group.AbstractGroupImpl;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicEntityRebindSupport
extends AbstractBrooklynObjectRebindSupport<EntityMemento> {
    private static final Logger LOG = LoggerFactory.getLogger(BasicEntityRebindSupport.class);
    private final EntityInternal entity;

    public BasicEntityRebindSupport(AbstractEntity entity) {
        super(entity);
        this.entity = (EntityInternal)Preconditions.checkNotNull((Object)entity, (Object)"entity");
    }

    @Override
    protected void addCustoms(RebindContext rebindContext, EntityMemento memento) {
        for (ConfigKey configKey : memento.getDynamicConfigKeys()) {
            this.entity.getMutableEntityType().addConfigKey(configKey);
        }
        for (Effector effector : memento.getEffectors()) {
            this.entity.getMutableEntityType().addEffector(effector);
        }
        for (Map.Entry entry : memento.getAttributes().entrySet()) {
            try {
                AttributeSensor key = (AttributeSensor)entry.getKey();
                Object value = entry.getValue();
                Class type = key.getType() != null ? key.getType() : rebindContext.loadClass(key.getTypeName());
                this.entity.sensors().setWithoutPublishing(key, value);
            }
            catch (Exception e) {
                LOG.warn("Error adding custom sensor " + entry + " when rebinding " + this.entity + " (rethrowing): " + e);
                throw Exceptions.propagate((Throwable)e);
            }
        }
        this.setParent(rebindContext, memento);
        this.addChildren(rebindContext, memento);
        this.addMembers(rebindContext, memento);
        this.addLocations(rebindContext, memento);
    }

    @Override
    protected void addConfig(RebindContext rebindContext, EntityMemento memento) {
        ConfigKey key = null;
        for (Map.Entry entry : memento.getConfig().entrySet()) {
            try {
                key = (ConfigKey)entry.getKey();
                Object value = entry.getValue();
                Class type = null;
                try {
                    type = key.getType() != null ? key.getType() : rebindContext.loadClass(key.getTypeName());
                }
                catch (Exception e) {
                    Exceptions.propagateIfFatal((Throwable)e);
                    LOG.warn("Unable to find type of key " + key.getName() + " in " + memento + "; proceeding, but errors may occur when using");
                }
                this.entity.config().setRaw(key, type == null || type.equals(Object.class), value);
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                rebindContext.getExceptionHandler().onAddConfigFailed(memento, key, e);
            }
        }
        this.entity.config().putAll(memento.getConfigUnmatched());
        this.entity.config().refreshInheritedConfig();
    }

    @Override
    public void addPolicies(RebindContext rebindContext, EntityMemento memento) {
        for (String policyId : memento.getPolicies()) {
            AbstractPolicy policy = (AbstractPolicy)rebindContext.lookup().lookupPolicy(policyId);
            if (policy != null) {
                try {
                    this.entity.policies().add(policy);
                }
                catch (Exception e) {
                    rebindContext.getExceptionHandler().onAddPolicyFailed((EntityLocal)this.entity, (Policy)policy, e);
                }
                continue;
            }
            LOG.warn("Policy not found; discarding policy {} of entity {}({})", new Object[]{policyId, memento.getType(), memento.getId()});
            rebindContext.getExceptionHandler().onDanglingPolicyRef(policyId);
        }
    }

    @Override
    public void addEnrichers(RebindContext rebindContext, EntityMemento memento) {
        for (String enricherId : memento.getEnrichers()) {
            AbstractEnricher enricher = (AbstractEnricher)rebindContext.lookup().lookupEnricher(enricherId);
            if (enricher != null) {
                try {
                    this.entity.enrichers().add(enricher);
                }
                catch (Exception e) {
                    rebindContext.getExceptionHandler().onAddEnricherFailed((EntityLocal)this.entity, (Enricher)enricher, e);
                }
                continue;
            }
            LOG.warn("Enricher not found; discarding enricher {} of entity {}({})", new Object[]{enricherId, memento.getType(), memento.getId()});
        }
    }

    @Override
    public void addFeeds(RebindContext rebindContext, EntityMemento memento) {
        for (String feedId : memento.getFeeds()) {
            AbstractFeed feed = (AbstractFeed)rebindContext.lookup().lookupFeed(feedId);
            if (feed != null) {
                try {
                    this.entity.feeds().add(feed);
                }
                catch (Exception e) {
                    rebindContext.getExceptionHandler().onAddFeedFailed((EntityLocal)this.entity, (Feed)feed, e);
                }
                continue;
            }
            LOG.warn("Feed not found; discarding feed {} of entity {}({})", new Object[]{feedId, memento.getType(), memento.getId()});
        }
    }

    protected void addMembers(RebindContext rebindContext, EntityMemento memento) {
        if (memento.getMembers().size() > 0) {
            if (this.entity instanceof AbstractGroupImpl) {
                for (String memberId : memento.getMembers()) {
                    Entity member = rebindContext.lookup().lookupEntity(memberId);
                    if (member != null) {
                        ((AbstractGroupImpl)this.entity).addMemberInternal(member);
                        continue;
                    }
                    LOG.warn("Entity not found; discarding member {} of group {}({})", new Object[]{memberId, memento.getType(), memento.getId()});
                }
            } else {
                throw new UnsupportedOperationException("Entity with members should be a group: entity=" + this.entity + "; type=" + this.entity.getClass() + "; members=" + memento.getMembers());
            }
        }
    }

    protected Entity proxy(Entity target) {
        return target instanceof AbstractEntity ? ((AbstractEntity)target).getProxyIfAvailable() : target;
    }

    protected void addChildren(RebindContext rebindContext, EntityMemento memento) {
        for (String childId : memento.getChildren()) {
            Entity child = rebindContext.lookup().lookupEntity(childId);
            if (child != null) {
                this.entity.addChild(this.proxy(child));
                continue;
            }
            LOG.warn("Entity not found; discarding child {} of entity {}({})", new Object[]{childId, memento.getType(), memento.getId()});
        }
    }

    protected void setParent(RebindContext rebindContext, EntityMemento memento) {
        Entity parent;
        Entity entity = parent = memento.getParent() != null ? rebindContext.lookup().lookupEntity(memento.getParent()) : null;
        if (parent != null) {
            this.entity.setParent(this.proxy(parent));
        } else if (memento.getParent() != null) {
            LOG.warn("Entity not found; discarding parent {} of entity {}({}), so entity will be orphaned and unmanaged", new Object[]{memento.getParent(), memento.getType(), memento.getId()});
        }
    }

    protected void addLocations(RebindContext rebindContext, EntityMemento memento) {
        for (String id : memento.getLocations()) {
            Location loc = rebindContext.lookup().lookupLocation(id);
            if (loc != null) {
                this.entity.addLocationsWithoutPublishing((Collection<? extends Location>)ImmutableList.of((Object)loc));
                continue;
            }
            LOG.warn("Location not found; discarding location {} of entity {}({})", new Object[]{id, memento.getType(), memento.getId()});
        }
    }

    @Override
    protected void instanceRebind(AbstractBrooklynObject instance) {
        Preconditions.checkState((instance == this.entity ? 1 : 0) != 0, (String)"Expected %s and %s to match, but different objects", (Object)instance, (Object)this.entity);
        Lifecycle expectedState = ServiceStateLogic.getExpectedState((Entity)this.entity);
        boolean isAsync = this.entity instanceof AsyncStartable;
        if (!isAsync && expectedState == Lifecycle.STARTING || expectedState == Lifecycle.STOPPING) {
            this.markTransitioningEntityOnFireOnRebind(this.entity, expectedState);
        }
        this.entity.sensors().remove(AttributesInternal.INTERNAL_PROVISIONING_TASK_STATE);
        this.entity.sensors().remove(AttributesInternal.INTERNAL_TERMINATION_TASK_STATE);
        super.instanceRebind(instance);
    }

    protected void markTransitioningEntityOnFireOnRebind(EntityInternal entity, Lifecycle expectedState) {
        LOG.warn("Entity {} being marked as on-fire because it was in state {} on rebind; indicators={}", new Object[]{entity, expectedState, entity.getAttribute(Attributes.SERVICE_NOT_UP_INDICATORS)});
        ServiceStateLogic.setExpectedState((Entity)entity, Lifecycle.ON_FIRE);
        ServiceStateLogic.ServiceNotUpLogic.updateNotUpIndicator((Entity)entity, "Task aborted on rebind", (Object)("Set to on-fire (from previous expected state " + (Object)((Object)expectedState) + ") because tasks aborted on shutdown"));
        Maybe<MachineLocation> machine = Machines.findUniqueMachineLocation(entity.getLocations());
        AttributesInternal.ProvisioningTaskState provisioningState = (AttributesInternal.ProvisioningTaskState)((Object)entity.sensors().get(AttributesInternal.INTERNAL_PROVISIONING_TASK_STATE));
        if (machine.isAbsent() && provisioningState == AttributesInternal.ProvisioningTaskState.RUNNING) {
            LOG.warn("Entity {} was provisioning; VM may have been left running", (Object)entity);
            ServiceStateLogic.ServiceNotUpLogic.updateNotUpIndicator((Entity)entity, "VM may be lost on rebind", (Object)"VM provisioning may have been in-progress and now lost, because tasks aborted on shutdown");
        }
        AttributesInternal.ProvisioningTaskState terminationState = (AttributesInternal.ProvisioningTaskState)((Object)entity.sensors().get(AttributesInternal.INTERNAL_TERMINATION_TASK_STATE));
        if (machine.isAbsent() && terminationState == AttributesInternal.ProvisioningTaskState.RUNNING) {
            LOG.warn("Entity {} was terminating; VM may have been left running", (Object)entity);
            ServiceStateLogic.ServiceNotUpLogic.updateNotUpIndicator((Entity)entity, "VM may be lost on rebind", (Object)"VM termination may have been in-progress and now lost, because tasks aborted on shutdown");
        }
    }
}

