/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1alpha1.kameletbindingspec.integration.template.spec;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.camel.v1alpha1.kameletbindingspec.integration.template.spec.SecurityContext;
import org.apache.camel.v1alpha1.kameletbindingspec.integration.template.spec.securitycontext.SeLinuxOptions;
import org.apache.camel.v1alpha1.kameletbindingspec.integration.template.spec.securitycontext.SeLinuxOptionsBuilder;
import org.apache.camel.v1alpha1.kameletbindingspec.integration.template.spec.securitycontext.SeLinuxOptionsFluent;
import org.apache.camel.v1alpha1.kameletbindingspec.integration.template.spec.securitycontext.SeccompProfile;
import org.apache.camel.v1alpha1.kameletbindingspec.integration.template.spec.securitycontext.SeccompProfileBuilder;
import org.apache.camel.v1alpha1.kameletbindingspec.integration.template.spec.securitycontext.SeccompProfileFluent;
import org.apache.camel.v1alpha1.kameletbindingspec.integration.template.spec.securitycontext.Sysctls;
import org.apache.camel.v1alpha1.kameletbindingspec.integration.template.spec.securitycontext.SysctlsBuilder;
import org.apache.camel.v1alpha1.kameletbindingspec.integration.template.spec.securitycontext.SysctlsFluent;
import org.apache.camel.v1alpha1.kameletbindingspec.integration.template.spec.securitycontext.WindowsOptions;
import org.apache.camel.v1alpha1.kameletbindingspec.integration.template.spec.securitycontext.WindowsOptionsBuilder;
import org.apache.camel.v1alpha1.kameletbindingspec.integration.template.spec.securitycontext.WindowsOptionsFluent;

public class SecurityContextFluent<A extends SecurityContextFluent<A>>
extends BaseFluent<A> {
    private Long fsGroup;
    private String fsGroupChangePolicy;
    private Long runAsGroup;
    private Boolean runAsNonRoot;
    private Long runAsUser;
    private SeLinuxOptionsBuilder seLinuxOptions;
    private SeccompProfileBuilder seccompProfile;
    private List<Long> supplementalGroups;
    private ArrayList<SysctlsBuilder> sysctls;
    private WindowsOptionsBuilder windowsOptions;

    public SecurityContextFluent() {
    }

    public SecurityContextFluent(SecurityContext instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(SecurityContext instance) {
        SecurityContext securityContext = instance = instance != null ? instance : new SecurityContext();
        if (instance != null) {
            this.withFsGroup(instance.getFsGroup());
            this.withFsGroupChangePolicy(instance.getFsGroupChangePolicy());
            this.withRunAsGroup(instance.getRunAsGroup());
            this.withRunAsNonRoot(instance.getRunAsNonRoot());
            this.withRunAsUser(instance.getRunAsUser());
            this.withSeLinuxOptions(instance.getSeLinuxOptions());
            this.withSeccompProfile(instance.getSeccompProfile());
            this.withSupplementalGroups(instance.getSupplementalGroups());
            this.withSysctls(instance.getSysctls());
            this.withWindowsOptions(instance.getWindowsOptions());
        }
    }

    public Long getFsGroup() {
        return this.fsGroup;
    }

    public A withFsGroup(Long fsGroup) {
        this.fsGroup = fsGroup;
        return (A)((Object)this);
    }

    public boolean hasFsGroup() {
        return this.fsGroup != null;
    }

    public String getFsGroupChangePolicy() {
        return this.fsGroupChangePolicy;
    }

    public A withFsGroupChangePolicy(String fsGroupChangePolicy) {
        this.fsGroupChangePolicy = fsGroupChangePolicy;
        return (A)((Object)this);
    }

    public boolean hasFsGroupChangePolicy() {
        return this.fsGroupChangePolicy != null;
    }

    public Long getRunAsGroup() {
        return this.runAsGroup;
    }

    public A withRunAsGroup(Long runAsGroup) {
        this.runAsGroup = runAsGroup;
        return (A)((Object)this);
    }

    public boolean hasRunAsGroup() {
        return this.runAsGroup != null;
    }

    public Boolean getRunAsNonRoot() {
        return this.runAsNonRoot;
    }

    public A withRunAsNonRoot(Boolean runAsNonRoot) {
        this.runAsNonRoot = runAsNonRoot;
        return (A)((Object)this);
    }

    public boolean hasRunAsNonRoot() {
        return this.runAsNonRoot != null;
    }

    public Long getRunAsUser() {
        return this.runAsUser;
    }

    public A withRunAsUser(Long runAsUser) {
        this.runAsUser = runAsUser;
        return (A)((Object)this);
    }

    public boolean hasRunAsUser() {
        return this.runAsUser != null;
    }

    public SeLinuxOptions buildSeLinuxOptions() {
        return this.seLinuxOptions != null ? this.seLinuxOptions.build() : null;
    }

    public A withSeLinuxOptions(SeLinuxOptions seLinuxOptions) {
        this._visitables.remove((Object)"seLinuxOptions");
        if (seLinuxOptions != null) {
            this.seLinuxOptions = new SeLinuxOptionsBuilder(seLinuxOptions);
            this._visitables.get((Object)"seLinuxOptions").add(this.seLinuxOptions);
        } else {
            this.seLinuxOptions = null;
            this._visitables.get((Object)"seLinuxOptions").remove((Object)this.seLinuxOptions);
        }
        return (A)((Object)this);
    }

    public boolean hasSeLinuxOptions() {
        return this.seLinuxOptions != null;
    }

    public SeLinuxOptionsNested<A> withNewSeLinuxOptions() {
        return new SeLinuxOptionsNested(null);
    }

    public SeLinuxOptionsNested<A> withNewSeLinuxOptionsLike(SeLinuxOptions item) {
        return new SeLinuxOptionsNested(item);
    }

    public SeLinuxOptionsNested<A> editSpecSeLinuxOptions() {
        return this.withNewSeLinuxOptionsLike(Optional.ofNullable(this.buildSeLinuxOptions()).orElse(null));
    }

    public SeLinuxOptionsNested<A> editOrNewSeLinuxOptions() {
        return this.withNewSeLinuxOptionsLike(Optional.ofNullable(this.buildSeLinuxOptions()).orElse(new SeLinuxOptionsBuilder().build()));
    }

    public SeLinuxOptionsNested<A> editOrNewSeLinuxOptionsLike(SeLinuxOptions item) {
        return this.withNewSeLinuxOptionsLike(Optional.ofNullable(this.buildSeLinuxOptions()).orElse(item));
    }

    public SeccompProfile buildSeccompProfile() {
        return this.seccompProfile != null ? this.seccompProfile.build() : null;
    }

    public A withSeccompProfile(SeccompProfile seccompProfile) {
        this._visitables.remove((Object)"seccompProfile");
        if (seccompProfile != null) {
            this.seccompProfile = new SeccompProfileBuilder(seccompProfile);
            this._visitables.get((Object)"seccompProfile").add(this.seccompProfile);
        } else {
            this.seccompProfile = null;
            this._visitables.get((Object)"seccompProfile").remove((Object)this.seccompProfile);
        }
        return (A)((Object)this);
    }

    public boolean hasSeccompProfile() {
        return this.seccompProfile != null;
    }

    public SeccompProfileNested<A> withNewSeccompProfile() {
        return new SeccompProfileNested(null);
    }

    public SeccompProfileNested<A> withNewSeccompProfileLike(SeccompProfile item) {
        return new SeccompProfileNested(item);
    }

    public SeccompProfileNested<A> editSeccompProfile() {
        return this.withNewSeccompProfileLike(Optional.ofNullable(this.buildSeccompProfile()).orElse(null));
    }

    public SeccompProfileNested<A> editOrNewSeccompProfile() {
        return this.withNewSeccompProfileLike(Optional.ofNullable(this.buildSeccompProfile()).orElse(new SeccompProfileBuilder().build()));
    }

    public SeccompProfileNested<A> editOrNewSeccompProfileLike(SeccompProfile item) {
        return this.withNewSeccompProfileLike(Optional.ofNullable(this.buildSeccompProfile()).orElse(item));
    }

    public A addToSupplementalGroups(int index, Long item) {
        if (this.supplementalGroups == null) {
            this.supplementalGroups = new ArrayList<Long>();
        }
        this.supplementalGroups.add(index, item);
        return (A)((Object)this);
    }

    public A setToSupplementalGroups(int index, Long item) {
        if (this.supplementalGroups == null) {
            this.supplementalGroups = new ArrayList<Long>();
        }
        this.supplementalGroups.set(index, item);
        return (A)((Object)this);
    }

    public A addToSupplementalGroups(Long ... items) {
        if (this.supplementalGroups == null) {
            this.supplementalGroups = new ArrayList<Long>();
        }
        for (Long item : items) {
            this.supplementalGroups.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToSupplementalGroups(Collection<Long> items) {
        if (this.supplementalGroups == null) {
            this.supplementalGroups = new ArrayList<Long>();
        }
        for (Long item : items) {
            this.supplementalGroups.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromSupplementalGroups(Long ... items) {
        if (this.supplementalGroups == null) {
            return (A)((Object)this);
        }
        for (Long item : items) {
            this.supplementalGroups.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromSupplementalGroups(Collection<Long> items) {
        if (this.supplementalGroups == null) {
            return (A)((Object)this);
        }
        for (Long item : items) {
            this.supplementalGroups.remove(item);
        }
        return (A)((Object)this);
    }

    public List<Long> getSupplementalGroups() {
        return this.supplementalGroups;
    }

    public Long getSupplementalGroup(int index) {
        return this.supplementalGroups.get(index);
    }

    public Long getFirstSupplementalGroup() {
        return this.supplementalGroups.get(0);
    }

    public Long getLastSupplementalGroup() {
        return this.supplementalGroups.get(this.supplementalGroups.size() - 1);
    }

    public Long getMatchingSupplementalGroup(Predicate<Long> predicate) {
        for (Long item : this.supplementalGroups) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingSupplementalGroup(Predicate<Long> predicate) {
        for (Long item : this.supplementalGroups) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSupplementalGroups(List<Long> supplementalGroups) {
        if (supplementalGroups != null) {
            this.supplementalGroups = new ArrayList<Long>();
            for (Long item : supplementalGroups) {
                this.addToSupplementalGroups(item);
            }
        } else {
            this.supplementalGroups = null;
        }
        return (A)((Object)this);
    }

    public A withSupplementalGroups(Long ... supplementalGroups) {
        if (this.supplementalGroups != null) {
            this.supplementalGroups.clear();
            this._visitables.remove((Object)"supplementalGroups");
        }
        if (supplementalGroups != null) {
            for (Long item : supplementalGroups) {
                this.addToSupplementalGroups(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasSupplementalGroups() {
        return this.supplementalGroups != null && !this.supplementalGroups.isEmpty();
    }

    public A addToSysctls(int index, Sysctls item) {
        if (this.sysctls == null) {
            this.sysctls = new ArrayList();
        }
        SysctlsBuilder builder = new SysctlsBuilder(item);
        if (index < 0 || index >= this.sysctls.size()) {
            this._visitables.get((Object)"sysctls").add(builder);
            this.sysctls.add(builder);
        } else {
            this._visitables.get((Object)"sysctls").add(index, builder);
            this.sysctls.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToSysctls(int index, Sysctls item) {
        if (this.sysctls == null) {
            this.sysctls = new ArrayList();
        }
        SysctlsBuilder builder = new SysctlsBuilder(item);
        if (index < 0 || index >= this.sysctls.size()) {
            this._visitables.get((Object)"sysctls").add(builder);
            this.sysctls.add(builder);
        } else {
            this._visitables.get((Object)"sysctls").set(index, builder);
            this.sysctls.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToSysctls(Sysctls ... items) {
        if (this.sysctls == null) {
            this.sysctls = new ArrayList();
        }
        for (Sysctls item : items) {
            SysctlsBuilder builder = new SysctlsBuilder(item);
            this._visitables.get((Object)"sysctls").add(builder);
            this.sysctls.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToIntegrationSysctls(Collection<Sysctls> items) {
        if (this.sysctls == null) {
            this.sysctls = new ArrayList();
        }
        for (Sysctls item : items) {
            SysctlsBuilder builder = new SysctlsBuilder(item);
            this._visitables.get((Object)"sysctls").add(builder);
            this.sysctls.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromSysctls(Sysctls ... items) {
        if (this.sysctls == null) {
            return (A)((Object)this);
        }
        for (Sysctls item : items) {
            SysctlsBuilder builder = new SysctlsBuilder(item);
            this._visitables.get((Object)"sysctls").remove((Object)builder);
            this.sysctls.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromIntegrationSysctls(Collection<Sysctls> items) {
        if (this.sysctls == null) {
            return (A)((Object)this);
        }
        for (Sysctls item : items) {
            SysctlsBuilder builder = new SysctlsBuilder(item);
            this._visitables.get((Object)"sysctls").remove((Object)builder);
            this.sysctls.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromIntegrationSysctls(Predicate<SysctlsBuilder> predicate) {
        if (this.sysctls == null) {
            return (A)((Object)this);
        }
        Iterator<SysctlsBuilder> each = this.sysctls.iterator();
        List visitables = this._visitables.get((Object)"sysctls");
        while (each.hasNext()) {
            SysctlsBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Sysctls> buildSysctls() {
        return this.sysctls != null ? SecurityContextFluent.build(this.sysctls) : null;
    }

    public Sysctls buildSysctl(int index) {
        return this.sysctls.get(index).build();
    }

    public Sysctls buildFirstSysctl() {
        return this.sysctls.get(0).build();
    }

    public Sysctls buildLastSysctl() {
        return this.sysctls.get(this.sysctls.size() - 1).build();
    }

    public Sysctls buildMatchingSysctl(Predicate<SysctlsBuilder> predicate) {
        for (SysctlsBuilder item : this.sysctls) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSysctl(Predicate<SysctlsBuilder> predicate) {
        for (SysctlsBuilder item : this.sysctls) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSysctls(List<Sysctls> sysctls) {
        if (this.sysctls != null) {
            this._visitables.get((Object)"sysctls").clear();
        }
        if (sysctls != null) {
            this.sysctls = new ArrayList();
            for (Sysctls item : sysctls) {
                this.addToSysctls(item);
            }
        } else {
            this.sysctls = null;
        }
        return (A)((Object)this);
    }

    public A withSysctls(Sysctls ... sysctls) {
        if (this.sysctls != null) {
            this.sysctls.clear();
            this._visitables.remove((Object)"sysctls");
        }
        if (sysctls != null) {
            for (Sysctls item : sysctls) {
                this.addToSysctls(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasSysctls() {
        return this.sysctls != null && !this.sysctls.isEmpty();
    }

    public SysctlsNested<A> addNewSysctl() {
        return new SysctlsNested(-1, null);
    }

    public SysctlsNested<A> addNewSysctlLike(Sysctls item) {
        return new SysctlsNested(-1, item);
    }

    public SysctlsNested<A> setNewSysctlLike(int index, Sysctls item) {
        return new SysctlsNested(index, item);
    }

    public SysctlsNested<A> editSysctl(int index) {
        if (this.sysctls.size() <= index) {
            throw new RuntimeException("Can't edit sysctls. Index exceeds size.");
        }
        return this.setNewSysctlLike(index, this.buildSysctl(index));
    }

    public SysctlsNested<A> editFirstSysctl() {
        if (this.sysctls.size() == 0) {
            throw new RuntimeException("Can't edit first sysctls. The list is empty.");
        }
        return this.setNewSysctlLike(0, this.buildSysctl(0));
    }

    public SysctlsNested<A> editLastSysctl() {
        int index = this.sysctls.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last sysctls. The list is empty.");
        }
        return this.setNewSysctlLike(index, this.buildSysctl(index));
    }

    public SysctlsNested<A> editMatchingSysctl(Predicate<SysctlsBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.sysctls.size(); ++i) {
            if (!predicate.test(this.sysctls.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching sysctls. No match found.");
        }
        return this.setNewSysctlLike(index, this.buildSysctl(index));
    }

    public WindowsOptions buildWindowsOptions() {
        return this.windowsOptions != null ? this.windowsOptions.build() : null;
    }

    public A withWindowsOptions(WindowsOptions windowsOptions) {
        this._visitables.remove((Object)"windowsOptions");
        if (windowsOptions != null) {
            this.windowsOptions = new WindowsOptionsBuilder(windowsOptions);
            this._visitables.get((Object)"windowsOptions").add(this.windowsOptions);
        } else {
            this.windowsOptions = null;
            this._visitables.get((Object)"windowsOptions").remove((Object)this.windowsOptions);
        }
        return (A)((Object)this);
    }

    public boolean hasWindowsOptions() {
        return this.windowsOptions != null;
    }

    public WindowsOptionsNested<A> withNewWindowsOptions() {
        return new WindowsOptionsNested(null);
    }

    public WindowsOptionsNested<A> withNewWindowsOptionsLike(WindowsOptions item) {
        return new WindowsOptionsNested(item);
    }

    public WindowsOptionsNested<A> editSpecWindowsOptions() {
        return this.withNewWindowsOptionsLike(Optional.ofNullable(this.buildWindowsOptions()).orElse(null));
    }

    public WindowsOptionsNested<A> editOrNewWindowsOptions() {
        return this.withNewWindowsOptionsLike(Optional.ofNullable(this.buildWindowsOptions()).orElse(new WindowsOptionsBuilder().build()));
    }

    public WindowsOptionsNested<A> editOrNewWindowsOptionsLike(WindowsOptions item) {
        return this.withNewWindowsOptionsLike(Optional.ofNullable(this.buildWindowsOptions()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SecurityContextFluent that = (SecurityContextFluent)((Object)o);
        if (!Objects.equals(this.fsGroup, that.fsGroup)) {
            return false;
        }
        if (!Objects.equals(this.fsGroupChangePolicy, that.fsGroupChangePolicy)) {
            return false;
        }
        if (!Objects.equals(this.runAsGroup, that.runAsGroup)) {
            return false;
        }
        if (!Objects.equals(this.runAsNonRoot, that.runAsNonRoot)) {
            return false;
        }
        if (!Objects.equals(this.runAsUser, that.runAsUser)) {
            return false;
        }
        if (!Objects.equals((Object)this.seLinuxOptions, (Object)that.seLinuxOptions)) {
            return false;
        }
        if (!Objects.equals((Object)this.seccompProfile, (Object)that.seccompProfile)) {
            return false;
        }
        if (!Objects.equals(this.supplementalGroups, that.supplementalGroups)) {
            return false;
        }
        if (!Objects.equals(this.sysctls, that.sysctls)) {
            return false;
        }
        return Objects.equals((Object)this.windowsOptions, (Object)that.windowsOptions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fsGroup, this.fsGroupChangePolicy, this.runAsGroup, this.runAsNonRoot, this.runAsUser, this.seLinuxOptions, this.seccompProfile, this.supplementalGroups, this.sysctls, this.windowsOptions, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.fsGroup != null) {
            sb.append("fsGroup:");
            sb.append(this.fsGroup + ",");
        }
        if (this.fsGroupChangePolicy != null) {
            sb.append("fsGroupChangePolicy:");
            sb.append(this.fsGroupChangePolicy + ",");
        }
        if (this.runAsGroup != null) {
            sb.append("runAsGroup:");
            sb.append(this.runAsGroup + ",");
        }
        if (this.runAsNonRoot != null) {
            sb.append("runAsNonRoot:");
            sb.append(this.runAsNonRoot + ",");
        }
        if (this.runAsUser != null) {
            sb.append("runAsUser:");
            sb.append(this.runAsUser + ",");
        }
        if (this.seLinuxOptions != null) {
            sb.append("seLinuxOptions:");
            sb.append(this.seLinuxOptions + ",");
        }
        if (this.seccompProfile != null) {
            sb.append("seccompProfile:");
            sb.append(this.seccompProfile + ",");
        }
        if (this.supplementalGroups != null && !this.supplementalGroups.isEmpty()) {
            sb.append("supplementalGroups:");
            sb.append(this.supplementalGroups + ",");
        }
        if (this.sysctls != null && !this.sysctls.isEmpty()) {
            sb.append("sysctls:");
            sb.append(this.sysctls + ",");
        }
        if (this.windowsOptions != null) {
            sb.append("windowsOptions:");
            sb.append((Object)this.windowsOptions);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withRunAsNonRoot() {
        return this.withRunAsNonRoot(true);
    }

    public class SeLinuxOptionsNested<N>
    extends SeLinuxOptionsFluent<SeLinuxOptionsNested<N>>
    implements Nested<N> {
        SeLinuxOptionsBuilder builder;

        SeLinuxOptionsNested(SeLinuxOptions item) {
            this.builder = new SeLinuxOptionsBuilder(this, item);
        }

        public N and() {
            return (N)SecurityContextFluent.this.withSeLinuxOptions(this.builder.build());
        }

        public N endSpecSeLinuxOptions() {
            return this.and();
        }
    }

    public class SeccompProfileNested<N>
    extends SeccompProfileFluent<SeccompProfileNested<N>>
    implements Nested<N> {
        SeccompProfileBuilder builder;

        SeccompProfileNested(SeccompProfile item) {
            this.builder = new SeccompProfileBuilder(this, item);
        }

        public N and() {
            return (N)SecurityContextFluent.this.withSeccompProfile(this.builder.build());
        }

        public N endSeccompProfile() {
            return this.and();
        }
    }

    public class SysctlsNested<N>
    extends SysctlsFluent<SysctlsNested<N>>
    implements Nested<N> {
        SysctlsBuilder builder;
        int index;

        SysctlsNested(int index, Sysctls item) {
            this.index = index;
            this.builder = new SysctlsBuilder(this, item);
        }

        public N and() {
            return (N)SecurityContextFluent.this.setToSysctls(this.index, this.builder.build());
        }

        public N endIntegrationSysctl() {
            return this.and();
        }
    }

    public class WindowsOptionsNested<N>
    extends WindowsOptionsFluent<WindowsOptionsNested<N>>
    implements Nested<N> {
        WindowsOptionsBuilder builder;

        WindowsOptionsNested(WindowsOptions item) {
            this.builder = new WindowsOptionsBuilder(this, item);
        }

        public N and() {
            return (N)SecurityContextFluent.this.withWindowsOptions(this.builder.build());
        }

        public N endSpecWindowsOptions() {
            return this.and();
        }
    }
}

