/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.buildspec.tasks;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Objects;
import java.util.Optional;
import org.apache.camel.v1.buildspec.tasks.Kaniko;
import org.apache.camel.v1.buildspec.tasks.kaniko.Cache;
import org.apache.camel.v1.buildspec.tasks.kaniko.CacheBuilder;
import org.apache.camel.v1.buildspec.tasks.kaniko.CacheFluent;
import org.apache.camel.v1.buildspec.tasks.kaniko.Configuration;
import org.apache.camel.v1.buildspec.tasks.kaniko.ConfigurationBuilder;
import org.apache.camel.v1.buildspec.tasks.kaniko.ConfigurationFluent;
import org.apache.camel.v1.buildspec.tasks.kaniko.Registry;
import org.apache.camel.v1.buildspec.tasks.kaniko.RegistryBuilder;
import org.apache.camel.v1.buildspec.tasks.kaniko.RegistryFluent;

public class KanikoFluent<A extends KanikoFluent<A>>
extends BaseFluent<A> {
    private String baseImage;
    private CacheBuilder cache;
    private ConfigurationBuilder configuration;
    private String contextDir;
    private String executorImage;
    private String image;
    private String name;
    private RegistryBuilder registry;
    private Boolean verbose;

    public KanikoFluent() {
    }

    public KanikoFluent(Kaniko instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Kaniko instance) {
        Kaniko kaniko = instance = instance != null ? instance : new Kaniko();
        if (instance != null) {
            this.withBaseImage(instance.getBaseImage());
            this.withCache(instance.getCache());
            this.withConfiguration(instance.getConfiguration());
            this.withContextDir(instance.getContextDir());
            this.withExecutorImage(instance.getExecutorImage());
            this.withImage(instance.getImage());
            this.withName(instance.getName());
            this.withRegistry(instance.getRegistry());
            this.withVerbose(instance.getVerbose());
        }
    }

    public String getBaseImage() {
        return this.baseImage;
    }

    public A withBaseImage(String baseImage) {
        this.baseImage = baseImage;
        return (A)((Object)this);
    }

    public boolean hasBaseImage() {
        return this.baseImage != null;
    }

    public Cache buildCache() {
        return this.cache != null ? this.cache.build() : null;
    }

    public A withCache(Cache cache) {
        this._visitables.remove((Object)"cache");
        if (cache != null) {
            this.cache = new CacheBuilder(cache);
            this._visitables.get((Object)"cache").add(this.cache);
        } else {
            this.cache = null;
            this._visitables.get((Object)"cache").remove((Object)this.cache);
        }
        return (A)((Object)this);
    }

    public boolean hasCache() {
        return this.cache != null;
    }

    public CacheNested<A> withNewCache() {
        return new CacheNested(null);
    }

    public CacheNested<A> withNewCacheLike(Cache item) {
        return new CacheNested(item);
    }

    public CacheNested<A> editCache() {
        return this.withNewCacheLike(Optional.ofNullable(this.buildCache()).orElse(null));
    }

    public CacheNested<A> editOrNewCache() {
        return this.withNewCacheLike(Optional.ofNullable(this.buildCache()).orElse(new CacheBuilder().build()));
    }

    public CacheNested<A> editOrNewCacheLike(Cache item) {
        return this.withNewCacheLike(Optional.ofNullable(this.buildCache()).orElse(item));
    }

    public Configuration buildConfiguration() {
        return this.configuration != null ? this.configuration.build() : null;
    }

    public A withConfiguration(Configuration configuration) {
        this._visitables.remove((Object)"configuration");
        if (configuration != null) {
            this.configuration = new ConfigurationBuilder(configuration);
            this._visitables.get((Object)"configuration").add(this.configuration);
        } else {
            this.configuration = null;
            this._visitables.get((Object)"configuration").remove((Object)this.configuration);
        }
        return (A)((Object)this);
    }

    public boolean hasConfiguration() {
        return this.configuration != null;
    }

    public ConfigurationNested<A> withNewConfiguration() {
        return new ConfigurationNested(null);
    }

    public ConfigurationNested<A> withNewConfigurationLike(Configuration item) {
        return new ConfigurationNested(item);
    }

    public ConfigurationNested<A> editConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(null));
    }

    public ConfigurationNested<A> editOrNewConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(new ConfigurationBuilder().build()));
    }

    public ConfigurationNested<A> editOrNewConfigurationLike(Configuration item) {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(item));
    }

    public String getContextDir() {
        return this.contextDir;
    }

    public A withContextDir(String contextDir) {
        this.contextDir = contextDir;
        return (A)((Object)this);
    }

    public boolean hasContextDir() {
        return this.contextDir != null;
    }

    public String getExecutorImage() {
        return this.executorImage;
    }

    public A withExecutorImage(String executorImage) {
        this.executorImage = executorImage;
        return (A)((Object)this);
    }

    public boolean hasExecutorImage() {
        return this.executorImage != null;
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image = image;
        return (A)((Object)this);
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public Registry buildRegistry() {
        return this.registry != null ? this.registry.build() : null;
    }

    public A withRegistry(Registry registry) {
        this._visitables.remove((Object)"registry");
        if (registry != null) {
            this.registry = new RegistryBuilder(registry);
            this._visitables.get((Object)"registry").add(this.registry);
        } else {
            this.registry = null;
            this._visitables.get((Object)"registry").remove((Object)this.registry);
        }
        return (A)((Object)this);
    }

    public boolean hasRegistry() {
        return this.registry != null;
    }

    public RegistryNested<A> withNewRegistry() {
        return new RegistryNested(null);
    }

    public RegistryNested<A> withNewRegistryLike(Registry item) {
        return new RegistryNested(item);
    }

    public RegistryNested<A> editKanikoRegistry() {
        return this.withNewRegistryLike(Optional.ofNullable(this.buildRegistry()).orElse(null));
    }

    public RegistryNested<A> editOrNewRegistry() {
        return this.withNewRegistryLike(Optional.ofNullable(this.buildRegistry()).orElse(new RegistryBuilder().build()));
    }

    public RegistryNested<A> editOrNewRegistryLike(Registry item) {
        return this.withNewRegistryLike(Optional.ofNullable(this.buildRegistry()).orElse(item));
    }

    public Boolean getVerbose() {
        return this.verbose;
    }

    public A withVerbose(Boolean verbose) {
        this.verbose = verbose;
        return (A)((Object)this);
    }

    public boolean hasVerbose() {
        return this.verbose != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KanikoFluent that = (KanikoFluent)((Object)o);
        if (!Objects.equals(this.baseImage, that.baseImage)) {
            return false;
        }
        if (!Objects.equals((Object)this.cache, (Object)that.cache)) {
            return false;
        }
        if (!Objects.equals((Object)this.configuration, (Object)that.configuration)) {
            return false;
        }
        if (!Objects.equals(this.contextDir, that.contextDir)) {
            return false;
        }
        if (!Objects.equals(this.executorImage, that.executorImage)) {
            return false;
        }
        if (!Objects.equals(this.image, that.image)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals((Object)this.registry, (Object)that.registry)) {
            return false;
        }
        return Objects.equals(this.verbose, that.verbose);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.baseImage, this.cache, this.configuration, this.contextDir, this.executorImage, this.image, this.name, this.registry, this.verbose, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.baseImage != null) {
            sb.append("baseImage:");
            sb.append(this.baseImage + ",");
        }
        if (this.cache != null) {
            sb.append("cache:");
            sb.append(this.cache + ",");
        }
        if (this.configuration != null) {
            sb.append("configuration:");
            sb.append(this.configuration + ",");
        }
        if (this.contextDir != null) {
            sb.append("contextDir:");
            sb.append(this.contextDir + ",");
        }
        if (this.executorImage != null) {
            sb.append("executorImage:");
            sb.append(this.executorImage + ",");
        }
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.registry != null) {
            sb.append("registry:");
            sb.append(this.registry + ",");
        }
        if (this.verbose != null) {
            sb.append("verbose:");
            sb.append(this.verbose);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withVerbose() {
        return this.withVerbose(true);
    }

    public class CacheNested<N>
    extends CacheFluent<CacheNested<N>>
    implements Nested<N> {
        CacheBuilder builder;

        CacheNested(Cache item) {
            this.builder = new CacheBuilder(this, item);
        }

        public N and() {
            return (N)KanikoFluent.this.withCache(this.builder.build());
        }

        public N endCache() {
            return this.and();
        }
    }

    public class ConfigurationNested<N>
    extends ConfigurationFluent<ConfigurationNested<N>>
    implements Nested<N> {
        ConfigurationBuilder builder;

        ConfigurationNested(Configuration item) {
            this.builder = new ConfigurationBuilder(this, item);
        }

        public N and() {
            return (N)KanikoFluent.this.withConfiguration(this.builder.build());
        }

        public N endConfiguration() {
            return this.and();
        }
    }

    public class RegistryNested<N>
    extends RegistryFluent<RegistryNested<N>>
    implements Nested<N> {
        RegistryBuilder builder;

        RegistryNested(Registry item) {
            this.builder = new RegistryBuilder(this, item);
        }

        public N and() {
            return (N)KanikoFluent.this.withRegistry(this.builder.build());
        }

        public N endKanikoRegistry() {
            return this.and();
        }
    }
}

