/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.conn;

import java.io.PrintWriter;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import org.apache.cayenne.conn.DriverDataSource;
import org.apache.cayenne.conn.PooledConnectionImpl;

public class PoolDataSource
implements ConnectionPoolDataSource {
    private DataSource nonPooledDatasource;

    public PoolDataSource(DataSource nonPooledDatasource) {
        this.nonPooledDatasource = nonPooledDatasource;
    }

    public PoolDataSource(String jdbcDriver, String connectionUrl) throws SQLException {
        this.nonPooledDatasource = new DriverDataSource(jdbcDriver, connectionUrl);
    }

    public int getLoginTimeout() throws SQLException {
        return this.nonPooledDatasource.getLoginTimeout();
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.nonPooledDatasource.setLoginTimeout(seconds);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.nonPooledDatasource.getLogWriter();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.nonPooledDatasource.setLogWriter(out);
    }

    public PooledConnection getPooledConnection() throws SQLException {
        return new PooledConnectionImpl(this.nonPooledDatasource, null, null);
    }

    public PooledConnection getPooledConnection(String user, String password) throws SQLException {
        return new PooledConnectionImpl(this.nonPooledDatasource, user, password);
    }

    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new UnsupportedOperationException();
    }
}

