/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.graph;

import org.apache.cayenne.graph.GraphChangeHandler;
import org.apache.cayenne.graph.NodeDiff;
import org.apache.cayenne.util.Util;

public class NodePropertyChangeOperation
extends NodeDiff {
    private static final long serialVersionUID = 3282063727025159961L;
    protected String property;
    protected Object oldValue;
    protected Object newValue;

    public NodePropertyChangeOperation(Object nodeId, String property, Object oldValue, Object newValue) {
        super(nodeId);
        this.property = property;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public NodePropertyChangeOperation(Object nodeId, String property, Object oldValue, Object newValue, int diffId) {
        super(nodeId, diffId);
        this.property = property;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public String getProperty() {
        return this.property;
    }

    void setNewValue(Object newValue) {
        this.newValue = newValue;
    }

    @Override
    public boolean isNoop() {
        return Util.nullSafeEquals(this.oldValue, this.newValue);
    }

    @Override
    public void apply(GraphChangeHandler tracker) {
        tracker.nodePropertyChanged(this.nodeId, this.property, this.oldValue, this.newValue);
    }

    @Override
    public void undo(GraphChangeHandler tracker) {
        tracker.nodePropertyChanged(this.nodeId, this.property, this.newValue, this.oldValue);
    }
}

