/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.PrefetchObjectResolver;
import org.apache.cayenne.access.PrefetchProcessorNode;
import org.apache.cayenne.exp.path.CayennePath;
import org.apache.cayenne.reflect.ClassDescriptor;

class HierarchicalObjectResolverNode
extends PrefetchObjectResolver {
    private PrefetchProcessorNode node;

    HierarchicalObjectResolverNode(PrefetchProcessorNode node, DataContext context, ClassDescriptor descriptor, boolean refresh, Map<ObjectId, Persistent> seen) {
        super(context, descriptor, refresh, seen);
        this.node = node;
    }

    @Override
    List<Persistent> objectsFromDataRows(List<? extends DataRow> rows) {
        if (rows == null || rows.size() == 0) {
            return new ArrayList<Persistent>(1);
        }
        ArrayList<Persistent> results = new ArrayList<Persistent>(rows.size());
        for (DataRow dataRow : rows) {
            ClassDescriptor classDescriptor;
            ObjectId anId;
            Persistent object = this.objectFromDataRow(dataRow, anId = this.createObjectId(dataRow, (classDescriptor = this.descriptorResolutionStrategy.descriptorForRow(dataRow)).getEntity(), CayennePath.EMPTY_PATH), classDescriptor);
            if (object == null) {
                throw new CayenneRuntimeException("Can't build Object from row: %s", dataRow);
            }
            results.add(object);
            this.node.getParentAttachmentStrategy().linkToParent(dataRow, object);
        }
        this.cache.snapshotsUpdatedForObjects(results, rows, this.refreshObjects);
        return results;
    }
}

