/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.DataSourceDescriptor;
import org.apache.cayenne.configuration.event.DataNodeEvent;
import org.apache.cayenne.configuration.event.QueryEvent;
import org.apache.cayenne.configuration.runtime.JNDIDataSourceFactory;
import org.apache.cayenne.configuration.runtime.XMLPoolingDataSourceFactory;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dbsync.naming.NameBuilder;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.CreateNodeAction;
import org.apache.cayenne.modeler.dialog.ErrorDebugDialog;
import org.apache.cayenne.modeler.event.DataMapDisplayEvent;
import org.apache.cayenne.modeler.event.DataNodeDisplayEvent;
import org.apache.cayenne.modeler.pref.FSPath;
import org.apache.cayenne.modeler.util.AdapterMapping;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.modeler.util.FileFilters;
import org.apache.cayenne.wocompat.EOModelProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportEOModelAction
extends CayenneAction {
    private static Logger logObj = LoggerFactory.getLogger(ImportEOModelAction.class);
    protected JFileChooser eoModelChooser;

    public static String getActionName() {
        return "Import EOModel";
    }

    public ImportEOModelAction(Application application) {
        super(ImportEOModelAction.getActionName(), application);
    }

    @Override
    public String getIconName() {
        return "icon-eomodel.png";
    }

    @Override
    public void performAction(ActionEvent event) {
        this.importEOModel();
    }

    protected void importEOModel() {
        JFileChooser fileChooser = this.getEOModelChooser();
        int status = fileChooser.showOpenDialog(Application.getFrame());
        if (status == 0) {
            FSPath lastDir = this.getApplication().getFrameController().getLastEOModelDirectory();
            lastDir.updateFromChooser(fileChooser);
            File file = fileChooser.getSelectedFile();
            if (file.isFile()) {
                file = file.getParentFile();
            }
            DataMap currentMap = this.getProjectController().getCurrentDataMap();
            try {
                URL url = file.toURI().toURL();
                EOModelProcessor processor = new EOModelProcessor();
                if (currentMap == null) {
                    this.loadDataNode(processor.loadModeIndex(url));
                }
                DataMap map = processor.loadEOModel(url);
                this.addDataMap(map, currentMap);
            }
            catch (Exception ex) {
                logObj.info("EOModel Loading Exception", ex);
                ErrorDebugDialog.guiException(ex);
            }
        }
    }

    protected void loadDataNode(Map eomodelIndex) {
        String adapter = (String)eomodelIndex.get("adaptorName");
        Map connection = (Map)eomodelIndex.get("connectionDictionary");
        if (adapter != null && connection != null) {
            CreateNodeAction nodeBuilder = this.getApplication().getActionManager().getAction(CreateNodeAction.class);
            DataNodeDescriptor node = nodeBuilder.buildDataNode();
            if ("JNDI".equalsIgnoreCase(adapter)) {
                node.setDataSourceFactoryType(JNDIDataSourceFactory.class.getName());
                node.setParameters((String)connection.get("serverUrl"));
            } else {
                AdapterMapping adapterDefaults = this.getApplication().getAdapterMapping();
                String cayenneAdapter = adapterDefaults.adapterForEOFPluginOrDriver((String)connection.get("plugin"), (String)connection.get("driver"));
                if (cayenneAdapter != null) {
                    try {
                        Class<DbAdapter> adapterClass = this.getApplication().getClassLoadingService().loadClass(DbAdapter.class, cayenneAdapter);
                        node.setAdapterType(adapterClass.toString());
                    }
                    catch (Throwable adapterClass) {
                        // empty catch block
                    }
                }
                node.setDataSourceFactoryType(XMLPoolingDataSourceFactory.class.getName());
                DataSourceDescriptor dsi = node.getDataSourceDescriptor();
                dsi.setDataSourceUrl(this.keyAsString(connection, "URL"));
                dsi.setJdbcDriver(this.keyAsString(connection, "driver"));
                dsi.setPassword(this.keyAsString(connection, "password"));
                dsi.setUserName(this.keyAsString(connection, "username"));
            }
            DataChannelDescriptor domain = (DataChannelDescriptor)this.getProjectController().getProject().getRootNode();
            domain.getNodeDescriptors().add(node);
            this.getProjectController().fireDataNodeEvent(new DataNodeEvent((Object)this, node, 2));
            this.getProjectController().fireDataNodeDisplayEvent(new DataNodeDisplayEvent(this, (DataChannelDescriptor)this.getProjectController().getProject().getRootNode(), node));
        }
    }

    private String keyAsString(Map map, String key) {
        Object value = map.get(key);
        return value != null ? value.toString() : null;
    }

    protected void addDataMap(DataMap map, DataMap currentMap) {
        ProjectController mediator = this.getProjectController();
        if (currentMap != null) {
            ArrayList<ObjEntity> originalOE = new ArrayList<ObjEntity>(currentMap.getObjEntities());
            ArrayList<DbEntity> originalDE = new ArrayList<DbEntity>(currentMap.getDbEntities());
            ArrayList<QueryDescriptor> originalQueries = new ArrayList<QueryDescriptor>(currentMap.getQueryDescriptors());
            currentMap.mergeWithDataMap(map);
            map = currentMap;
            ArrayList<ObjEntity> newOE = new ArrayList<ObjEntity>(currentMap.getObjEntities());
            ArrayList<DbEntity> newDE = new ArrayList<DbEntity>(currentMap.getDbEntities());
            ArrayList<QueryDescriptor> newQueries = new ArrayList<QueryDescriptor>(currentMap.getQueryDescriptors());
            EntityEvent entityEvent = new EntityEvent((Object)Application.getFrame(), null);
            QueryEvent queryEvent = new QueryEvent((Object)Application.getFrame(), null);
            ArrayList<ObjEntity> addedOE = new ArrayList<ObjEntity>(newOE);
            addedOE.removeAll(originalOE);
            for (ObjEntity objEntity : addedOE) {
                entityEvent.setEntity(objEntity);
                entityEvent.setId(2);
                mediator.fireObjEntityEvent(entityEvent);
            }
            ArrayList<ObjEntity> removedOE = new ArrayList<ObjEntity>(originalOE);
            removedOE.removeAll(newOE);
            for (ObjEntity objEntity : removedOE) {
                entityEvent.setEntity(objEntity);
                entityEvent.setId(3);
                mediator.fireObjEntityEvent(entityEvent);
            }
            ArrayList<DbEntity> arrayList = new ArrayList<DbEntity>(newDE);
            arrayList.removeAll(originalDE);
            for (DbEntity dbEntity : arrayList) {
                entityEvent.setEntity(dbEntity);
                entityEvent.setId(2);
                mediator.fireDbEntityEvent(entityEvent);
            }
            ArrayList<DbEntity> arrayList2 = new ArrayList<DbEntity>(originalDE);
            arrayList2.removeAll(newDE);
            for (DbEntity dbEntity : arrayList2) {
                entityEvent.setEntity(dbEntity);
                entityEvent.setId(3);
                mediator.fireDbEntityEvent(entityEvent);
            }
            ArrayList<QueryDescriptor> arrayList3 = new ArrayList<QueryDescriptor>(newQueries);
            arrayList3.removeAll(originalQueries);
            for (QueryDescriptor q : arrayList3) {
                queryEvent.setQuery(q);
                queryEvent.setId(2);
                mediator.fireQueryEvent(queryEvent);
            }
            ArrayList<QueryDescriptor> arrayList4 = new ArrayList<QueryDescriptor>(originalQueries);
            arrayList4.removeAll(newQueries);
            for (QueryDescriptor q : arrayList4) {
                queryEvent.setQuery(q);
                queryEvent.setId(3);
                mediator.fireQueryEvent(queryEvent);
            }
            mediator.fireDataMapDisplayEvent(new DataMapDisplayEvent(Application.getFrame(), map, (DataChannelDescriptor)mediator.getProject().getRootNode(), mediator.getCurrentDataNode()));
        } else {
            ConfigurationNode root = mediator.getProject().getRootNode();
            map.setName(NameBuilder.builder(map, root).baseName(map.getName()).name());
            mediator.addDataMap(Application.getFrame(), map);
        }
    }

    public JFileChooser getEOModelChooser() {
        if (this.eoModelChooser == null) {
            this.eoModelChooser = new EOModelChooser("Select EOModel");
        }
        FSPath lastDir = this.getApplication().getFrameController().getLastEOModelDirectory();
        lastDir.updateChooser(this.eoModelChooser);
        return this.eoModelChooser;
    }

    class EOModelChooser
    extends JFileChooser {
        protected FileFilter selectFilter;
        protected JDialog cachedDialog;

        public EOModelChooser(String title) {
            super.setFileFilter(FileFilters.getEOModelFilter());
            super.setDialogTitle(title);
            super.setFileSelectionMode(2);
            this.selectFilter = FileFilters.getEOModelSelectFilter();
        }

        @Override
        public int showOpenDialog(Component parent) {
            int status = super.showOpenDialog(parent);
            if (status != 0) {
                this.cachedDialog = null;
                return status;
            }
            File file = this.getSelectedFile();
            if (this.selectFilter.accept(file)) {
                this.cachedDialog = null;
                return 0;
            }
            if (file.isDirectory()) {
                this.setCurrentDirectory(file);
            }
            return this.showOpenDialog(parent);
        }

        @Override
        protected JDialog createDialog(Component parent) throws HeadlessException {
            if (this.cachedDialog == null) {
                this.cachedDialog = super.createDialog(parent);
            }
            return this.cachedDialog;
        }
    }
}

