/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util.state;

import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.event.QueryDisplayEvent;
import org.apache.cayenne.modeler.util.state.DisplayEventType;

class QueryDisplayEventType
extends DisplayEventType {
    public QueryDisplayEventType(ProjectController controller) {
        super(controller);
    }

    @Override
    public void fireLastDisplayEvent() {
        DataChannelDescriptor dataChannel = (DataChannelDescriptor)this.controller.getProject().getRootNode();
        if (!dataChannel.getName().equals(this.preferences.getDomain())) {
            return;
        }
        DataMap dataMap = dataChannel.getDataMap(this.preferences.getDataMap());
        if (dataMap == null) {
            return;
        }
        QueryDescriptor query = dataMap.getQueryDescriptor(this.preferences.getQuery());
        if (query == null) {
            return;
        }
        QueryDisplayEvent queryDisplayEvent = new QueryDisplayEvent((Object)this, query, dataMap, dataChannel);
        this.controller.fireQueryDisplayEvent(queryDisplayEvent);
    }

    @Override
    public void saveLastDisplayEvent() {
        this.preferences.setEvent(QueryDisplayEvent.class.getSimpleName());
        this.preferences.setDomain(this.controller.getCurrentDataChanel().getName());
        this.preferences.setDataMap(this.controller.getCurrentDataMap().getName());
        this.preferences.setQuery(this.controller.getCurrentQuery().getName());
    }
}

