/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validation;

import java.util.function.Supplier;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.project.validation.ConfigurationNodeValidator;
import org.apache.cayenne.project.validation.Inspection;
import org.apache.cayenne.project.validation.ValidationConfig;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationResult;

class DataChannelValidator
extends ConfigurationNodeValidator<DataChannelDescriptor> {
    public DataChannelValidator(Supplier<ValidationConfig> configSupplier) {
        super(configSupplier);
    }

    @Override
    public void validate(DataChannelDescriptor node, ValidationResult validationResult) {
        this.on(node, validationResult).performIfEnabled(Inspection.DATA_CHANNEL_NO_NAME, this::checkForName);
    }

    private void checkForName(DataChannelDescriptor domain, ValidationResult validationResult) {
        String name = domain.getName();
        if (Util.isEmptyString(name)) {
            this.addFailure(validationResult, domain, "Unnamed DataDomain", new Object[0]);
        }
    }
}

