/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.batch;

import org.apache.cayenne.access.sqlbuilder.SQLBuilder;
import org.apache.cayenne.access.sqlbuilder.UpdateBuilder;
import org.apache.cayenne.access.translator.DbAttributeBinding;
import org.apache.cayenne.access.translator.batch.DeleteBatchTranslator;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.query.BatchQueryRow;
import org.apache.cayenne.query.DeleteBatchQuery;

public class SoftDeleteBatchTranslator
extends DeleteBatchTranslator {
    private final String deletedFieldName;

    public SoftDeleteBatchTranslator(DeleteBatchQuery query, DbAdapter adapter, String deletedFieldName) {
        super(query, adapter);
        this.deletedFieldName = deletedFieldName;
    }

    @Override
    public String getSql() {
        DeleteBatchQuery query = (DeleteBatchQuery)this.context.getQuery();
        DbAttribute deleteAttribute = (DbAttribute)query.getDbEntity().getAttribute(this.deletedFieldName);
        UpdateBuilder updateBuilder = SQLBuilder.update(this.context.getRootDbEntity()).set(SQLBuilder.column(this.deletedFieldName).attribute(deleteAttribute).eq(SQLBuilder.value(true).attribute(deleteAttribute))).where(this.buildQualifier(query.getDbAttributes()));
        String sql = this.doTranslate(updateBuilder);
        String typeName = TypesMapping.getJavaBySqlType(deleteAttribute);
        ExtendedType extendedType = this.context.getAdapter().getExtendedTypes().getRegisteredType(typeName);
        this.bindings[0].include(1, true, extendedType);
        return sql;
    }

    @Override
    public DbAttributeBinding[] updateBindings(BatchQueryRow row) {
        DeleteBatchQuery deleteBatch = (DeleteBatchQuery)this.context.getQuery();
        int position = 1;
        for (int i = 0; i < deleteBatch.getDbAttributes().size(); ++i) {
            position = this.updateBinding(row.getValue(i), position);
        }
        return this.bindings;
    }
}

