/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.ashwood.graph;

import java.util.NoSuchElementException;
import java.util.function.Predicate;
import org.apache.cayenne.ashwood.graph.ArcIterator;

public class FilterArcIterator<E, V>
implements ArcIterator<E, V> {
    private ArcIterator<E, V> iterator;
    private Predicate<E> acceptOrigin;
    private Predicate<E> acceptDestination;
    private Predicate<V> acceptArc;
    private E nextOrigin;
    private E nextDst;
    private V nextArc;
    private boolean nextObjectSet = false;

    public FilterArcIterator(ArcIterator<E, V> iterator, Predicate<E> acceptOrigin, Predicate<E> acceptDestination, Predicate<V> acceptArc) {
        this.iterator = iterator;
        this.acceptOrigin = acceptOrigin;
        this.acceptDestination = acceptDestination;
        this.acceptArc = acceptArc;
        this.nextOrigin = iterator.getOrigin();
        if (!acceptOrigin.test(this.nextOrigin)) {
            this.nextOrigin = null;
        }
        this.nextDst = iterator.getDestination();
        if (!acceptDestination.test(this.nextDst)) {
            this.nextDst = null;
        }
    }

    @Override
    public E getOrigin() {
        return this.nextOrigin;
    }

    @Override
    public E getDestination() {
        return this.nextDst;
    }

    @Override
    public boolean hasNext() {
        if (this.nextObjectSet) {
            return true;
        }
        return this.setNextObject();
    }

    @Override
    public V next() {
        if (!this.nextObjectSet && !this.setNextObject()) {
            throw new NoSuchElementException();
        }
        this.nextObjectSet = false;
        return this.nextArc;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private boolean setNextObject() {
        while (this.iterator.hasNext()) {
            Object arc = this.iterator.next();
            E origin = this.iterator.getOrigin();
            E dst = this.iterator.getDestination();
            if (!this.acceptOrigin.test(origin) || !this.acceptArc.test(arc) || !this.acceptDestination.test(dst)) continue;
            this.nextArc = arc;
            this.nextOrigin = origin;
            this.nextDst = dst;
            this.nextObjectSet = true;
            return true;
        }
        return false;
    }
}

