/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import org.apache.cayenne.modeler.undo.JComboBoxUndoListener;
import org.apache.cayenne.modeler.util.CayenneCellEditor;
import org.apache.cayenne.modeler.util.JCayenneTextPaneUndoable;
import org.apache.cayenne.modeler.util.JEditTextAreaUndoable;
import org.apache.cayenne.modeler.util.JTextFieldUndoable;
import org.apache.cayenne.modeler.util.OperatingSystem;
import org.apache.cayenne.modeler.util.combo.ComboBoxCellEditor;
import org.apache.cayenne.swing.components.textpane.JCayenneTextPane;
import org.apache.cayenne.swing.components.textpane.syntax.EJBQLSyntaxConstant;
import org.syntax.jedit.DefaultInputHandler;
import org.syntax.jedit.JEditTextArea;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CayenneWidgetFactory {
    protected CayenneWidgetFactory() {
    }

    public static JComboBox createComboBox(Collection<String> model, boolean sort) {
        return CayenneWidgetFactory.createComboBox(model.toArray(), sort);
    }

    public static JComboBox createComboBox(Object[] model, boolean sort) {
        JComboBox comboBox = CayenneWidgetFactory.createComboBox();
        if (sort) {
            Arrays.sort(model);
        }
        comboBox.setModel(new DefaultComboBoxModel<Object>(model));
        return comboBox;
    }

    public static JComboBox createComboBox() {
        JComboBox comboBox = new JComboBox();
        CayenneWidgetFactory.initFormWidget(comboBox);
        comboBox.setBackground(Color.WHITE);
        comboBox.setMaximumRowCount(12);
        return comboBox;
    }

    public static JComboBox createUndoableComboBox() {
        JComboBox comboBox = new JComboBox();
        CayenneWidgetFactory.initFormWidget(comboBox);
        comboBox.addItemListener(new JComboBoxUndoListener());
        comboBox.setBackground(Color.WHITE);
        comboBox.setMaximumRowCount(12);
        return comboBox;
    }

    public static JTextField createUndoableTextField() {
        return new JTextFieldUndoable();
    }

    public static JTextField createUndoableTextField(int size) {
        return new JTextFieldUndoable(size);
    }

    public static DefaultCellEditor createCellEditor(JTextField textField) {
        return new CayenneCellEditor(textField);
    }

    public static TableCellEditor createCellEditor(JComboBox combo) {
        if (Boolean.TRUE.equals(combo.getClientProperty("JComboBox.autoCompletion"))) {
            return new ComboBoxCellEditor(combo);
        }
        DefaultCellEditor editor = new DefaultCellEditor(combo);
        editor.setClickCountToStart(1);
        return editor;
    }

    public static JTextField createTextField() {
        return CayenneWidgetFactory.createTextField(20);
    }

    public static JTextField createTextField(int columns) {
        JTextField textField = new JTextField(columns);
        CayenneWidgetFactory.initFormWidget(textField);
        CayenneWidgetFactory.initTextField(textField);
        return textField;
    }

    protected static void initTextField(final JTextField textField) {
        textField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                textField.transferFocus();
            }
        });
    }

    protected static void initFormWidget(JComponent component) {
        component.setFont(component.getFont().deriveFont(0, 12.0f));
    }

    public static JButton createLabelButton(String text) {
        JButton but = CayenneWidgetFactory.createButton(text);
        but.setBorderPainted(false);
        but.setHorizontalAlignment(2);
        but.setFocusPainted(false);
        but.setMargin(new Insets(0, 0, 0, 0));
        but.setBorder(null);
        return but;
    }

    public static JButton createButton(String text) {
        return new JButton(text);
    }

    public static JEditTextArea createJEditTextArea() {
        JEditTextAreaUndoable area = new JEditTextAreaUndoable();
        if (OperatingSystem.getOS() == OperatingSystem.MAC_OS_X) {
            area.setInputHandler(new MacInputHandler());
        }
        return area;
    }

    public static JCayenneTextPane createJEJBQLTextPane() {
        JCayenneTextPaneUndoable area = new JCayenneTextPaneUndoable(new EJBQLSyntaxConstant());
        return area;
    }

    private static class MacInputHandler
    extends DefaultInputHandler {
        MacInputHandler() {
            this.addDefaultKeyBindings();
        }

        public void addDefaultKeyBindings() {
            this.addKeyBinding("BACK_SPACE", BACKSPACE);
            this.addKeyBinding("M+BACK_SPACE", BACKSPACE_WORD);
            this.addKeyBinding("DELETE", DELETE);
            this.addKeyBinding("M+DELETE", DELETE_WORD);
            this.addKeyBinding("ENTER", INSERT_BREAK);
            this.addKeyBinding("TAB", INSERT_TAB);
            this.addKeyBinding("INSERT", OVERWRITE);
            this.addKeyBinding("M+\\", TOGGLE_RECT);
            this.addKeyBinding("HOME", HOME);
            this.addKeyBinding("END", END);
            this.addKeyBinding("M+A", SELECT_ALL);
            this.addKeyBinding("S+HOME", SELECT_HOME);
            this.addKeyBinding("S+END", SELECT_END);
            this.addKeyBinding("M+HOME", DOCUMENT_HOME);
            this.addKeyBinding("M+END", DOCUMENT_END);
            this.addKeyBinding("MS+HOME", SELECT_DOC_HOME);
            this.addKeyBinding("MS+END", SELECT_DOC_END);
            this.addKeyBinding("PAGE_UP", PREV_PAGE);
            this.addKeyBinding("PAGE_DOWN", NEXT_PAGE);
            this.addKeyBinding("S+PAGE_UP", SELECT_PREV_PAGE);
            this.addKeyBinding("S+PAGE_DOWN", SELECT_NEXT_PAGE);
            this.addKeyBinding("LEFT", PREV_CHAR);
            this.addKeyBinding("S+LEFT", SELECT_PREV_CHAR);
            this.addKeyBinding("A+LEFT", PREV_WORD);
            this.addKeyBinding("AS+LEFT", SELECT_PREV_WORD);
            this.addKeyBinding("RIGHT", NEXT_CHAR);
            this.addKeyBinding("S+RIGHT", SELECT_NEXT_CHAR);
            this.addKeyBinding("A+RIGHT", NEXT_WORD);
            this.addKeyBinding("AS+RIGHT", SELECT_NEXT_WORD);
            this.addKeyBinding("UP", PREV_LINE);
            this.addKeyBinding("S+UP", SELECT_PREV_LINE);
            this.addKeyBinding("DOWN", NEXT_LINE);
            this.addKeyBinding("S+DOWN", SELECT_NEXT_LINE);
            this.addKeyBinding("M+ENTER", REPEAT);
            this.addKeyBinding("M+C", CLIP_COPY);
            this.addKeyBinding("M+V", CLIP_PASTE);
            this.addKeyBinding("M+X", CLIP_CUT);
        }
    }
}

