/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.beanutils.BasicDynaClass;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.beanutils.TestBean;

public class DynaPropertyUtilsTestCase
extends TestCase {
    protected DynaBean bean;
    protected String[] describes = new String[]{"booleanProperty", "booleanSecond", "doubleProperty", "floatProperty", "intArray", "intIndexed", "intProperty", "listIndexed", "longProperty", "mappedObjects", "mappedProperty", "mappedIntProperty", "nested", "nullProperty", "shortProperty", "stringArray", "stringIndexed", "stringProperty"};
    protected TestBean nested;

    public static Test suite() {
        return new TestSuite(DynaPropertyUtilsTestCase.class);
    }

    public DynaPropertyUtilsTestCase(String name) {
        super(name);
    }

    protected DynaClass createDynaClass() {
        int[] intArray = new int[]{};
        String[] stringArray = new String[]{};
        return new BasicDynaClass("TestDynaClass", null, new DynaProperty[]{new DynaProperty("booleanProperty", Boolean.TYPE), new DynaProperty("booleanSecond", Boolean.TYPE), new DynaProperty("doubleProperty", Double.TYPE), new DynaProperty("dupProperty", stringArray.getClass()), new DynaProperty("floatProperty", Float.TYPE), new DynaProperty("intArray", intArray.getClass()), new DynaProperty("intIndexed", intArray.getClass()), new DynaProperty("intProperty", Integer.TYPE), new DynaProperty("listIndexed", List.class), new DynaProperty("longProperty", Long.TYPE), new DynaProperty("mapProperty", Map.class), new DynaProperty("mappedObjects", Map.class), new DynaProperty("mappedProperty", Map.class), new DynaProperty("mappedIntProperty", Map.class), new DynaProperty("nested", TestBean.class), new DynaProperty("nullProperty", String.class), new DynaProperty("shortProperty", Short.TYPE), new DynaProperty("stringArray", stringArray.getClass()), new DynaProperty("stringIndexed", stringArray.getClass()), new DynaProperty("stringProperty", String.class)});
    }

    public void setUp() throws Exception {
        DynaClass dynaClass = this.createDynaClass();
        this.bean = dynaClass.newInstance();
        this.bean.set("booleanProperty", (Object)true);
        this.bean.set("booleanSecond", (Object)true);
        this.bean.set("doubleProperty", (Object)321.0);
        this.bean.set("floatProperty", (Object)Float.valueOf(123.0f));
        int[] intArray = new int[]{0, 10, 20, 30, 40};
        this.bean.set("intArray", (Object)intArray);
        int[] intIndexed = new int[]{0, 10, 20, 30, 40};
        this.bean.set("intIndexed", (Object)intIndexed);
        this.bean.set("intProperty", (Object)123);
        ArrayList<String> listIndexed = new ArrayList<String>();
        listIndexed.add("String 0");
        listIndexed.add("String 1");
        listIndexed.add("String 2");
        listIndexed.add("String 3");
        listIndexed.add("String 4");
        this.bean.set("listIndexed", listIndexed);
        this.bean.set("longProperty", (Object)321L);
        HashMap<String, String> mapProperty = new HashMap<String, String>();
        mapProperty.put("First Key", "First Value");
        mapProperty.put("Second Key", "Second Value");
        this.bean.set("mapProperty", mapProperty);
        HashMap<String, String> mappedObjects = new HashMap<String, String>();
        mappedObjects.put("First Key", "First Value");
        mappedObjects.put("Second Key", "Second Value");
        this.bean.set("mappedObjects", mappedObjects);
        HashMap<String, String> mappedProperty = new HashMap<String, String>();
        mappedProperty.put("First Key", "First Value");
        mappedProperty.put("Second Key", "Second Value");
        this.bean.set("mappedProperty", mappedProperty);
        HashMap<String, Integer> mappedIntProperty = new HashMap<String, Integer>();
        mappedIntProperty.put("One", 1);
        mappedIntProperty.put("Two", 2);
        this.bean.set("mappedIntProperty", mappedIntProperty);
        this.nested = new TestBean();
        this.bean.set("nested", (Object)this.nested);
        this.bean.set("shortProperty", (Object)987);
        String[] stringArray = new String[]{"String 0", "String 1", "String 2", "String 3", "String 4"};
        this.bean.set("stringArray", (Object)stringArray);
        String[] stringIndexed = new String[]{"String 0", "String 1", "String 2", "String 3", "String 4"};
        this.bean.set("stringIndexed", (Object)stringIndexed);
        this.bean.set("stringProperty", (Object)"This is a string");
    }

    public void tearDown() {
        this.bean = null;
        this.nested = null;
    }

    public void testCopyPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("booleanProperty", Boolean.FALSE);
        map.put("doubleProperty", 333.0);
        map.put("dupProperty", new String[]{"New 0", "New 1", "New 2"});
        map.put("floatProperty", Float.valueOf(222.0f));
        map.put("intArray", new int[]{0, 100, 200});
        map.put("intProperty", 111);
        map.put("longProperty", 444L);
        map.put("shortProperty", (short)555);
        map.put("stringProperty", "New String Property");
        try {
            PropertyUtils.copyProperties((Object)this.bean, map);
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t.toString()));
        }
        DynaPropertyUtilsTestCase.assertEquals((String)"booleanProperty", (boolean)false, (boolean)((Boolean)this.bean.get("booleanProperty")));
        DynaPropertyUtilsTestCase.assertEquals((String)"doubleProperty", (double)333.0, (double)((Double)this.bean.get("doubleProperty")), (double)0.005);
        DynaPropertyUtilsTestCase.assertEquals((String)"floatProperty", (float)222.0f, (float)((Float)this.bean.get("floatProperty")).floatValue(), (float)0.005f);
        DynaPropertyUtilsTestCase.assertEquals((String)"intProperty", (int)111, (int)((Integer)this.bean.get("intProperty")));
        DynaPropertyUtilsTestCase.assertEquals((String)"longProperty", (long)444L, (long)((Long)this.bean.get("longProperty")));
        DynaPropertyUtilsTestCase.assertEquals((String)"shortProperty", (short)555, (short)((Short)this.bean.get("shortProperty")));
        DynaPropertyUtilsTestCase.assertEquals((String)"stringProperty", (String)"New String Property", (String)((String)this.bean.get("stringProperty")));
        String[] dupProperty = (String[])this.bean.get("dupProperty");
        DynaPropertyUtilsTestCase.assertNotNull((String)"dupProperty present", (Object)dupProperty);
        DynaPropertyUtilsTestCase.assertEquals((String)"dupProperty length", (int)3, (int)dupProperty.length);
        DynaPropertyUtilsTestCase.assertEquals((String)"dupProperty[0]", (String)"New 0", (String)dupProperty[0]);
        DynaPropertyUtilsTestCase.assertEquals((String)"dupProperty[1]", (String)"New 1", (String)dupProperty[1]);
        DynaPropertyUtilsTestCase.assertEquals((String)"dupProperty[2]", (String)"New 2", (String)dupProperty[2]);
        int[] intArray = (int[])this.bean.get("intArray");
        DynaPropertyUtilsTestCase.assertNotNull((String)"intArray present", (Object)intArray);
        DynaPropertyUtilsTestCase.assertEquals((String)"intArray length", (int)3, (int)intArray.length);
        DynaPropertyUtilsTestCase.assertEquals((String)"intArray[0]", (int)0, (int)intArray[0]);
        DynaPropertyUtilsTestCase.assertEquals((String)"intArray[1]", (int)100, (int)intArray[1]);
        DynaPropertyUtilsTestCase.assertEquals((String)"intArray[2]", (int)200, (int)intArray[2]);
    }

    public void testDescribe() {
        Map map = null;
        try {
            map = PropertyUtils.describe((Object)this.bean);
        }
        catch (Exception e) {
            DynaPropertyUtilsTestCase.fail((String)("Threw exception " + e));
        }
        for (String describe : this.describes) {
            DynaPropertyUtilsTestCase.assertTrue((String)("Property '" + describe + "' is present"), (boolean)map.containsKey(describe));
        }
        DynaPropertyUtilsTestCase.assertTrue((String)"Property 'writeOnlyProperty' is not present", (!map.containsKey("writeOnlyProperty") ? 1 : 0) != 0);
        DynaPropertyUtilsTestCase.assertEquals((String)"Value of 'booleanProperty'", (Object)Boolean.TRUE, map.get("booleanProperty"));
        DynaPropertyUtilsTestCase.assertEquals((String)"Value of 'doubleProperty'", (Object)321.0, map.get("doubleProperty"));
        DynaPropertyUtilsTestCase.assertEquals((String)"Value of 'floatProperty'", (Object)Float.valueOf(123.0f), map.get("floatProperty"));
        DynaPropertyUtilsTestCase.assertEquals((String)"Value of 'intProperty'", (Object)123, map.get("intProperty"));
        DynaPropertyUtilsTestCase.assertEquals((String)"Value of 'longProperty'", (Object)321L, map.get("longProperty"));
        DynaPropertyUtilsTestCase.assertEquals((String)"Value of 'shortProperty'", (Object)987, map.get("shortProperty"));
        DynaPropertyUtilsTestCase.assertEquals((String)"Value of 'stringProperty'", (String)"This is a string", (String)((String)map.get("stringProperty")));
    }

    public void testGetIndexedArguments() {
        try {
            PropertyUtils.getIndexedProperty(null, (String)"intArray", (int)0);
            DynaPropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 1");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 1"));
        }
        try {
            PropertyUtils.getIndexedProperty((Object)this.bean, null, (int)0);
            DynaPropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 2");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 2"));
        }
        try {
            PropertyUtils.getIndexedProperty(null, (String)"intArray[0]");
            DynaPropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 3");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 3"));
        }
        try {
            PropertyUtils.getIndexedProperty((Object)this.bean, (String)"[0]");
            DynaPropertyUtilsTestCase.fail((String)"Should throw NoSuchMethodException 4");
        }
        catch (NoSuchMethodException t) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of NoSuchMethodException 4"));
        }
        try {
            PropertyUtils.getIndexedProperty((Object)this.bean, (String)"intArray");
            DynaPropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 5");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 5"));
        }
        try {
            PropertyUtils.getIndexedProperty(null, (String)"intIndexed", (int)0);
            DynaPropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 1");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 1"));
        }
        try {
            PropertyUtils.getIndexedProperty((Object)this.bean, null, (int)0);
            DynaPropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 2");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 2"));
        }
        try {
            PropertyUtils.getIndexedProperty(null, (String)"intIndexed[0]");
            DynaPropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 3");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 3"));
        }
        try {
            PropertyUtils.getIndexedProperty((Object)this.bean, (String)"[0]");
            DynaPropertyUtilsTestCase.fail((String)"Should throw NoSuchMethodException 4");
        }
        catch (NoSuchMethodException t) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of NoSuchMethodException 4"));
        }
        try {
            PropertyUtils.getIndexedProperty((Object)this.bean, (String)"intIndexed");
            DynaPropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 5");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 5"));
        }
    }

    public void testGetIndexedValues() {
        int i;
        Object value = null;
        for (i = 0; i < 5; ++i) {
            try {
                value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"intArray", (int)i);
                DynaPropertyUtilsTestCase.assertNotNull((String)("intArray returned value " + i), (Object)value);
                DynaPropertyUtilsTestCase.assertTrue((String)("intArray returned Integer " + i), (boolean)(value instanceof Integer));
                DynaPropertyUtilsTestCase.assertEquals((String)("intArray returned correct " + i), (int)(i * 10), (int)((Integer)value));
            }
            catch (Throwable t) {
                DynaPropertyUtilsTestCase.fail((String)("intArray " + i + " threw " + t));
            }
            try {
                value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"intIndexed", (int)i);
                DynaPropertyUtilsTestCase.assertNotNull((String)("intIndexed returned value " + i), (Object)value);
                DynaPropertyUtilsTestCase.assertTrue((String)("intIndexed returned Integer " + i), (boolean)(value instanceof Integer));
                DynaPropertyUtilsTestCase.assertEquals((String)("intIndexed returned correct " + i), (int)(i * 10), (int)((Integer)value));
            }
            catch (Throwable t) {
                DynaPropertyUtilsTestCase.fail((String)("intIndexed " + i + " threw " + t));
            }
            try {
                value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"listIndexed", (int)i);
                DynaPropertyUtilsTestCase.assertNotNull((String)("listIndexed returned value " + i), (Object)value);
                DynaPropertyUtilsTestCase.assertTrue((String)("list returned String " + i), (boolean)(value instanceof String));
                DynaPropertyUtilsTestCase.assertEquals((String)("listIndexed returned correct " + i), (String)("String " + i), (String)((String)value));
            }
            catch (Throwable t) {
                DynaPropertyUtilsTestCase.fail((String)("listIndexed " + i + " threw " + t));
            }
            try {
                value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"stringArray", (int)i);
                DynaPropertyUtilsTestCase.assertNotNull((String)("stringArray returned value " + i), (Object)value);
                DynaPropertyUtilsTestCase.assertTrue((String)("stringArray returned String " + i), (boolean)(value instanceof String));
                DynaPropertyUtilsTestCase.assertEquals((String)("stringArray returned correct " + i), (String)("String " + i), (String)((String)value));
            }
            catch (Throwable t) {
                DynaPropertyUtilsTestCase.fail((String)("stringArray " + i + " threw " + t));
            }
            try {
                value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"stringIndexed", (int)i);
                DynaPropertyUtilsTestCase.assertNotNull((String)("stringIndexed returned value " + i), (Object)value);
                DynaPropertyUtilsTestCase.assertTrue((String)("stringIndexed returned String " + i), (boolean)(value instanceof String));
                DynaPropertyUtilsTestCase.assertEquals((String)("stringIndexed returned correct " + i), (String)("String " + i), (String)((String)value));
                continue;
            }
            catch (Throwable t) {
                DynaPropertyUtilsTestCase.fail((String)("stringIndexed " + i + " threw " + t));
            }
        }
        for (i = 0; i < 5; ++i) {
            try {
                value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)("intArray[" + i + "]"));
                DynaPropertyUtilsTestCase.assertNotNull((String)("intArray returned value " + i), (Object)value);
                DynaPropertyUtilsTestCase.assertTrue((String)("intArray returned Integer " + i), (boolean)(value instanceof Integer));
                DynaPropertyUtilsTestCase.assertEquals((String)("intArray returned correct " + i), (int)(i * 10), (int)((Integer)value));
            }
            catch (Throwable t) {
                DynaPropertyUtilsTestCase.fail((String)("intArray " + i + " threw " + t));
            }
            try {
                value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)("intIndexed[" + i + "]"));
                DynaPropertyUtilsTestCase.assertNotNull((String)("intIndexed returned value " + i), (Object)value);
                DynaPropertyUtilsTestCase.assertTrue((String)("intIndexed returned Integer " + i), (boolean)(value instanceof Integer));
                DynaPropertyUtilsTestCase.assertEquals((String)("intIndexed returned correct " + i), (int)(i * 10), (int)((Integer)value));
            }
            catch (Throwable t) {
                DynaPropertyUtilsTestCase.fail((String)("intIndexed " + i + " threw " + t));
            }
            try {
                value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)("listIndexed[" + i + "]"));
                DynaPropertyUtilsTestCase.assertNotNull((String)("listIndexed returned value " + i), (Object)value);
                DynaPropertyUtilsTestCase.assertTrue((String)("listIndexed returned String " + i), (boolean)(value instanceof String));
                DynaPropertyUtilsTestCase.assertEquals((String)("listIndexed returned correct " + i), (String)("String " + i), (String)((String)value));
            }
            catch (Throwable t) {
                DynaPropertyUtilsTestCase.fail((String)("listIndexed " + i + " threw " + t));
            }
            try {
                value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)("stringArray[" + i + "]"));
                DynaPropertyUtilsTestCase.assertNotNull((String)("stringArray returned value " + i), (Object)value);
                DynaPropertyUtilsTestCase.assertTrue((String)("stringArray returned String " + i), (boolean)(value instanceof String));
                DynaPropertyUtilsTestCase.assertEquals((String)("stringArray returned correct " + i), (String)("String " + i), (String)((String)value));
            }
            catch (Throwable t) {
                DynaPropertyUtilsTestCase.fail((String)("stringArray " + i + " threw " + t));
            }
            try {
                value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)("stringIndexed[" + i + "]"));
                DynaPropertyUtilsTestCase.assertNotNull((String)("stringIndexed returned value " + i), (Object)value);
                DynaPropertyUtilsTestCase.assertTrue((String)("stringIndexed returned String " + i), (boolean)(value instanceof String));
                DynaPropertyUtilsTestCase.assertEquals((String)("stringIndexed returned correct " + i), (String)("String " + i), (String)((String)value));
                continue;
            }
            catch (Throwable t) {
                DynaPropertyUtilsTestCase.fail((String)("stringIndexed " + i + " threw " + t));
            }
        }
        try {
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"intArray", (int)-1);
            DynaPropertyUtilsTestCase.fail((String)"Should have thrown ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException i2) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of ArrayIndexOutOfBoundsException"));
        }
        try {
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"intArray", (int)5);
            DynaPropertyUtilsTestCase.fail((String)"Should have thrown ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException t) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of ArrayIndexOutOfBoundsException"));
        }
        try {
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"intIndexed", (int)-1);
            DynaPropertyUtilsTestCase.fail((String)"Should have thrown ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException t) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of ArrayIndexOutOfBoundsException"));
        }
        try {
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"intIndexed", (int)5);
            DynaPropertyUtilsTestCase.fail((String)"Should have thrown ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException t) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of ArrayIndexOutOfBoundsException"));
        }
        try {
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"listIndexed", (int)-1);
            DynaPropertyUtilsTestCase.fail((String)"Should have thrown IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException t) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IndexOutOfBoundsException"));
        }
        try {
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"listIndexed", (int)5);
            DynaPropertyUtilsTestCase.fail((String)"Should have thrown IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException t) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IndexOutOfBoundsException"));
        }
        try {
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"stringArray", (int)-1);
            DynaPropertyUtilsTestCase.fail((String)"Should have thrown ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException t) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of ArrayIndexOutOfBoundsException"));
        }
        try {
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"stringArray", (int)5);
            DynaPropertyUtilsTestCase.fail((String)"Should have thrown ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException t) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of ArrayIndexOutOfBoundsException"));
        }
        try {
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"stringIndexed", (int)-1);
            DynaPropertyUtilsTestCase.fail((String)"Should have thrown ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException t) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of ArrayIndexOutOfBoundsException"));
        }
        try {
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"stringIndexed", (int)5);
            DynaPropertyUtilsTestCase.fail((String)"Should have thrown ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException t) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of ArrayIndexOutOfBoundsException"));
        }
    }

    public void testGetMappedArguments() {
        try {
            PropertyUtils.getMappedProperty(null, (String)"mappedProperty", (String)"First Key");
            DynaPropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 1");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 1"));
        }
        try {
            PropertyUtils.getMappedProperty((Object)this.bean, null, (String)"First Key");
            DynaPropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 2");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 2"));
        }
        try {
            PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty", null);
            DynaPropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 3");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 3"));
        }
        try {
            PropertyUtils.getMappedProperty(null, (String)"mappedProperty(First Key)");
            DynaPropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 4");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 4"));
        }
        try {
            PropertyUtils.getMappedProperty((Object)this.bean, (String)"(Second Key)");
            DynaPropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 5");
        }
        catch (NoSuchMethodException t) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of NoSuchMethodException 5"));
        }
        try {
            PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty");
            DynaPropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 6");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 6"));
        }
    }

    public void testGetMappedPeriods() {
        this.bean.set("mappedProperty", "key.with.a.dot", (Object)"Special Value");
        DynaPropertyUtilsTestCase.assertEquals((String)"Can retrieve directly", (String)"Special Value", (String)((String)this.bean.get("mappedProperty", "key.with.a.dot")));
        try {
            DynaPropertyUtilsTestCase.assertEquals((String)"Can retrieve via getMappedProperty", (Object)"Special Value", (Object)PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty", (String)"key.with.a.dot"));
        }
        catch (Exception e) {
            DynaPropertyUtilsTestCase.fail((String)("Thew exception: " + e));
        }
        try {
            DynaPropertyUtilsTestCase.assertEquals((String)"Can retrieve via getNestedProperty", (Object)"Special Value", (Object)PropertyUtils.getNestedProperty((Object)this.bean, (String)"mappedProperty(key.with.a.dot)"));
        }
        catch (Exception e) {
            DynaPropertyUtilsTestCase.fail((String)("Thew exception: " + e));
        }
        this.bean.set("mappedObjects", "nested.property", (Object)new TestBean());
        DynaPropertyUtilsTestCase.assertNotNull((String)"Can retrieve directly", (Object)this.bean.get("mappedObjects", "nested.property"));
        try {
            DynaPropertyUtilsTestCase.assertEquals((String)"Can retrieve nested", (Object)"This is a string", (Object)PropertyUtils.getNestedProperty((Object)this.bean, (String)"mappedObjects(nested.property).stringProperty"));
        }
        catch (Exception e) {
            DynaPropertyUtilsTestCase.fail((String)("Thew exception: " + e));
        }
    }

    public void testGetMappedSlashes() {
        this.bean.set("mappedProperty", "key/with/a/slash", (Object)"Special Value");
        DynaPropertyUtilsTestCase.assertEquals((String)"Can retrieve directly", (Object)"Special Value", (Object)this.bean.get("mappedProperty", "key/with/a/slash"));
        try {
            DynaPropertyUtilsTestCase.assertEquals((String)"Can retrieve via getMappedProperty", (Object)"Special Value", (Object)PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty", (String)"key/with/a/slash"));
        }
        catch (Exception e) {
            DynaPropertyUtilsTestCase.fail((String)("Thew exception: " + e));
        }
        try {
            DynaPropertyUtilsTestCase.assertEquals((String)"Can retrieve via getNestedProperty", (Object)"Special Value", (Object)PropertyUtils.getNestedProperty((Object)this.bean, (String)"mappedProperty(key/with/a/slash)"));
        }
        catch (Exception e) {
            DynaPropertyUtilsTestCase.fail((String)("Thew exception: " + e));
        }
        this.bean.set("mappedObjects", "nested/property", (Object)new TestBean());
        DynaPropertyUtilsTestCase.assertNotNull((String)"Can retrieve directly", (Object)this.bean.get("mappedObjects", "nested/property"));
        try {
            DynaPropertyUtilsTestCase.assertEquals((String)"Can retrieve nested", (Object)"This is a string", (Object)PropertyUtils.getNestedProperty((Object)this.bean, (String)"mappedObjects(nested/property).stringProperty"));
        }
        catch (Exception e) {
            DynaPropertyUtilsTestCase.fail((String)("Thew exception: " + e));
        }
    }

    public void testGetMappedValues() {
        Object value = null;
        try {
            value = PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty", (String)"First Key");
            DynaPropertyUtilsTestCase.assertEquals((String)"Can find first value", (Object)"First Value", (Object)value);
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Finding first value threw " + t));
        }
        try {
            value = PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty", (String)"Second Key");
            DynaPropertyUtilsTestCase.assertEquals((String)"Can find second value", (Object)"Second Value", (Object)value);
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Finding second value threw " + t));
        }
        try {
            value = PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty", (String)"Third Key");
            DynaPropertyUtilsTestCase.assertNull((String)"Can not find third value", (Object)value);
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Finding third value threw " + t));
        }
        try {
            value = PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty(First Key)");
            DynaPropertyUtilsTestCase.assertEquals((String)"Can find first value", (Object)"First Value", (Object)value);
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Finding first value threw " + t));
        }
        try {
            value = PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty(Second Key)");
            DynaPropertyUtilsTestCase.assertEquals((String)"Can find second value", (Object)"Second Value", (Object)value);
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Finding second value threw " + t));
        }
        try {
            value = PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty(Third Key)");
            DynaPropertyUtilsTestCase.assertNull((String)"Can not find third value", (Object)value);
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Finding third value threw " + t));
        }
        try {
            value = PropertyUtils.getNestedProperty((Object)this.bean, (String)"mapProperty.First Key");
            DynaPropertyUtilsTestCase.assertEquals((String)"Can find first value", (Object)"First Value", (Object)value);
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Finding first value threw " + t));
        }
        try {
            value = PropertyUtils.getNestedProperty((Object)this.bean, (String)"mapProperty.Second Key");
            DynaPropertyUtilsTestCase.assertEquals((String)"Can find second value", (Object)"Second Value", (Object)value);
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Finding second value threw " + t));
        }
        try {
            value = PropertyUtils.getNestedProperty((Object)this.bean, (String)"mapProperty.Third Key");
            DynaPropertyUtilsTestCase.assertNull((String)"Can not find third value", (Object)value);
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Finding third value threw " + t));
        }
    }

    public void testGetNestedArguments() {
        try {
            PropertyUtils.getNestedProperty(null, (String)"stringProperty");
            DynaPropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 1");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 1"));
        }
        try {
            PropertyUtils.getNestedProperty((Object)this.bean, null);
            DynaPropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 2");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 2"));
        }
    }

    public void testGetNestedBoolean() {
        try {
            Object value = PropertyUtils.getNestedProperty((Object)this.bean, (String)"nested.booleanProperty");
            DynaPropertyUtilsTestCase.assertNotNull((String)"Got a value", (Object)value);
            DynaPropertyUtilsTestCase.assertTrue((String)"Got correct type", (boolean)(value instanceof Boolean));
            TestBean nested = (TestBean)this.bean.get("nested");
            DynaPropertyUtilsTestCase.assertTrue((String)"Got correct value", (((Boolean)value).booleanValue() == nested.getBooleanProperty() ? 1 : 0) != 0);
        }
        catch (IllegalAccessException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            DynaPropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            DynaPropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testGetNestedDouble() {
        try {
            Object value = PropertyUtils.getNestedProperty((Object)this.bean, (String)"nested.doubleProperty");
            DynaPropertyUtilsTestCase.assertNotNull((String)"Got a value", (Object)value);
            DynaPropertyUtilsTestCase.assertTrue((String)"Got correct type", (boolean)(value instanceof Double));
            TestBean nested = (TestBean)this.bean.get("nested");
            DynaPropertyUtilsTestCase.assertEquals((String)"Got correct value", (double)((Double)value), (double)nested.getDoubleProperty(), (double)0.005);
        }
        catch (IllegalAccessException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            DynaPropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            DynaPropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testGetNestedFloat() {
        try {
            Object value = PropertyUtils.getNestedProperty((Object)this.bean, (String)"nested.floatProperty");
            DynaPropertyUtilsTestCase.assertNotNull((String)"Got a value", (Object)value);
            DynaPropertyUtilsTestCase.assertTrue((String)"Got correct type", (boolean)(value instanceof Float));
            TestBean nested = (TestBean)this.bean.get("nested");
            DynaPropertyUtilsTestCase.assertEquals((String)"Got correct value", (float)((Float)value).floatValue(), (float)nested.getFloatProperty(), (float)0.005f);
        }
        catch (IllegalAccessException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            DynaPropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            DynaPropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testGetNestedInt() {
        try {
            Object value = PropertyUtils.getNestedProperty((Object)this.bean, (String)"nested.intProperty");
            DynaPropertyUtilsTestCase.assertNotNull((String)"Got a value", (Object)value);
            DynaPropertyUtilsTestCase.assertTrue((String)"Got correct type", (boolean)(value instanceof Integer));
            TestBean nested = (TestBean)this.bean.get("nested");
            DynaPropertyUtilsTestCase.assertEquals((String)"Got correct value", (int)((Integer)value), (int)nested.getIntProperty());
        }
        catch (IllegalAccessException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            DynaPropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            DynaPropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testGetNestedLong() {
        try {
            Object value = PropertyUtils.getNestedProperty((Object)this.bean, (String)"nested.longProperty");
            DynaPropertyUtilsTestCase.assertNotNull((String)"Got a value", (Object)value);
            DynaPropertyUtilsTestCase.assertTrue((String)"Got correct type", (boolean)(value instanceof Long));
            TestBean nested = (TestBean)this.bean.get("nested");
            DynaPropertyUtilsTestCase.assertEquals((String)"Got correct value", (long)((Long)value), (long)nested.getLongProperty());
        }
        catch (IllegalAccessException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            DynaPropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            DynaPropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testGetNestedReadOnly() {
        try {
            Object value = PropertyUtils.getNestedProperty((Object)this.bean, (String)"nested.readOnlyProperty");
            DynaPropertyUtilsTestCase.assertNotNull((String)"Got a value", (Object)value);
            DynaPropertyUtilsTestCase.assertTrue((String)"Got correct type", (boolean)(value instanceof String));
            TestBean nested = (TestBean)this.bean.get("nested");
            DynaPropertyUtilsTestCase.assertEquals((String)"Got correct value", (String)((String)value), (String)nested.getReadOnlyProperty());
        }
        catch (IllegalAccessException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            DynaPropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            DynaPropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testGetNestedShort() {
        try {
            Object value = PropertyUtils.getNestedProperty((Object)this.bean, (String)"nested.shortProperty");
            DynaPropertyUtilsTestCase.assertNotNull((String)"Got a value", (Object)value);
            DynaPropertyUtilsTestCase.assertTrue((String)"Got correct type", (boolean)(value instanceof Short));
            TestBean nested = (TestBean)this.bean.get("nested");
            DynaPropertyUtilsTestCase.assertEquals((String)"Got correct value", (short)((Short)value), (short)nested.getShortProperty());
        }
        catch (IllegalAccessException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            DynaPropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            DynaPropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testGetNestedString() {
        try {
            Object value = PropertyUtils.getNestedProperty((Object)this.bean, (String)"nested.stringProperty");
            DynaPropertyUtilsTestCase.assertNotNull((String)"Got a value", (Object)value);
            DynaPropertyUtilsTestCase.assertTrue((String)"Got correct type", (boolean)(value instanceof String));
            TestBean nested = (TestBean)this.bean.get("nested");
            DynaPropertyUtilsTestCase.assertEquals((String)"Got correct value", (String)((String)value), (String)nested.getStringProperty());
        }
        catch (IllegalAccessException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            DynaPropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            DynaPropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testGetNestedUnknown() {
        try {
            PropertyUtils.getNestedProperty((Object)this.bean, (String)"nested.unknown");
            DynaPropertyUtilsTestCase.fail((String)"Should have thrown NoSuchMethodException");
        }
        catch (IllegalAccessException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            DynaPropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public void testGetSimpleArguments() {
        try {
            PropertyUtils.getSimpleProperty(null, (String)"stringProperty");
            DynaPropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 1");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 1"));
        }
        try {
            PropertyUtils.getSimpleProperty((Object)this.bean, null);
            DynaPropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 2");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 2"));
        }
    }

    public void testGetSimpleBoolean() {
        try {
            Object value = PropertyUtils.getSimpleProperty((Object)this.bean, (String)"booleanProperty");
            DynaPropertyUtilsTestCase.assertNotNull((String)"Got a value", (Object)value);
            DynaPropertyUtilsTestCase.assertTrue((String)"Got correct type", (boolean)(value instanceof Boolean));
            DynaPropertyUtilsTestCase.assertTrue((String)"Got correct value", (boolean)((Boolean)value));
        }
        catch (IllegalAccessException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            DynaPropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            DynaPropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testGetSimpleDouble() {
        try {
            Object value = PropertyUtils.getSimpleProperty((Object)this.bean, (String)"doubleProperty");
            DynaPropertyUtilsTestCase.assertNotNull((String)"Got a value", (Object)value);
            DynaPropertyUtilsTestCase.assertTrue((String)"Got correct type", (boolean)(value instanceof Double));
            DynaPropertyUtilsTestCase.assertEquals((String)"Got correct value", (double)((Double)value), (double)321.0, (double)0.005);
        }
        catch (IllegalAccessException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            DynaPropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            DynaPropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testGetSimpleFloat() {
        try {
            Object value = PropertyUtils.getSimpleProperty((Object)this.bean, (String)"floatProperty");
            DynaPropertyUtilsTestCase.assertNotNull((String)"Got a value", (Object)value);
            DynaPropertyUtilsTestCase.assertTrue((String)"Got correct type", (boolean)(value instanceof Float));
            DynaPropertyUtilsTestCase.assertEquals((String)"Got correct value", (float)((Float)value).floatValue(), (float)123.0f, (float)0.005f);
        }
        catch (IllegalAccessException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            DynaPropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            DynaPropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testGetSimpleIndexed() {
        try {
            PropertyUtils.getSimpleProperty((Object)this.bean, (String)"intIndexed[0]");
            DynaPropertyUtilsTestCase.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalAccessException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
        }
        catch (InvocationTargetException e) {
            DynaPropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            DynaPropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testGetSimpleInt() {
        try {
            Object value = PropertyUtils.getSimpleProperty((Object)this.bean, (String)"intProperty");
            DynaPropertyUtilsTestCase.assertNotNull((String)"Got a value", (Object)value);
            DynaPropertyUtilsTestCase.assertTrue((String)"Got correct type", (boolean)(value instanceof Integer));
            DynaPropertyUtilsTestCase.assertEquals((String)"Got correct value", (int)((Integer)value), (int)123);
        }
        catch (IllegalAccessException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            DynaPropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            DynaPropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testGetSimpleLong() {
        try {
            Object value = PropertyUtils.getSimpleProperty((Object)this.bean, (String)"longProperty");
            DynaPropertyUtilsTestCase.assertNotNull((String)"Got a value", (Object)value);
            DynaPropertyUtilsTestCase.assertTrue((String)"Got correct type", (boolean)(value instanceof Long));
            DynaPropertyUtilsTestCase.assertEquals((String)"Got correct value", (long)((Long)value), (long)321L);
        }
        catch (IllegalAccessException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            DynaPropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            DynaPropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testGetSimpleNested() {
        try {
            PropertyUtils.getSimpleProperty((Object)this.bean, (String)"nested.stringProperty");
            DynaPropertyUtilsTestCase.fail((String)"Should have thrown IllegaArgumentException");
        }
        catch (IllegalAccessException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
        }
        catch (InvocationTargetException e) {
            DynaPropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            DynaPropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testGetSimpleShort() {
        try {
            Object value = PropertyUtils.getSimpleProperty((Object)this.bean, (String)"shortProperty");
            DynaPropertyUtilsTestCase.assertNotNull((String)"Got a value", (Object)value);
            DynaPropertyUtilsTestCase.assertTrue((String)"Got correct type", (boolean)(value instanceof Short));
            DynaPropertyUtilsTestCase.assertEquals((String)"Got correct value", (short)((Short)value), (short)987);
        }
        catch (IllegalAccessException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            DynaPropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            DynaPropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testGetSimpleString() {
        try {
            Object value = PropertyUtils.getSimpleProperty((Object)this.bean, (String)"stringProperty");
            DynaPropertyUtilsTestCase.assertNotNull((String)"Got a value", (Object)value);
            DynaPropertyUtilsTestCase.assertTrue((String)"Got correct type", (boolean)(value instanceof String));
            DynaPropertyUtilsTestCase.assertEquals((String)"Got correct value", (String)((String)value), (String)"This is a string");
        }
        catch (IllegalAccessException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            DynaPropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            DynaPropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testGetSimpleUnknown() {
        try {
            PropertyUtils.getSimpleProperty((Object)this.bean, (String)"unknown");
            DynaPropertyUtilsTestCase.fail((String)"Should have thrown NoSuchMethodException");
        }
        catch (IllegalAccessException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            DynaPropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            DynaPropertyUtilsTestCase.assertEquals((String)("Unknown property 'unknown' on dynaclass '" + this.bean.getDynaClass() + "'"), (String)e.getMessage());
        }
    }

    public void testSetIndexedArguments() {
        try {
            PropertyUtils.setIndexedProperty(null, (String)"intArray", (int)0, (Object)1);
            DynaPropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 1");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 1"));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, null, (int)0, (Object)1);
            DynaPropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 2");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 2"));
        }
        try {
            PropertyUtils.setIndexedProperty(null, (String)"intArray[0]", (Object)1);
            DynaPropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 3");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 3"));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, (String)"[0]", (Object)1);
            DynaPropertyUtilsTestCase.fail((String)"Should throw NoSuchMethodException 4");
        }
        catch (NoSuchMethodException t) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of NoSuchMethodException 4"));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, (String)"intArray", (Object)1);
            DynaPropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 5");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 5"));
        }
        try {
            PropertyUtils.setIndexedProperty(null, (String)"intIndexed", (int)0, (Object)1);
            DynaPropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 1");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 1"));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, null, (int)0, (Object)1);
            DynaPropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 2");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 2"));
        }
        try {
            PropertyUtils.setIndexedProperty(null, (String)"intIndexed[0]", (Object)1);
            DynaPropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 3");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 3"));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, (String)"[0]", (Object)1);
            DynaPropertyUtilsTestCase.fail((String)"Should throw NoSuchMethodException 4");
        }
        catch (NoSuchMethodException t) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of NoSuchMethodException 4"));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, (String)"intIndexed", (Object)1);
            DynaPropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 5");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 5"));
        }
    }

    public void testSetIndexedValues() {
        Object value = null;
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, (String)"intArray", (int)0, (Object)1);
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"intArray", (int)0);
            DynaPropertyUtilsTestCase.assertNotNull((String)"Returned new value 0", (Object)value);
            DynaPropertyUtilsTestCase.assertTrue((String)"Returned Integer new value 0", (boolean)(value instanceof Integer));
            DynaPropertyUtilsTestCase.assertEquals((String)"Returned correct new value 0", (int)1, (int)((Integer)value));
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, (String)"intIndexed", (int)1, (Object)11);
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"intIndexed", (int)1);
            DynaPropertyUtilsTestCase.assertNotNull((String)"Returned new value 1", (Object)value);
            DynaPropertyUtilsTestCase.assertTrue((String)"Returned Integer new value 1", (boolean)(value instanceof Integer));
            DynaPropertyUtilsTestCase.assertEquals((String)"Returned correct new value 1", (int)11, (int)((Integer)value));
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, (String)"listIndexed", (int)2, (Object)"New Value 2");
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"listIndexed", (int)2);
            DynaPropertyUtilsTestCase.assertNotNull((String)"Returned new value 2", (Object)value);
            DynaPropertyUtilsTestCase.assertTrue((String)"Returned String new value 2", (boolean)(value instanceof String));
            DynaPropertyUtilsTestCase.assertEquals((String)"Returned correct new value 2", (String)"New Value 2", (String)((String)value));
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, (String)"stringArray", (int)2, (Object)"New Value 2");
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"stringArray", (int)2);
            DynaPropertyUtilsTestCase.assertNotNull((String)"Returned new value 2", (Object)value);
            DynaPropertyUtilsTestCase.assertTrue((String)"Returned String new value 2", (boolean)(value instanceof String));
            DynaPropertyUtilsTestCase.assertEquals((String)"Returned correct new value 2", (String)"New Value 2", (String)((String)value));
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, (String)"stringArray", (int)3, (Object)"New Value 3");
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"stringArray", (int)3);
            DynaPropertyUtilsTestCase.assertNotNull((String)"Returned new value 3", (Object)value);
            DynaPropertyUtilsTestCase.assertTrue((String)"Returned String new value 3", (boolean)(value instanceof String));
            DynaPropertyUtilsTestCase.assertEquals((String)"Returned correct new value 3", (String)"New Value 3", (String)((String)value));
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, (String)"intArray[4]", (Object)1);
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"intArray[4]");
            DynaPropertyUtilsTestCase.assertNotNull((String)"Returned new value 4", (Object)value);
            DynaPropertyUtilsTestCase.assertTrue((String)"Returned Integer new value 4", (boolean)(value instanceof Integer));
            DynaPropertyUtilsTestCase.assertEquals((String)"Returned correct new value 4", (int)1, (int)((Integer)value));
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, (String)"intIndexed[3]", (Object)11);
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"intIndexed[3]");
            DynaPropertyUtilsTestCase.assertNotNull((String)"Returned new value 5", (Object)value);
            DynaPropertyUtilsTestCase.assertTrue((String)"Returned Integer new value 5", (boolean)(value instanceof Integer));
            DynaPropertyUtilsTestCase.assertEquals((String)"Returned correct new value 5", (int)11, (int)((Integer)value));
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, (String)"listIndexed[1]", (Object)"New Value 2");
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"listIndexed[1]");
            DynaPropertyUtilsTestCase.assertNotNull((String)"Returned new value 6", (Object)value);
            DynaPropertyUtilsTestCase.assertTrue((String)"Returned String new value 6", (boolean)(value instanceof String));
            DynaPropertyUtilsTestCase.assertEquals((String)"Returned correct new value 6", (String)"New Value 2", (String)((String)value));
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, (String)"stringArray[1]", (Object)"New Value 2");
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"stringArray[2]");
            DynaPropertyUtilsTestCase.assertNotNull((String)"Returned new value 6", (Object)value);
            DynaPropertyUtilsTestCase.assertTrue((String)"Returned String new value 6", (boolean)(value instanceof String));
            DynaPropertyUtilsTestCase.assertEquals((String)"Returned correct new value 6", (String)"New Value 2", (String)((String)value));
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, (String)"stringArray[0]", (Object)"New Value 3");
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"stringArray[0]");
            DynaPropertyUtilsTestCase.assertNotNull((String)"Returned new value 7", (Object)value);
            DynaPropertyUtilsTestCase.assertTrue((String)"Returned String new value 7", (boolean)(value instanceof String));
            DynaPropertyUtilsTestCase.assertEquals((String)"Returned correct new value 7", (String)"New Value 3", (String)((String)value));
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, (String)"intArray", (int)-1, (Object)0);
            DynaPropertyUtilsTestCase.fail((String)"Should have thrown ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException t) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of ArrayIndexOutOfBoundsException"));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, (String)"intArray", (int)5, (Object)0);
            DynaPropertyUtilsTestCase.fail((String)"Should have thrown ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException t) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of ArrayIndexOutOfBoundsException"));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, (String)"intIndexed", (int)-1, (Object)0);
            DynaPropertyUtilsTestCase.fail((String)"Should have thrown ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException t) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of ArrayIndexOutOfBoundsException"));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, (String)"intIndexed", (int)5, (Object)0);
            DynaPropertyUtilsTestCase.fail((String)"Should have thrown ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException t) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of ArrayIndexOutOfBoundsException"));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, (String)"listIndexed", (int)5, (Object)"New String");
            DynaPropertyUtilsTestCase.fail((String)"Should have thrown IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException t) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IndexOutOfBoundsException"));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, (String)"listIndexed", (int)-1, (Object)"New String");
            DynaPropertyUtilsTestCase.fail((String)"Should have thrown IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException t) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IndexOutOfBoundsException"));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, (String)"stringArray", (int)-1, (Object)"New String");
            DynaPropertyUtilsTestCase.fail((String)"Should have thrown ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException t) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of ArrayIndexOutOfBoundsException"));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, (String)"stringArray", (int)5, (Object)"New String");
            DynaPropertyUtilsTestCase.fail((String)"Should have thrown ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException t) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of ArrayIndexOutOfBoundsException"));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, (String)"stringIndexed", (int)-1, (Object)"New String");
            DynaPropertyUtilsTestCase.fail((String)"Should have thrown ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException t) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of ArrayIndexOutOfBoundsException"));
        }
        try {
            PropertyUtils.setIndexedProperty((Object)this.bean, (String)"stringIndexed", (int)5, (Object)"New String");
            DynaPropertyUtilsTestCase.fail((String)"Should have thrown ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException t) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of ArrayIndexOutOfBoundsException"));
        }
    }

    public void testSetMappedArguments() {
        try {
            PropertyUtils.setMappedProperty(null, (String)"mappedProperty", (String)"First Key", (Object)"First Value");
            DynaPropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 1");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 1"));
        }
        try {
            PropertyUtils.setMappedProperty((Object)this.bean, null, (String)"First Key", (Object)"First Value");
            DynaPropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 2");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 2"));
        }
        try {
            PropertyUtils.setMappedProperty((Object)this.bean, (String)"mappedProperty", null, (Object)"First Value");
            DynaPropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 3");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 3"));
        }
        try {
            PropertyUtils.setMappedProperty(null, (String)"mappedProperty(First Key)", (Object)"First Value");
            DynaPropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 4");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 4"));
        }
        try {
            PropertyUtils.setMappedProperty((Object)this.bean, (String)"(Second Key)", (Object)"Second Value");
            DynaPropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 5");
        }
        catch (NoSuchMethodException t) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of NoSuchMethodException 5"));
        }
        try {
            PropertyUtils.setMappedProperty((Object)this.bean, (String)"mappedProperty", (Object)"Third Value");
            DynaPropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 6");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 6"));
        }
    }

    public void testSetMappedValues() {
        Object value = null;
        try {
            value = PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty", (String)"Fourth Key");
            DynaPropertyUtilsTestCase.assertNull((String)"Can not find fourth value", (Object)value);
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Finding fourth value threw " + t));
        }
        try {
            PropertyUtils.setMappedProperty((Object)this.bean, (String)"mappedProperty", (String)"Fourth Key", (Object)"Fourth Value");
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Setting fourth value threw " + t));
        }
        try {
            value = PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty", (String)"Fourth Key");
            DynaPropertyUtilsTestCase.assertEquals((String)"Can find fourth value", (Object)"Fourth Value", (Object)value);
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Finding fourth value threw " + t));
        }
        try {
            value = PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty(Fifth Key)");
            DynaPropertyUtilsTestCase.assertNull((String)"Can not find fifth value", (Object)value);
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Finding fifth value threw " + t));
        }
        try {
            PropertyUtils.setMappedProperty((Object)this.bean, (String)"mappedProperty(Fifth Key)", (Object)"Fifth Value");
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Setting fifth value threw " + t));
        }
        try {
            value = PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty(Fifth Key)");
            DynaPropertyUtilsTestCase.assertEquals((String)"Can find fifth value", (Object)"Fifth Value", (Object)value);
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Finding fifth value threw " + t));
        }
        try {
            value = PropertyUtils.getNestedProperty((Object)this.bean, (String)"mapProperty.Sixth Key");
            DynaPropertyUtilsTestCase.assertNull((String)"Can not find sixth value", (Object)value);
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Finding fifth value threw " + t));
        }
        try {
            PropertyUtils.setNestedProperty((Object)this.bean, (String)"mapProperty.Sixth Key", (Object)"Sixth Value");
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Setting sixth value threw " + t));
        }
        try {
            value = PropertyUtils.getNestedProperty((Object)this.bean, (String)"mapProperty.Sixth Key");
            DynaPropertyUtilsTestCase.assertEquals((String)"Can find sixth value", (Object)"Sixth Value", (Object)value);
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Finding sixth value threw " + t));
        }
    }

    public void testSetNestedArguments() {
        try {
            PropertyUtils.setNestedProperty(null, (String)"stringProperty", (Object)"");
            DynaPropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 1");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 1"));
        }
        try {
            PropertyUtils.setNestedProperty((Object)this.bean, null, (Object)"");
            DynaPropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 2");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 2"));
        }
    }

    public void testSetNestedBoolean() {
        try {
            boolean oldValue = this.nested.getBooleanProperty();
            boolean newValue = !oldValue;
            PropertyUtils.setNestedProperty((Object)this.bean, (String)"nested.booleanProperty", (Object)newValue);
            DynaPropertyUtilsTestCase.assertTrue((String)"Matched new value", (newValue == this.nested.getBooleanProperty() ? 1 : 0) != 0);
        }
        catch (IllegalAccessException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            DynaPropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            DynaPropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testSetNestedDouble() {
        try {
            double oldValue = this.nested.getDoubleProperty();
            double newValue = oldValue + 1.0;
            PropertyUtils.setNestedProperty((Object)this.bean, (String)"nested.doubleProperty", (Object)newValue);
            DynaPropertyUtilsTestCase.assertEquals((String)"Matched new value", (double)newValue, (double)this.nested.getDoubleProperty(), (double)0.005);
        }
        catch (IllegalAccessException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            DynaPropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            DynaPropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testSetNestedFloat() {
        try {
            float oldValue = this.nested.getFloatProperty();
            float newValue = oldValue + 1.0f;
            PropertyUtils.setNestedProperty((Object)this.bean, (String)"nested.floatProperty", (Object)Float.valueOf(newValue));
            DynaPropertyUtilsTestCase.assertEquals((String)"Matched new value", (float)newValue, (float)this.nested.getFloatProperty(), (float)0.005f);
        }
        catch (IllegalAccessException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            DynaPropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            DynaPropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testSetNestedInt() {
        try {
            int oldValue = this.nested.getIntProperty();
            int newValue = oldValue + 1;
            PropertyUtils.setNestedProperty((Object)this.bean, (String)"nested.intProperty", (Object)newValue);
            DynaPropertyUtilsTestCase.assertEquals((String)"Matched new value", (int)newValue, (int)this.nested.getIntProperty());
        }
        catch (IllegalAccessException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            DynaPropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            DynaPropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testSetNestedLong() {
        try {
            long oldValue = this.nested.getLongProperty();
            long newValue = oldValue + 1L;
            PropertyUtils.setNestedProperty((Object)this.bean, (String)"nested.longProperty", (Object)newValue);
            DynaPropertyUtilsTestCase.assertEquals((String)"Matched new value", (long)newValue, (long)this.nested.getLongProperty());
        }
        catch (IllegalAccessException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            DynaPropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            DynaPropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testSetNestedReadOnly() {
        try {
            String oldValue = this.nested.getWriteOnlyPropertyValue();
            String newValue = oldValue + " Extra Value";
            PropertyUtils.setNestedProperty((Object)this.bean, (String)"nested.readOnlyProperty", (Object)newValue);
            DynaPropertyUtilsTestCase.fail((String)"Should have thrown NoSuchMethodException");
        }
        catch (IllegalAccessException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            DynaPropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public void testSetNestedShort() {
        try {
            short oldValue;
            short newValue = oldValue = this.nested.getShortProperty();
            newValue = (short)(newValue + 1);
            PropertyUtils.setNestedProperty((Object)this.bean, (String)"nested.shortProperty", (Object)newValue);
            DynaPropertyUtilsTestCase.assertEquals((String)"Matched new value", (short)newValue, (short)this.nested.getShortProperty());
        }
        catch (IllegalAccessException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            DynaPropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            DynaPropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testSetNestedString() {
        try {
            String oldValue = this.nested.getStringProperty();
            String newValue = oldValue + " Extra Value";
            PropertyUtils.setNestedProperty((Object)this.bean, (String)"nested.stringProperty", (Object)newValue);
            DynaPropertyUtilsTestCase.assertEquals((String)"Matched new value", (String)newValue, (String)this.nested.getStringProperty());
        }
        catch (IllegalAccessException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            DynaPropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            DynaPropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testSetNestedUnknown() {
        try {
            String newValue = "New String Value";
            PropertyUtils.setNestedProperty((Object)this.bean, (String)"nested.unknown", (Object)"New String Value");
            DynaPropertyUtilsTestCase.fail((String)"Should have thrown NoSuchMethodException");
        }
        catch (IllegalAccessException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            DynaPropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public void testSetNestedWriteOnly() {
        try {
            String oldValue = this.nested.getWriteOnlyPropertyValue();
            String newValue = oldValue + " Extra Value";
            PropertyUtils.setNestedProperty((Object)this.bean, (String)"nested.writeOnlyProperty", (Object)newValue);
            DynaPropertyUtilsTestCase.assertEquals((String)"Matched new value", (String)newValue, (String)this.nested.getWriteOnlyPropertyValue());
        }
        catch (IllegalAccessException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            DynaPropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            DynaPropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testSetSimpleArguments() {
        try {
            PropertyUtils.setSimpleProperty(null, (String)"stringProperty", (Object)"");
            DynaPropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 1");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 1"));
        }
        try {
            PropertyUtils.setSimpleProperty((Object)this.bean, null, (Object)"");
            DynaPropertyUtilsTestCase.fail((String)"Should throw IllegalArgumentException 2");
        }
        catch (IllegalArgumentException t) {
        }
        catch (Throwable t) {
            DynaPropertyUtilsTestCase.fail((String)("Threw " + t + " instead of IllegalArgumentException 2"));
        }
    }

    public void testSetSimpleBoolean() {
        try {
            boolean oldValue = (Boolean)this.bean.get("booleanProperty");
            boolean newValue = !oldValue;
            PropertyUtils.setSimpleProperty((Object)this.bean, (String)"booleanProperty", (Object)newValue);
            DynaPropertyUtilsTestCase.assertTrue((String)"Matched new value", (newValue == (Boolean)this.bean.get("booleanProperty") ? 1 : 0) != 0);
        }
        catch (IllegalAccessException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            DynaPropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            DynaPropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testSetSimpleDouble() {
        try {
            double oldValue = (Double)this.bean.get("doubleProperty");
            double newValue = oldValue + 1.0;
            PropertyUtils.setSimpleProperty((Object)this.bean, (String)"doubleProperty", (Object)newValue);
            DynaPropertyUtilsTestCase.assertEquals((String)"Matched new value", (double)newValue, (double)((Double)this.bean.get("doubleProperty")), (double)0.005);
        }
        catch (IllegalAccessException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            DynaPropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            DynaPropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testSetSimpleFloat() {
        try {
            float oldValue = ((Float)this.bean.get("floatProperty")).floatValue();
            float newValue = oldValue + 1.0f;
            PropertyUtils.setSimpleProperty((Object)this.bean, (String)"floatProperty", (Object)Float.valueOf(newValue));
            DynaPropertyUtilsTestCase.assertEquals((String)"Matched new value", (float)newValue, (float)((Float)this.bean.get("floatProperty")).floatValue(), (float)0.005f);
        }
        catch (IllegalAccessException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            DynaPropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            DynaPropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testSetSimpleIndexed() {
        try {
            PropertyUtils.setSimpleProperty((Object)this.bean, (String)"stringIndexed[0]", (Object)"New String Value");
            DynaPropertyUtilsTestCase.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalAccessException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
        }
        catch (InvocationTargetException e) {
            DynaPropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            DynaPropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testSetSimpleInt() {
        try {
            int oldValue = (Integer)this.bean.get("intProperty");
            int newValue = oldValue + 1;
            PropertyUtils.setSimpleProperty((Object)this.bean, (String)"intProperty", (Object)newValue);
            DynaPropertyUtilsTestCase.assertEquals((String)"Matched new value", (int)newValue, (int)((Integer)this.bean.get("intProperty")));
        }
        catch (IllegalAccessException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            DynaPropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            DynaPropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testSetSimpleLong() {
        try {
            long oldValue = (Long)this.bean.get("longProperty");
            long newValue = oldValue + 1L;
            PropertyUtils.setSimpleProperty((Object)this.bean, (String)"longProperty", (Object)newValue);
            DynaPropertyUtilsTestCase.assertEquals((String)"Matched new value", (long)newValue, (long)((Long)this.bean.get("longProperty")));
        }
        catch (IllegalAccessException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            DynaPropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            DynaPropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testSetSimpleNested() {
        try {
            PropertyUtils.setSimpleProperty((Object)this.bean, (String)"nested.stringProperty", (Object)"New String Value");
            DynaPropertyUtilsTestCase.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalAccessException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
        }
        catch (InvocationTargetException e) {
            DynaPropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            DynaPropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testSetSimpleShort() {
        try {
            short oldValue;
            short newValue = oldValue = ((Short)this.bean.get("shortProperty")).shortValue();
            newValue = (short)(newValue + 1);
            PropertyUtils.setSimpleProperty((Object)this.bean, (String)"shortProperty", (Object)newValue);
            DynaPropertyUtilsTestCase.assertEquals((String)"Matched new value", (short)newValue, (short)((Short)this.bean.get("shortProperty")));
        }
        catch (IllegalAccessException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            DynaPropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            DynaPropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testSetSimpleString() {
        try {
            String oldValue = (String)this.bean.get("stringProperty");
            String newValue = oldValue + " Extra Value";
            PropertyUtils.setSimpleProperty((Object)this.bean, (String)"stringProperty", (Object)newValue);
            DynaPropertyUtilsTestCase.assertEquals((String)"Matched new value", (String)newValue, (String)((String)this.bean.get("stringProperty")));
        }
        catch (IllegalAccessException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            DynaPropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            DynaPropertyUtilsTestCase.fail((String)"NoSuchMethodException");
        }
    }

    public void testSetSimpleUnknown() {
        try {
            String newValue = "New String Value";
            PropertyUtils.setSimpleProperty((Object)this.bean, (String)"unknown", (Object)"New String Value");
            DynaPropertyUtilsTestCase.fail((String)"Should have thrown NoSuchMethodException");
        }
        catch (IllegalAccessException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalAccessException");
        }
        catch (IllegalArgumentException e) {
            DynaPropertyUtilsTestCase.fail((String)"IllegalArgumentException");
        }
        catch (InvocationTargetException e) {
            DynaPropertyUtilsTestCase.fail((String)"InvocationTargetException");
        }
        catch (NoSuchMethodException e) {
            DynaPropertyUtilsTestCase.assertEquals((String)("Unknown property 'unknown' on dynaclass '" + this.bean.getDynaClass() + "'"), (String)e.getMessage());
        }
    }
}

