/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.tree;

import java.util.List;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.DefaultConfigurationNode;
import org.apache.commons.configuration.tree.NodeAddData;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestNodeAddData {
    private static final ConfigurationNode TEST_PARENT = new DefaultConfigurationNode("parent");
    private static final String TEST_NODENAME = "testNewNode";
    private static final String PATH_NODE_NAME = "PATHNODE";
    private static final int PATH_NODE_COUNT = 10;
    NodeAddData addData;

    @Before
    public void setUp() throws Exception {
        this.addData = new NodeAddData(TEST_PARENT, TEST_NODENAME);
    }

    @Test
    public void testUninitialized() {
        this.addData = new NodeAddData();
        Assert.assertNull((String)"A parent is set", (Object)this.addData.getParent());
        Assert.assertNull((String)"Node has a name", (Object)this.addData.getNewNodeName());
        Assert.assertFalse((String)"Attribute flag is set", (boolean)this.addData.isAttribute());
        Assert.assertTrue((String)"Path nodes are not empty", (boolean)this.addData.getPathNodes().isEmpty());
    }

    @Test
    public void testInitialized() {
        Assert.assertSame((String)"Wrong parent", (Object)TEST_PARENT, (Object)this.addData.getParent());
        Assert.assertEquals((String)"Wrong node name", (Object)TEST_NODENAME, (Object)this.addData.getNewNodeName());
        Assert.assertFalse((String)"Attribute flag is set", (boolean)this.addData.isAttribute());
        Assert.assertTrue((String)"Path nodes are not empty", (boolean)this.addData.getPathNodes().isEmpty());
    }

    @Test
    public void testAddPathNode() {
        for (int i = 0; i < 10; ++i) {
            this.addData.addPathNode(PATH_NODE_NAME + i);
        }
        List nodes = this.addData.getPathNodes();
        Assert.assertEquals((String)"Incorrect number of path nodes", (long)10L, (long)nodes.size());
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((String)("Wrong path node at position" + i), (Object)(PATH_NODE_NAME + i), nodes.get(i));
        }
    }
}

