/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.tree.xpath;

import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.tree.ExpressionEngine;
import org.apache.commons.configuration.tree.xpath.XPathExpressionEngine;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestXPathExpressionEngineInConfig {
    private static final String KEY = "test/expression/xpath";
    private static final String VALUE = "success";
    private XMLConfiguration config;

    @Before
    public void setUp() throws Exception {
        this.config = new XMLConfiguration();
        this.config.setExpressionEngine((ExpressionEngine)new XPathExpressionEngine());
    }

    @Test
    public void testSetPropertyExisting() {
        this.config.addProperty(" test/expression/xpath", (Object)"failure");
        this.config.setProperty(KEY, (Object)VALUE);
        Assert.assertEquals((String)"Value not changed", (Object)VALUE, (Object)this.config.getString(KEY));
    }

    @Test
    public void testSetPropertyPartlyExisting() {
        String testKey = "test/expression/xpath/sub";
        this.config.addProperty(" test/expression/xpath", (Object)"test");
        this.config.setProperty("test/expression/xpath/sub", (Object)VALUE);
        Assert.assertEquals((String)"Value not set", (Object)VALUE, (Object)this.config.getString("test/expression/xpath/sub"));
    }

    @Test
    public void testSetPropertyNewAttribute() {
        String keyAttr = "test/expression/xpath/@attr";
        this.config.addProperty(" test/expression/xpath", (Object)"test");
        this.config.setProperty("test/expression/xpath/@attr", (Object)VALUE);
        Assert.assertEquals((String)"Value not set", (Object)VALUE, (Object)this.config.getString("test/expression/xpath/@attr"));
    }

    @Test
    public void testSetPropertyNewKey() {
        this.config.setProperty(KEY, (Object)VALUE);
        Assert.assertEquals((String)"Value not set", (Object)VALUE, (Object)this.config.getString(KEY));
    }

    @Test
    public void testAddPropertyComplexStructures() {
        this.config.addProperty("tables/table/name", (Object)"tasks");
        this.config.addProperty("tables/table[last()]/@type", (Object)"system");
        this.config.addProperty("tables/table[last()]/fields/field/name", (Object)"taskid");
        this.config.addProperty("tables/table[last()]/fields/field[last()]/@type", (Object)"int");
        this.config.addProperty("tables table/name", (Object)"documents");
        Assert.assertEquals((String)"Wrong table 1", (Object)"tasks", (Object)this.config.getString("tables/table[1]/name"));
        Assert.assertEquals((String)"Wrong table 2", (Object)"documents", (Object)this.config.getString("tables/table[2]/name"));
        Assert.assertEquals((String)"Wrong field type", (Object)"int", (Object)this.config.getString("tables/table[1]/fields/field[1]/@type"));
    }
}

