/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils;

import java.beans.PropertyDescriptor;
import java.sql.ResultSetMetaData;
import org.apache.commons.dbutils.GenerousBeanProcessor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class GenerousBeanProcessorTest {
    GenerousBeanProcessor processor = new GenerousBeanProcessor();
    @Mock
    ResultSetMetaData metaData;
    PropertyDescriptor[] propDescriptors;

    @Before
    public void setUp() throws Exception {
        this.propDescriptors = new PropertyDescriptor[3];
        this.propDescriptors[0] = new PropertyDescriptor("one", TestBean.class);
        this.propDescriptors[1] = new PropertyDescriptor("two", TestBean.class);
        this.propDescriptors[2] = new PropertyDescriptor("three", TestBean.class);
    }

    @Test
    public void testMapColumnsToPropertiesColumnLabelIsNull() throws Exception {
        Mockito.when((Object)this.metaData.getColumnCount()).thenReturn((Object)1);
        Mockito.when((Object)this.metaData.getColumnName(1)).thenReturn((Object)"juhu");
        Mockito.when((Object)this.metaData.getColumnLabel(1)).thenReturn(null);
        int[] ret = this.processor.mapColumnsToProperties(this.metaData, this.propDescriptors);
        Assert.assertNotNull((Object)ret);
        Assert.assertEquals((long)2L, (long)ret.length);
        Assert.assertEquals((long)-1L, (long)ret[0]);
        Assert.assertEquals((long)-1L, (long)ret[1]);
    }

    @Test
    public void testMapColumnsToPropertiesMixedCase() throws Exception {
        Mockito.when((Object)this.metaData.getColumnCount()).thenReturn((Object)3);
        Mockito.when((Object)this.metaData.getColumnLabel(1)).thenReturn((Object)"tHree");
        Mockito.when((Object)this.metaData.getColumnLabel(2)).thenReturn((Object)"One");
        Mockito.when((Object)this.metaData.getColumnLabel(3)).thenReturn((Object)"tWO");
        int[] ret = this.processor.mapColumnsToProperties(this.metaData, this.propDescriptors);
        Assert.assertNotNull((Object)ret);
        Assert.assertEquals((long)4L, (long)ret.length);
        Assert.assertEquals((long)-1L, (long)ret[0]);
        Assert.assertEquals((long)2L, (long)ret[1]);
        Assert.assertEquals((long)0L, (long)ret[2]);
        Assert.assertEquals((long)1L, (long)ret[3]);
    }

    @Test
    public void testMapColumnsToPropertiesWithOutUnderscores() throws Exception {
        Mockito.when((Object)this.metaData.getColumnCount()).thenReturn((Object)3);
        Mockito.when((Object)this.metaData.getColumnLabel(1)).thenReturn((Object)"three");
        Mockito.when((Object)this.metaData.getColumnLabel(2)).thenReturn((Object)"one");
        Mockito.when((Object)this.metaData.getColumnLabel(3)).thenReturn((Object)"two");
        int[] ret = this.processor.mapColumnsToProperties(this.metaData, this.propDescriptors);
        Assert.assertNotNull((Object)ret);
        Assert.assertEquals((long)4L, (long)ret.length);
        Assert.assertEquals((long)-1L, (long)ret[0]);
        Assert.assertEquals((long)2L, (long)ret[1]);
        Assert.assertEquals((long)0L, (long)ret[2]);
        Assert.assertEquals((long)1L, (long)ret[3]);
    }

    @Test
    public void testMapColumnsToPropertiesWithSpaces() throws Exception {
        Mockito.when((Object)this.metaData.getColumnCount()).thenReturn((Object)3);
        Mockito.when((Object)this.metaData.getColumnLabel(1)).thenReturn((Object)"th ree");
        Mockito.when((Object)this.metaData.getColumnLabel(2)).thenReturn((Object)"o n e");
        Mockito.when((Object)this.metaData.getColumnLabel(3)).thenReturn((Object)"t wo");
        int[] ret = this.processor.mapColumnsToProperties(this.metaData, this.propDescriptors);
        Assert.assertNotNull((Object)ret);
        Assert.assertEquals((long)4L, (long)ret.length);
        Assert.assertEquals((long)-1L, (long)ret[0]);
        Assert.assertEquals((long)2L, (long)ret[1]);
        Assert.assertEquals((long)0L, (long)ret[2]);
        Assert.assertEquals((long)1L, (long)ret[3]);
    }

    @Test
    public void testMapColumnsToPropertiesWithUnderscores() throws Exception {
        Mockito.when((Object)this.metaData.getColumnCount()).thenReturn((Object)3);
        Mockito.when((Object)this.metaData.getColumnLabel(1)).thenReturn((Object)"t_h_r_e_e");
        Mockito.when((Object)this.metaData.getColumnLabel(2)).thenReturn((Object)"o_n_e");
        Mockito.when((Object)this.metaData.getColumnLabel(3)).thenReturn((Object)"t_w_o");
        int[] ret = this.processor.mapColumnsToProperties(this.metaData, this.propDescriptors);
        Assert.assertNotNull((Object)ret);
        Assert.assertEquals((long)4L, (long)ret.length);
        Assert.assertEquals((long)-1L, (long)ret[0]);
        Assert.assertEquals((long)2L, (long)ret[1]);
        Assert.assertEquals((long)0L, (long)ret[2]);
        Assert.assertEquals((long)1L, (long)ret[3]);
    }

    static class TestBean {
        private String one;
        private int two;
        private long three;

        TestBean() {
        }

        public String getOne() {
            return this.one;
        }

        public long getThree() {
            return this.three;
        }

        public int getTwo() {
            return this.two;
        }

        public void setOne(String one) {
            this.one = one;
        }

        public void setThree(long three) {
            this.three = three;
        }

        public void setTwo(int two) {
            this.two = two;
        }
    }
}

