/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.webp;

import java.awt.Dimension;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.formats.webp.AbstractWebPTest;
import org.apache.commons.imaging.formats.webp.WebPImageMetadata;
import org.apache.commons.imaging.formats.webp.WebPImageParser;
import org.apache.commons.imaging.formats.webp.WebPImagingParameters;
import org.apache.commons.imaging.internal.Debug;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class WebPDumpTest
extends AbstractWebPTest {
    @ParameterizedTest
    @MethodSource(value={"images"})
    public void testDump(File imageFile) throws Exception {
        Debug.debug((String)"imageFile", (Object)imageFile);
        Debug.debug();
        String xmpXml = Imaging.getXmpXml((File)imageFile);
        if (xmpXml != null) {
            Debug.debug((String)("xmpXml: " + xmpXml));
            Debug.debug();
        }
        WebPImageParser parser = new WebPImageParser();
        WebPImagingParameters params = new WebPImagingParameters();
        WebPImageMetadata metadata = parser.getMetadata(ByteSource.file((File)imageFile), parser.getDefaultParameters());
        if (metadata != null) {
            Debug.debug((String)("Exif: " + metadata.getExif()));
            Debug.debug();
        }
        ByteSource bs = ByteSource.file((File)imageFile);
        Dimension size = parser.getImageSize(bs, params);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        parser.dumpImageFile(pw, bs);
        Assertions.assertTrue((boolean)sw.toString().contains("Width: " + size.width));
    }
}

