/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.serialization;

import java.io.IOException;
import java.io.InvalidClassException;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.commons.io.serialization.ValidatingObjectInputStream;
import org.apache.commons.lang3.SerializationUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ProxyTest {
    ProxyTest() {
    }

    Object newProxy() {
        return Proxy.newProxyInstance(ProxyTest.class.getClassLoader(), new Class[]{IFoo.class}, (InvocationHandler)new InvocationHandlerImpl());
    }

    @Test
    void testAcceptProxy() throws IOException, ClassNotFoundException {
        Object proxy = this.newProxy();
        byte[] serialized = SerializationUtils.serialize((Serializable)((Serializable)proxy));
        Class<IFoo> ifaceClass = IFoo.class;
        try (ValidatingObjectInputStream vois = ((ValidatingObjectInputStream.Builder)ValidatingObjectInputStream.builder().setByteArray(serialized)).accept(new String[]{"*"}).get();){
            Assertions.assertTrue((boolean)((IFoo)Assertions.assertInstanceOf(ifaceClass, (Object)vois.readObject())).toString().endsWith("InvocationHandlerImpl.invoke()"));
        }
    }

    @Test
    void testRejectProxy() throws IOException, ClassNotFoundException {
        Object proxy = this.newProxy();
        byte[] serialized = SerializationUtils.serialize((Serializable)((Serializable)proxy));
        Class<IFoo> ifaceClass = IFoo.class;
        try (ValidatingObjectInputStream vois = ((ValidatingObjectInputStream.Builder)ValidatingObjectInputStream.builder().setByteArray(serialized)).accept(new String[]{"*"}).reject(new Class[]{ifaceClass}).get();){
            Assertions.assertThrows(InvalidClassException.class, () -> vois.readObject());
        }
    }

    public static interface IFoo
    extends Serializable {
        public void foo();
    }

    public static class InvocationHandlerImpl
    implements InvocationHandler,
    Serializable {
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            return "InvocationHandlerImpl.invoke()";
        }
    }
}

