/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.jcache.extras.web;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.deploy.FilterMap;
import org.apache.catalina.startup.Tomcat;
import org.apache.commons.io.IOUtils;
import org.apache.commons.jcs3.jcache.extras.web.JCacheFilter;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class JCacheFilterTest {
    private static File docBase;

    @BeforeClass
    public static void createEmptyDir() {
        docBase = new File("target/missing/");
        docBase.mkdirs();
        docBase.deleteOnExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFilterNoOutput() throws Exception {
        Empty.COUNTER.set(0);
        Tomcat tomcat = new Tomcat();
        tomcat.setHostname("localhost");
        tomcat.setPort(0);
        try {
            tomcat.getEngine();
            tomcat.start();
            Context ctx = tomcat.addWebapp("/sample", docBase.getAbsolutePath());
            Tomcat.addServlet((Context)ctx, (String)"empty", (String)Empty.class.getName());
            ctx.addServletMapping("/", "empty");
            this.addJcsFilter(ctx);
            ((StandardContext)StandardContext.class.cast(ctx)).filterStart();
            URL url = new URL("http://localhost:" + tomcat.getConnector().getLocalPort() + "/sample/");
            Assert.assertEquals((Object)"", (Object)IOUtils.toString((InputStream)url.openStream()));
            Assert.assertEquals((long)1L, (long)Empty.COUNTER.get());
            Assert.assertEquals((Object)"", (Object)IOUtils.toString((InputStream)url.openStream()));
            Assert.assertEquals((long)1L, (long)Empty.COUNTER.get());
        }
        finally {
            this.stop(tomcat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFilter() throws Exception {
        Hello.COUNTER.set(0);
        Tomcat tomcat = new Tomcat();
        tomcat.setPort(0);
        try {
            tomcat.getEngine();
            tomcat.start();
            Context ctx = tomcat.addContext("/sample", docBase.getAbsolutePath());
            Tomcat.addServlet((Context)ctx, (String)"hello", (String)Hello.class.getName());
            ctx.addServletMapping("/", "hello");
            this.addJcsFilter(ctx);
            ((StandardContext)StandardContext.class.cast(ctx)).filterStart();
            URL url = new URL("http://localhost:" + tomcat.getConnector().getLocalPort() + "/sample/");
            Assert.assertEquals((Object)"hello", (Object)IOUtils.toString((InputStream)url.openStream()));
            Assert.assertEquals((long)1L, (long)Hello.COUNTER.get());
            Assert.assertEquals((Object)"hello", (Object)IOUtils.toString((InputStream)url.openStream()));
            Assert.assertEquals((long)1L, (long)Hello.COUNTER.get());
        }
        finally {
            this.stop(tomcat);
        }
    }

    private void stop(Tomcat tomcat) throws LifecycleException {
        if (LifecycleState.STARTED.equals((Object)tomcat.getServer().getState())) {
            tomcat.stop();
            tomcat.destroy();
        }
    }

    private void addJcsFilter(Context ctx) {
        FilterDef filterDef = new FilterDef();
        filterDef.setFilterName("jcs");
        filterDef.setFilterClass(JCacheFilter.class.getName());
        ctx.addFilterDef(filterDef);
        FilterMap filterMap = new FilterMap();
        filterMap.setFilterName(filterDef.getFilterName());
        filterMap.addURLPattern("/*");
        ctx.addFilterMap(filterMap);
    }

    public static class Empty
    extends HttpServlet {
        public static final AtomicInteger COUNTER = new AtomicInteger();

        protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.getWriter().write("");
            COUNTER.incrementAndGet();
        }
    }

    public static class Hello
    extends HttpServlet {
        public static final AtomicInteger COUNTER = new AtomicInteger();

        protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.getWriter().write("hello");
            COUNTER.incrementAndGet();
        }
    }
}

