/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.jcache.extras.writer;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cache.Cache;
import javax.cache.configuration.Factory;
import javax.cache.integration.CacheWriter;
import javax.cache.integration.CacheWriterException;

public class AsyncCacheWriter<K, V>
implements CacheWriter<K, V>,
Closeable,
Factory<CacheWriter<K, V>> {
    private static final Logger LOGGER = Logger.getLogger(AsyncCacheWriter.class.getName());
    private final CacheWriter<K, V> writer;
    private final ExecutorService pool;

    public AsyncCacheWriter(CacheWriter<K, V> delegate, int poolSize) {
        this.writer = delegate;
        this.pool = Executors.newFixedThreadPool(poolSize, new DaemonThreadFactory(delegate.getClass().getName() + "-" + delegate.hashCode() + "-"));
    }

    public void write(final Cache.Entry<? extends K, ? extends V> entry) throws CacheWriterException {
        this.pool.submit(new ExceptionProtectionRunnable(){

            @Override
            public void doRun() {
                AsyncCacheWriter.this.writer.write(entry);
            }
        });
    }

    public void writeAll(final Collection<Cache.Entry<? extends K, ? extends V>> entries) throws CacheWriterException {
        this.pool.submit(new ExceptionProtectionRunnable(){

            @Override
            public void doRun() {
                AsyncCacheWriter.this.writer.writeAll(entries);
            }
        });
    }

    public void delete(final Object key) throws CacheWriterException {
        this.pool.submit(new ExceptionProtectionRunnable(){

            @Override
            public void doRun() {
                AsyncCacheWriter.this.writer.delete(key);
            }
        });
    }

    public void deleteAll(final Collection<?> keys) throws CacheWriterException {
        this.pool.submit(new ExceptionProtectionRunnable(){

            @Override
            public void doRun() {
                AsyncCacheWriter.this.writer.deleteAll(keys);
            }
        });
    }

    @Override
    public void close() throws IOException {
        List<Runnable> runnables = this.pool.shutdownNow();
        for (Runnable r : runnables) {
            r.run();
        }
    }

    public CacheWriter<K, V> create() {
        return this;
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        private final AtomicInteger index = new AtomicInteger(1);
        private final String prefix;

        public DaemonThreadFactory(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public Thread newThread(Runnable runner) {
            Thread t = new Thread(runner);
            t.setName(this.prefix + this.index.getAndIncrement());
            t.setDaemon(true);
            return t;
        }
    }

    private static abstract class ExceptionProtectionRunnable
    implements Runnable {
        private ExceptionProtectionRunnable() {
        }

        @Override
        public void run() {
            try {
                this.doRun();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }

        protected abstract void doRun();
    }
}

