/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.disk.indexed;

import java.io.IOException;
import java.util.Random;
import org.apache.commons.jcs3.auxiliary.disk.DiskTestObject;
import org.apache.commons.jcs3.engine.CacheElement;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.utils.serialization.StandardSerializer;

public class DiskTestObjectUtil {
    public static long totalSize(DiskTestObject[] testObjects, int endPosition) throws IOException {
        StandardSerializer serializer = new StandardSerializer();
        long total = 0L;
        for (int i = 0; i < endPosition; ++i) {
            int tileSize = serializer.serialize((Object)testObjects[i]).length + 4;
            total += (long)tileSize;
        }
        return total;
    }

    public static <K, V> long totalSize(ICacheElement<K, V>[] elements, int endPosition) throws IOException {
        return DiskTestObjectUtil.totalSize(elements, 0, endPosition);
    }

    public static <K, V> long totalSize(ICacheElement<K, V>[] elements, int startPosition, int endPosition) throws IOException {
        StandardSerializer serializer = new StandardSerializer();
        long total = 0L;
        for (int i = startPosition; i < endPosition; ++i) {
            int tileSize = serializer.serialize(elements[i]).length + 4;
            total += (long)tileSize;
        }
        return total;
    }

    public static ICacheElement<Integer, DiskTestObject>[] createCacheElementsWithTestObjects(int numToCreate, int bytes, String cacheName) {
        ICacheElement[] elements = new ICacheElement[numToCreate];
        for (int i = 0; i < numToCreate; ++i) {
            int size = bytes * 1024;
            DiskTestObject tile = new DiskTestObject(i, new byte[size]);
            CacheElement element = new CacheElement(cacheName, (Object)tile.id, (Object)tile);
            elements[i] = element;
        }
        return elements;
    }

    public static ICacheElement<Integer, DiskTestObject>[] createCacheElementsWithTestObjectsOfVariableSizes(int numToCreate, String cacheName) {
        ICacheElement[] elements = new ICacheElement[numToCreate];
        Random random = new Random(89L);
        for (int i = 0; i < numToCreate; ++i) {
            int bytes = random.nextInt(20);
            int size = (bytes + 4) * 1024;
            DiskTestObject tile = new DiskTestObject(i, new byte[size]);
            CacheElement element = new CacheElement(cacheName, (Object)tile.id, (Object)tile);
            elements[i] = element;
        }
        return elements;
    }
}

