/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.Assert;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.JexlException;
import org.apache.commons.jexl2.JexlTestCase;
import org.apache.commons.jexl2.MapContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheTest
extends JexlTestCase {
    private static final JexlEngine jexl = CacheTest.createEngine(false);
    private static final int LOOPS = 4096;
    private static final int NTHREADS = 4;
    private static final int[] MIX;

    public CacheTest(String testName) {
        super(testName);
    }

    public void setUp() throws Exception {
        Logger.getLogger(JexlEngine.class.getName()).setLevel(Level.SEVERE);
    }

    @Override
    protected void tearDown() throws Exception {
        CacheTest.debuggerCheck(jexl);
    }

    void runThreaded(Class<? extends Task> ctask, int loops, boolean cache) throws Exception {
        if (loops == 0) {
            loops = MIX.length;
        }
        if (cache) {
            jexl.setCache(32);
        } else {
            jexl.setCache(0);
        }
        ExecutorService execs = Executors.newFixedThreadPool(4);
        ArrayList<Object> tasks = new ArrayList<Object>(4);
        for (int t = 0; t < 4; ++t) {
            tasks.add(jexl.newInstance(ctask, new Object[]{loops}));
        }
        List futures = execs.invokeAll(tasks, 60L, TimeUnit.SECONDS);
        for (Future future : futures) {
            CacheTest.assertEquals((Object)loops, future.get());
        }
    }

    public void testNullAssignNoCache() throws Exception {
        this.runThreaded(AssignNullTask.class, 4096, false);
    }

    public void testNullAssignCache() throws Exception {
        this.runThreaded(AssignNullTask.class, 4096, true);
    }

    public void testAssignNoCache() throws Exception {
        this.runThreaded(AssignTask.class, 4096, false);
    }

    public void testAssignCache() throws Exception {
        this.runThreaded(AssignTask.class, 4096, true);
    }

    public void testAssignBooleanNoCache() throws Exception {
        this.runThreaded(AssignBooleanTask.class, 4096, false);
    }

    public void testAssignBooleanCache() throws Exception {
        this.runThreaded(AssignBooleanTask.class, 4096, true);
    }

    public void testAssignListNoCache() throws Exception {
        this.runThreaded(AssignListTask.class, 4096, false);
    }

    public void testAssignListCache() throws Exception {
        this.runThreaded(AssignListTask.class, 4096, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testComputeNoCache() throws Exception {
        try {
            jexl.setDebug(true);
            this.runThreaded(ComputeTask.class, 4096, false);
        }
        finally {
            jexl.setDebug(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testComputeCache() throws Exception {
        try {
            jexl.setDebug(true);
            this.runThreaded(ComputeTask.class, 4096, true);
        }
        finally {
            jexl.setDebug(false);
        }
    }

    void doCOMPUTE(TestCacheArguments x, int loops, boolean cache) throws Exception {
        if (loops == 0) {
            loops = MIX.length;
        }
        if (cache) {
            jexl.setCache(32);
        } else {
            jexl.setCache(0);
        }
        HashMap<String, Object> vars = new HashMap<String, Object>();
        MapContext jc = new MapContext(vars);
        HashMap<String, Object> funcs = new HashMap<String, Object>();
        jexl.setFunctions(funcs);
        Expression compute2 = jexl.createExpression("cached:COMPUTE(a0, a1)");
        Expression compute1 = jexl.createExpression("cached:COMPUTE(a0)");
        Object result = null;
        String expected = null;
        for (int l = 0; l < loops; ++l) {
            int mix = MIX[l % MIX.length] % x.ca.length;
            Object value = x.value[l % x.value.length];
            funcs.put("cached", x.ca[mix]);
            if (value instanceof String) {
                vars.put("a0", "S0");
                vars.put("a1", "S1");
                expected = "CACHED@s#S0,s#S1";
            } else if (value instanceof Integer) {
                vars.put("a0", 7);
                vars.put("a1", 9);
                expected = "CACHED@i#7,i#9";
            } else {
                CacheTest.fail((String)"unexpected value type");
            }
            result = compute2.evaluate((JexlContext)jc);
            CacheTest.assertEquals((String)compute2.toString(), (Object)expected, (Object)result);
            if (value instanceof String) {
                vars.put("a0", "X0");
                expected = "CACHED@s#X0";
            } else if (value instanceof Integer) {
                vars.put("a0", 5);
                expected = "CACHED@i#5";
            } else {
                CacheTest.fail((String)"unexpected value type");
            }
            result = compute1.evaluate((JexlContext)jc);
            CacheTest.assertEquals((String)compute1.toString(), (Object)expected, (Object)result);
        }
    }

    public void testCOMPUTENoCache() throws Exception {
        TestCacheArguments args = new TestCacheArguments();
        args.ca = new Object[]{Cached.class, Cached1.class, Cached2.class};
        args.value = new Object[]{new Integer(2), "quux"};
        this.doCOMPUTE(args, 4096, false);
    }

    public void testCOMPUTECache() throws Exception {
        TestCacheArguments args = new TestCacheArguments();
        args.ca = new Object[]{Cached.class, Cached1.class, Cached2.class};
        args.value = new Object[]{new Integer(2), "quux"};
        this.doCOMPUTE(args, 4096, true);
    }

    static {
        jexl.setCache(512);
        jexl.setSilent(false);
        MIX = new int[]{0, 0, 3, 3, 4, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 2, 2, 3, 3, 0};
    }

    public static class ComputeTask
    extends Task {
        public ComputeTask(int loops) {
            super(loops);
        }

        public Integer call() throws Exception {
            this.args.ca = new Object[]{this.args.c0, this.args.c1, this.args.c2};
            this.args.value = new Object[]{new Integer(2), "quux"};
            Expression compute2 = jexl.createExpression("cache.compute(a0, a1)");
            Expression compute1 = jexl.createExpression("cache.compute(a0)");
            Expression compute1null = jexl.createExpression("cache.compute(a0)");
            Expression ambiguous = jexl.createExpression("cache.ambiguous(a0, a1)");
            Object result = null;
            String expected = null;
            for (int l = 0; l < this.loops; ++l) {
                int mix = MIX[l % MIX.length] % this.args.ca.length;
                Object value = this.args.value[l % this.args.value.length];
                this.vars.put("cache", this.args.ca[mix]);
                if (value instanceof String) {
                    this.vars.put("a0", "S0");
                    this.vars.put("a1", "S1");
                    expected = "Cached" + mix + "@s#S0,s#S1";
                } else if (value instanceof Integer) {
                    this.vars.put("a0", 7);
                    this.vars.put("a1", 9);
                    expected = "Cached" + mix + "@i#7,i#9";
                } else {
                    Assert.fail((String)"unexpected value type");
                }
                result = compute2.evaluate(this.jc);
                Assert.assertEquals((String)compute2.toString(), expected, (Object)result);
                if (value instanceof Integer) {
                    try {
                        this.vars.put("a0", (short)17);
                        this.vars.put("a1", (short)19);
                        result = ambiguous.evaluate(this.jc);
                        Assert.fail((String)"should have thrown an exception");
                    }
                    catch (JexlException xany) {
                        // empty catch block
                    }
                }
                if (value instanceof String) {
                    this.vars.put("a0", "X0");
                    expected = "Cached" + mix + "@s#X0";
                } else if (value instanceof Integer) {
                    this.vars.put("a0", 5);
                    expected = "Cached" + mix + "@i#5";
                } else {
                    Assert.fail((String)"unexpected value type");
                }
                result = compute1.evaluate(this.jc);
                Assert.assertEquals((String)compute1.toString(), (Object)expected, (Object)result);
                try {
                    this.vars.put("a0", null);
                    result = compute1null.evaluate(this.jc);
                    Assert.fail((String)"should have thrown an exception");
                    continue;
                }
                catch (JexlException xany) {
                    String sany = xany.getMessage();
                    String tname = this.getClass().getName();
                    if (sany.startsWith(tname)) continue;
                    Assert.fail((String)("debug mode should carry caller information, " + sany + ", " + tname));
                }
            }
            return this.loops;
        }
    }

    public static class AssignListTask
    extends Task {
        public AssignListTask(int loops) {
            super(loops);
        }

        public Integer call() throws Exception {
            return this.runAssignList();
        }

        private Integer runAssignList() {
            this.args.value = new Object[]{"foo"};
            ArrayList<String> c1 = new ArrayList<String>(2);
            c1.add("foo");
            c1.add("bar");
            this.args.ca = new Object[]{new String[]{"one", "two"}, c1};
            Expression cacheGetValue = jexl.createExpression("cache.0");
            Expression cacheSetValue = jexl.createExpression("cache[0] = value");
            for (int l = 0; l < this.loops; ++l) {
                int px = (int)Thread.currentThread().getId();
                int mix = MIX[(l + px) % MIX.length] % this.args.ca.length;
                this.vars.put("cache", this.args.ca[mix]);
                this.vars.put("value", this.args.value[0]);
                Object result = cacheSetValue.evaluate(this.jc);
                Assert.assertEquals((String)cacheSetValue.toString(), (Object)this.args.value[0], (Object)result);
                result = cacheGetValue.evaluate(this.jc);
                Assert.assertEquals((String)cacheGetValue.toString(), (Object)this.args.value[0], (Object)result);
            }
            return this.loops;
        }
    }

    public static class AssignBooleanTask
    extends Task {
        public AssignBooleanTask(int loops) {
            super(loops);
        }

        public Integer call() throws Exception {
            return this.runAssignBoolean(Boolean.TRUE);
        }

        private Integer runAssignBoolean(Boolean value) {
            this.args.value = new Object[]{value};
            Expression cacheGetValue = jexl.createExpression("cache.flag");
            Expression cacheSetValue = jexl.createExpression("cache.flag = value");
            for (int l = 0; l < this.loops; ++l) {
                int px = (int)Thread.currentThread().getId();
                int mix = MIX[(l + px) % MIX.length];
                this.vars.put("cache", this.args.ca[mix]);
                this.vars.put("value", this.args.value[0]);
                Object result = cacheSetValue.evaluate(this.jc);
                Assert.assertEquals((String)cacheSetValue.toString(), (Object)this.args.value[0], (Object)result);
                result = cacheGetValue.evaluate(this.jc);
                Assert.assertEquals((String)cacheGetValue.toString(), (Object)this.args.value[0], (Object)result);
            }
            return this.loops;
        }
    }

    public static class AssignNullTask
    extends Task {
        public AssignNullTask(int loops) {
            super(loops);
        }

        public Integer call() throws Exception {
            return this.runAssign(null);
        }
    }

    public static class AssignTask
    extends Task {
        public AssignTask(int loops) {
            super(loops);
        }

        public Integer call() throws Exception {
            return this.runAssign("foo");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Task
    implements Callable<Integer> {
        final TestCacheArguments args = new TestCacheArguments();
        final int loops;
        final Map<String, Object> vars = new HashMap<String, Object>();
        final JexlContext jc = new MapContext(this.vars);

        Task(int loops) {
            this.loops = loops;
        }

        @Override
        public abstract Integer call() throws Exception;

        public Integer runAssign(Object value) {
            this.args.value = new Object[]{value};
            Expression cacheGetValue = jexl.createExpression("cache.value");
            Expression cacheSetValue = jexl.createExpression("cache.value = value");
            for (int l = 0; l < this.loops; ++l) {
                int px = (int)Thread.currentThread().getId();
                int mix = MIX[(l + px) % MIX.length];
                this.vars.put("cache", this.args.ca[mix]);
                this.vars.put("value", this.args.value[0]);
                Object result = cacheSetValue.evaluate(this.jc);
                if (this.args.value[0] == null) {
                    Assert.assertNull((String)cacheSetValue.toString(), (Object)result);
                } else {
                    Assert.assertEquals((String)cacheSetValue.toString(), (Object)this.args.value[0], (Object)result);
                }
                result = cacheGetValue.evaluate(this.jc);
                if (this.args.value[0] == null) {
                    Assert.assertEquals((String)cacheGetValue.toString(), (Object)("Cached" + mix + ":na"), (Object)result);
                    continue;
                }
                Assert.assertEquals((String)cacheGetValue.toString(), (Object)("Cached" + mix + ":" + this.args.value[0]), (Object)result);
            }
            return this.loops;
        }
    }

    static class TestCacheArguments {
        Cached0 c0 = new Cached0();
        Cached1 c1 = new Cached1();
        Cached2 c2 = new Cached2();
        Cached3 c3 = new Cached3();
        Cached4 c4 = new Cached4();
        Object[] ca = new Object[]{this.c0, this.c1, this.c2, this.c3, this.c4};
        Object[] value = null;

        TestCacheArguments() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Cached4
    extends ArrayList<String> {
        private static final long serialVersionUID = 1L;

        public Cached4() {
            super.add("Cached4:new");
            super.add("false");
        }

        public String getValue() {
            return (String)super.get(0);
        }

        public void setValue(String arg) {
            if (arg == null) {
                arg = "na";
            }
            super.set(0, "Cached4:" + arg);
        }

        public void setflag(Boolean b) {
            super.set(1, b.toString());
        }

        public boolean isflag() {
            return Boolean.parseBoolean((String)super.get(1));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Cached3
    extends TreeMap<String, Object> {
        private static final long serialVersionUID = 1L;
        boolean flag = false;

        public Cached3() {
            this.put("value", (Object)"Cached3:new");
            this.put("flag", (Object)"false");
        }

        @Override
        public Object get(Object key) {
            return super.get(key.toString());
        }

        @Override
        public Object put(String key, Object arg) {
            if (arg == null) {
                arg = "na";
            }
            arg = "Cached3:" + arg;
            return super.put(key, arg);
        }

        public void setflag(boolean b) {
            this.flag = b;
        }

        public boolean isflag() {
            return this.flag;
        }
    }

    public static class Cached2
    extends Cached {
        boolean flag = false;
        protected String value = "Cached2:new";

        public Object get(String prop) {
            if ("value".equals(prop)) {
                return this.value;
            }
            if ("flag".equals(prop)) {
                return this.flag;
            }
            throw new RuntimeException("no such property");
        }

        public void set(String p, Object v) {
            if (v == null) {
                v = "na";
            }
            if ("value".equals(p)) {
                this.value = this.getClass().getSimpleName() + ":" + v;
            } else if ("flag".equals(p)) {
                this.flag = Boolean.parseBoolean(v.toString());
            } else {
                throw new RuntimeException("no such property");
            }
        }
    }

    public static class Cached1
    extends Cached0 {
        public void setValue(String arg) {
            if (arg == null) {
                arg = "na";
            }
            this.value = "Cached1:" + arg;
        }
    }

    public static class Cached0
    extends Cached {
        protected String value = "Cached0:new";
        protected Boolean flag = Boolean.FALSE;

        public String getValue() {
            return this.value;
        }

        public void setValue(String arg) {
            if (arg == null) {
                arg = "na";
            }
            this.value = "Cached0:" + arg;
        }

        public void setFlag(boolean b) {
            this.flag = b;
        }

        public boolean isFlag() {
            return this.flag;
        }
    }

    public static class Cached {
        public String compute(String arg) {
            if (arg == null) {
                arg = "na";
            }
            return this.getClass().getSimpleName() + "@s#" + arg;
        }

        public String compute(String arg0, String arg1) {
            if (arg0 == null) {
                arg0 = "na";
            }
            if (arg1 == null) {
                arg1 = "na";
            }
            return this.getClass().getSimpleName() + "@s#" + arg0 + ",s#" + arg1;
        }

        public String compute(Integer arg) {
            return this.getClass().getSimpleName() + "@i#" + arg;
        }

        public String compute(float arg) {
            return this.getClass().getSimpleName() + "@f#" + arg;
        }

        public String compute(int arg0, int arg1) {
            return this.getClass().getSimpleName() + "@i#" + arg0 + ",i#" + arg1;
        }

        public String ambiguous(Integer arg0, int arg1) {
            return this.getClass().getSimpleName() + "!i#" + arg0 + ",i#" + arg1;
        }

        public String ambiguous(int arg0, Integer arg1) {
            return this.getClass().getSimpleName() + "!i#" + arg0 + ",i#" + arg1;
        }

        public static String COMPUTE(String arg) {
            if (arg == null) {
                arg = "na";
            }
            return "CACHED@s#" + arg;
        }

        public static String COMPUTE(String arg0, String arg1) {
            if (arg0 == null) {
                arg0 = "na";
            }
            if (arg1 == null) {
                arg1 = "na";
            }
            return "CACHED@s#" + arg0 + ",s#" + arg1;
        }

        public static String COMPUTE(int arg) {
            return "CACHED@i#" + arg;
        }

        public static String COMPUTE(int arg0, int arg1) {
            return "CACHED@i#" + arg0 + ",i#" + arg1;
        }
    }
}

