/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.euclidean.threed;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.math3.exception.MathArithmeticException;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.util.ExceptionContext;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.threed.Euclidean3D;
import org.apache.commons.math3.geometry.euclidean.threed.Line;
import org.apache.commons.math3.geometry.euclidean.threed.PLYParser;
import org.apache.commons.math3.geometry.euclidean.threed.Plane;
import org.apache.commons.math3.geometry.euclidean.threed.PolyhedronsSet;
import org.apache.commons.math3.geometry.euclidean.threed.Rotation;
import org.apache.commons.math3.geometry.euclidean.threed.RotationConvention;
import org.apache.commons.math3.geometry.euclidean.threed.SubPlane;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.geometry.euclidean.twod.PolygonsSet;
import org.apache.commons.math3.geometry.euclidean.twod.SubLine;
import org.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import org.apache.commons.math3.geometry.partitioning.BSPTree;
import org.apache.commons.math3.geometry.partitioning.BSPTreeVisitor;
import org.apache.commons.math3.geometry.partitioning.BoundaryAttribute;
import org.apache.commons.math3.geometry.partitioning.Hyperplane;
import org.apache.commons.math3.geometry.partitioning.Region;
import org.apache.commons.math3.geometry.partitioning.RegionDumper;
import org.apache.commons.math3.geometry.partitioning.RegionFactory;
import org.apache.commons.math3.geometry.partitioning.RegionParser;
import org.apache.commons.math3.geometry.partitioning.SubHyperplane;
import org.apache.commons.math3.random.Well1024a;
import org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolyhedronsSetTest {
    @Test
    public void testBox() {
        PolyhedronsSet tree = new PolyhedronsSet(0.0, 1.0, 0.0, 1.0, 0.0, 1.0, 1.0E-10);
        Assert.assertEquals((double)1.0, (double)tree.getSize(), (double)1.0E-10);
        Assert.assertEquals((double)6.0, (double)tree.getBoundarySize(), (double)1.0E-10);
        Vector3D barycenter = (Vector3D)tree.getBarycenter();
        Assert.assertEquals((double)0.5, (double)barycenter.getX(), (double)1.0E-10);
        Assert.assertEquals((double)0.5, (double)barycenter.getY(), (double)1.0E-10);
        Assert.assertEquals((double)0.5, (double)barycenter.getZ(), (double)1.0E-10);
        for (double x = -0.25; x < 1.25; x += 0.1) {
            boolean xOK = x >= 0.0 && x <= 1.0;
            for (double y = -0.25; y < 1.25; y += 0.1) {
                boolean yOK = y >= 0.0 && y <= 1.0;
                for (double z = -0.25; z < 1.25; z += 0.1) {
                    boolean zOK = z >= 0.0 && z <= 1.0;
                    Region.Location expected = xOK && yOK && zOK ? Region.Location.INSIDE : Region.Location.OUTSIDE;
                    Assert.assertEquals((Object)expected, (Object)tree.checkPoint((Vector)new Vector3D(x, y, z)));
                }
            }
        }
        this.checkPoints(Region.Location.BOUNDARY, tree, new Vector3D[]{new Vector3D(0.0, 0.5, 0.5), new Vector3D(1.0, 0.5, 0.5), new Vector3D(0.5, 0.0, 0.5), new Vector3D(0.5, 1.0, 0.5), new Vector3D(0.5, 0.5, 0.0), new Vector3D(0.5, 0.5, 1.0)});
        this.checkPoints(Region.Location.OUTSIDE, tree, new Vector3D[]{new Vector3D(0.0, 1.2, 1.2), new Vector3D(1.0, 1.2, 1.2), new Vector3D(1.2, 0.0, 1.2), new Vector3D(1.2, 1.0, 1.2), new Vector3D(1.2, 1.2, 0.0), new Vector3D(1.2, 1.2, 1.0)});
    }

    @Test
    public void testTetrahedron() throws MathArithmeticException {
        Vector3D vertex1 = new Vector3D(1.0, 2.0, 3.0);
        Vector3D vertex2 = new Vector3D(2.0, 2.0, 4.0);
        Vector3D vertex3 = new Vector3D(2.0, 3.0, 3.0);
        Vector3D vertex4 = new Vector3D(1.0, 3.0, 4.0);
        PolyhedronsSet tree = (PolyhedronsSet)new RegionFactory().buildConvex(new Hyperplane[]{new Plane(vertex3, vertex2, vertex1, 1.0E-10), new Plane(vertex2, vertex3, vertex4, 1.0E-10), new Plane(vertex4, vertex3, vertex1, 1.0E-10), new Plane(vertex1, vertex2, vertex4, 1.0E-10)});
        Assert.assertEquals((double)0.3333333333333333, (double)tree.getSize(), (double)1.0E-10);
        Assert.assertEquals((double)(2.0 * FastMath.sqrt((double)3.0)), (double)tree.getBoundarySize(), (double)1.0E-10);
        Vector3D barycenter = (Vector3D)tree.getBarycenter();
        Assert.assertEquals((double)1.5, (double)barycenter.getX(), (double)1.0E-10);
        Assert.assertEquals((double)2.5, (double)barycenter.getY(), (double)1.0E-10);
        Assert.assertEquals((double)3.5, (double)barycenter.getZ(), (double)1.0E-10);
        double third = 0.3333333333333333;
        this.checkPoints(Region.Location.BOUNDARY, tree, new Vector3D[]{vertex1, vertex2, vertex3, vertex4, new Vector3D(third, vertex1, third, vertex2, third, vertex3), new Vector3D(third, vertex2, third, vertex3, third, vertex4), new Vector3D(third, vertex3, third, vertex4, third, vertex1), new Vector3D(third, vertex4, third, vertex1, third, vertex2)});
        this.checkPoints(Region.Location.OUTSIDE, tree, new Vector3D[]{new Vector3D(1.0, 2.0, 4.0), new Vector3D(2.0, 2.0, 3.0), new Vector3D(2.0, 3.0, 4.0), new Vector3D(1.0, 3.0, 3.0)});
    }

    @Test
    public void testIsometry() throws MathArithmeticException, MathIllegalArgumentException {
        Vector3D vertex1 = new Vector3D(1.1, 2.2, 3.3);
        Vector3D vertex2 = new Vector3D(2.0, 2.4, 4.2);
        Vector3D vertex3 = new Vector3D(2.8, 3.3, 3.7);
        Vector3D vertex4 = new Vector3D(1.0, 3.6, 4.5);
        PolyhedronsSet tree = (PolyhedronsSet)new RegionFactory().buildConvex(new Hyperplane[]{new Plane(vertex3, vertex2, vertex1, 1.0E-10), new Plane(vertex2, vertex3, vertex4, 1.0E-10), new Plane(vertex4, vertex3, vertex1, 1.0E-10), new Plane(vertex1, vertex2, vertex4, 1.0E-10)});
        Vector3D barycenter = (Vector3D)tree.getBarycenter();
        Vector3D s = new Vector3D(10.2, 4.3, -6.7);
        Vector3D c = new Vector3D(-0.2, 2.1, -3.2);
        Rotation r = new Rotation(new Vector3D(6.2, -4.4, 2.1), 0.12, RotationConvention.VECTOR_OPERATOR);
        tree = tree.rotate(c, r).translate(s);
        Vector3D newB = new Vector3D(1.0, s, 1.0, c, 1.0, r.applyTo(barycenter.subtract((Vector)c)));
        Assert.assertEquals((double)0.0, (double)newB.subtract((Vector)tree.getBarycenter()).getNorm(), (double)1.0E-10);
        final Vector3D[] expectedV = new Vector3D[]{new Vector3D(1.0, s, 1.0, c, 1.0, r.applyTo(vertex1.subtract((Vector)c))), new Vector3D(1.0, s, 1.0, c, 1.0, r.applyTo(vertex2.subtract((Vector)c))), new Vector3D(1.0, s, 1.0, c, 1.0, r.applyTo(vertex3.subtract((Vector)c))), new Vector3D(1.0, s, 1.0, c, 1.0, r.applyTo(vertex4.subtract((Vector)c)))};
        tree.getTree(true).visit((BSPTreeVisitor)new BSPTreeVisitor<Euclidean3D>(){

            public BSPTreeVisitor.Order visitOrder(BSPTree<Euclidean3D> node) {
                return BSPTreeVisitor.Order.MINUS_SUB_PLUS;
            }

            public void visitInternalNode(BSPTree<Euclidean3D> node) {
                BoundaryAttribute attribute = (BoundaryAttribute)node.getAttribute();
                if (attribute.getPlusOutside() != null) {
                    this.checkFacet((SubPlane)attribute.getPlusOutside());
                }
                if (attribute.getPlusInside() != null) {
                    this.checkFacet((SubPlane)attribute.getPlusInside());
                }
            }

            public void visitLeafNode(BSPTree<Euclidean3D> node) {
            }

            private void checkFacet(SubPlane facet) {
                Plane plane = (Plane)facet.getHyperplane();
                Vector2D[][] vertices = ((PolygonsSet)facet.getRemainingRegion()).getVertices();
                Assert.assertEquals((long)1L, (long)vertices.length);
                for (int i = 0; i < vertices[0].length; ++i) {
                    Vector3D v = plane.toSpace((Vector)vertices[0][i]);
                    double d = Double.POSITIVE_INFINITY;
                    for (int k = 0; k < expectedV.length; ++k) {
                        d = FastMath.min((double)d, (double)v.subtract((Vector)expectedV[k]).getNorm());
                    }
                    Assert.assertEquals((double)0.0, (double)d, (double)1.0E-10);
                }
            }
        });
    }

    @Test
    public void testBuildBox() {
        double x = 1.0;
        double y = 2.0;
        double z = 3.0;
        double w = 0.1;
        double l = 1.0;
        PolyhedronsSet tree = new PolyhedronsSet(x - l, x + l, y - w, y + w, z - w, z + w, 1.0E-10);
        Vector3D barycenter = (Vector3D)tree.getBarycenter();
        Assert.assertEquals((double)x, (double)barycenter.getX(), (double)1.0E-10);
        Assert.assertEquals((double)y, (double)barycenter.getY(), (double)1.0E-10);
        Assert.assertEquals((double)z, (double)barycenter.getZ(), (double)1.0E-10);
        Assert.assertEquals((double)(8.0 * l * w * w), (double)tree.getSize(), (double)1.0E-10);
        Assert.assertEquals((double)(8.0 * w * (2.0 * l + w)), (double)tree.getBoundarySize(), (double)1.0E-10);
    }

    @Test
    public void testCross() {
        double x = 1.0;
        double y = 2.0;
        double z = 3.0;
        double w = 0.1;
        double l = 1.0;
        PolyhedronsSet xBeam = new PolyhedronsSet(x - l, x + l, y - w, y + w, z - w, z + w, 1.0E-10);
        PolyhedronsSet yBeam = new PolyhedronsSet(x - w, x + w, y - l, y + l, z - w, z + w, 1.0E-10);
        PolyhedronsSet zBeam = new PolyhedronsSet(x - w, x + w, y - w, y + w, z - l, z + l, 1.0E-10);
        RegionFactory factory = new RegionFactory();
        PolyhedronsSet tree = (PolyhedronsSet)factory.union((Region)xBeam, factory.union((Region)yBeam, (Region)zBeam));
        Vector3D barycenter = (Vector3D)tree.getBarycenter();
        Assert.assertEquals((double)x, (double)barycenter.getX(), (double)1.0E-10);
        Assert.assertEquals((double)y, (double)barycenter.getY(), (double)1.0E-10);
        Assert.assertEquals((double)z, (double)barycenter.getZ(), (double)1.0E-10);
        Assert.assertEquals((double)(8.0 * w * w * (3.0 * l - 2.0 * w)), (double)tree.getSize(), (double)1.0E-10);
        Assert.assertEquals((double)(24.0 * w * (2.0 * l - w)), (double)tree.getBoundarySize(), (double)1.0E-10);
    }

    @Test
    public void testIssue780() throws MathArithmeticException {
        float[] coords = new float[]{1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 0.999999f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f};
        int[] indices = new int[]{0, 1, 2, 0, 2, 3, 4, 7, 6, 4, 6, 5, 0, 4, 5, 0, 5, 1, 1, 5, 6, 1, 6, 2, 2, 6, 7, 2, 7, 3, 4, 0, 3, 4, 3, 7};
        ArrayList<SubPlane> subHyperplaneList = new ArrayList<SubPlane>();
        for (int idx = 0; idx < indices.length; idx += 3) {
            int idxA = indices[idx] * 3;
            int idxB = indices[idx + 1] * 3;
            int idxC = indices[idx + 2] * 3;
            Vector3D v_1 = new Vector3D((double)coords[idxA], (double)coords[idxA + 1], (double)coords[idxA + 2]);
            Vector3D v_2 = new Vector3D((double)coords[idxB], (double)coords[idxB + 1], (double)coords[idxB + 2]);
            Vector3D v_3 = new Vector3D((double)coords[idxC], (double)coords[idxC + 1], (double)coords[idxC + 2]);
            Vector3D[] vertices = new Vector3D[]{v_1, v_2, v_3};
            Plane polyPlane = new Plane(v_1, v_2, v_3, 1.0E-10);
            ArrayList<SubLine> lines = new ArrayList<SubLine>();
            Vector2D[] projPts = new Vector2D[vertices.length];
            for (int ptIdx = 0; ptIdx < projPts.length; ++ptIdx) {
                projPts[ptIdx] = polyPlane.toSubSpace((Vector)vertices[ptIdx]);
            }
            SubLine lineInPlane = null;
            for (int ptIdx = 0; ptIdx < projPts.length; ++ptIdx) {
                lineInPlane = new SubLine(projPts[ptIdx], projPts[(ptIdx + 1) % projPts.length], 1.0E-10);
                lines.add(lineInPlane);
            }
            PolygonsSet polyRegion = new PolygonsSet(lines, 1.0E-10);
            SubPlane polygon = new SubPlane((Hyperplane)polyPlane, (Region)polyRegion);
            subHyperplaneList.add(polygon);
        }
        PolyhedronsSet polyhedronsSet = new PolyhedronsSet(subHyperplaneList, 1.0E-10);
        Assert.assertEquals((double)8.0, (double)polyhedronsSet.getSize(), (double)3.0E-6);
        Assert.assertEquals((double)24.0, (double)polyhedronsSet.getBoundarySize(), (double)5.0E-6);
    }

    @Test
    public void testTooThinBox() {
        Assert.assertEquals((double)0.0, (double)new PolyhedronsSet(0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0E-10).getSize(), (double)1.0E-10);
    }

    @Test
    public void testWrongUsage() {
        PolyhedronsSet ps = new PolyhedronsSet(new BSPTree(), 1.0E-10);
        Assert.assertNotNull((Object)ps);
        try {
            ps.checkPoint((Vector)Vector3D.ZERO);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testDumpParse() throws IOException, ParseException {
        double tol = 1.0E-8;
        Vector3D[] verts = new Vector3D[8];
        double xmin = -1.0;
        double xmax = 1.0;
        double ymin = -1.0;
        double ymax = 1.0;
        double zmin = -1.0;
        double zmax = 1.0;
        verts[0] = new Vector3D(xmin, ymin, zmin);
        verts[1] = new Vector3D(xmax, ymin, zmin);
        verts[2] = new Vector3D(xmax, ymax, zmin);
        verts[3] = new Vector3D(xmin, ymax, zmin);
        verts[4] = new Vector3D(xmin, ymin, zmax);
        verts[5] = new Vector3D(xmax, ymin, zmax);
        verts[6] = new Vector3D(xmax, ymax, zmax);
        verts[7] = new Vector3D(xmin, ymax, zmax);
        int[][] faces = new int[][]{{3, 1, 0}, {1, 3, 2}, {5, 7, 4}, {7, 5, 6}, {2, 5, 1}, {5, 2, 6}, {4, 3, 0}, {3, 4, 7}, {4, 1, 5}, {1, 4, 0}, {3, 6, 2}, {6, 3, 7}};
        PolyhedronsSet polyset = new PolyhedronsSet(Arrays.asList(verts), Arrays.asList(faces), tol);
        Assert.assertEquals((double)8.0, (double)polyset.getSize(), (double)1.0E-10);
        Assert.assertEquals((double)24.0, (double)polyset.getBoundarySize(), (double)1.0E-10);
        String dump = RegionDumper.dump(polyset);
        PolyhedronsSet parsed = RegionParser.parsePolyhedronsSet(dump);
        Assert.assertEquals((double)8.0, (double)parsed.getSize(), (double)1.0E-10);
        Assert.assertEquals((double)24.0, (double)parsed.getBoundarySize(), (double)1.0E-10);
        Assert.assertTrue((boolean)new RegionFactory().difference((Region)polyset, (Region)parsed).isEmpty());
    }

    @Test
    public void testConnectedFacets() throws IOException, ParseException {
        InputStream stream = this.getClass().getResourceAsStream("pentomino-N.ply");
        PLYParser parser = new PLYParser(stream);
        stream.close();
        PolyhedronsSet polyhedron = new PolyhedronsSet(parser.getVertices(), parser.getFaces(), 1.0E-10);
        Assert.assertEquals((double)5.0, (double)polyhedron.getSize(), (double)1.0E-10);
        Assert.assertEquals((double)22.0, (double)polyhedron.getBoundarySize(), (double)1.0E-10);
    }

    @Test
    public void testTooClose() throws IOException, ParseException {
        this.checkError("pentomino-N-too-close.ply", LocalizedFormats.CLOSE_VERTICES);
    }

    @Test
    public void testHole() throws IOException, ParseException {
        this.checkError("pentomino-N-hole.ply", LocalizedFormats.EDGE_CONNECTED_TO_ONE_FACET);
    }

    @Test
    public void testNonPlanar() throws IOException, ParseException {
        this.checkError("pentomino-N-out-of-plane.ply", LocalizedFormats.OUT_OF_PLANE);
    }

    @Test
    public void testOrientation() throws IOException, ParseException {
        this.checkError("pentomino-N-bad-orientation.ply", LocalizedFormats.FACET_ORIENTATION_MISMATCH);
    }

    @Test
    public void testFacet2Vertices() throws IOException, ParseException {
        ArrayList<Vector3D> vertices = new ArrayList<Vector3D>();
        vertices.add(Vector3D.ZERO);
        vertices.add(Vector3D.PLUS_I);
        vertices.add(Vector3D.PLUS_J);
        vertices.add(Vector3D.PLUS_K);
        ArrayList<int[]> facets = new ArrayList<int[]>();
        facets.add(new int[]{0, 1, 2});
        facets.add(new int[]{2, 3});
        this.checkError(vertices, facets, LocalizedFormats.WRONG_NUMBER_OF_POINTS);
    }

    private void checkError(String resourceName, LocalizedFormats expected) {
        try {
            InputStream stream = this.getClass().getResourceAsStream(resourceName);
            PLYParser parser = new PLYParser(stream);
            stream.close();
            this.checkError(parser.getVertices(), parser.getFaces(), expected);
        }
        catch (IOException ioe) {
            Assert.fail((String)ioe.getLocalizedMessage());
        }
        catch (ParseException pe) {
            Assert.fail((String)pe.getLocalizedMessage());
        }
    }

    private void checkError(List<Vector3D> vertices, List<int[]> facets, LocalizedFormats expected) {
        try {
            new PolyhedronsSet(vertices, facets, 1.0E-10);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException miae) {
            try {
                Field msgPatterns = ExceptionContext.class.getDeclaredField("msgPatterns");
                msgPatterns.setAccessible(true);
                List list = (List)msgPatterns.get(miae.getContext());
                Assert.assertEquals((Object)expected, list.get(0));
            }
            catch (NoSuchFieldException nsfe) {
                Assert.fail((String)nsfe.getLocalizedMessage());
            }
            catch (IllegalAccessException iae) {
                Assert.fail((String)iae.getLocalizedMessage());
            }
        }
    }

    @Test
    public void testIssue1211() throws IOException, ParseException {
        PolyhedronsSet polyset = RegionParser.parsePolyhedronsSet(this.loadTestData("issue-1211.bsp"));
        Well1024a random = new Well1024a(-5081013540859288566L);
        int nrays = 1000;
        for (int i = 0; i < nrays; ++i) {
            Vector3D origin = Vector3D.ZERO;
            Vector3D direction = new Vector3D(2.0 * random.nextDouble() - 1.0, 2.0 * random.nextDouble() - 1.0, 2.0 * random.nextDouble() - 1.0).normalize();
            Line line = new Line(origin, origin.add((Vector)direction), polyset.getTolerance());
            SubHyperplane plane = polyset.firstIntersection(origin, line);
            if (plane == null) continue;
            Vector3D intersectionPoint = ((Plane)plane.getHyperplane()).intersection(line);
            double dotProduct = direction.dotProduct((Vector)intersectionPoint.subtract((Vector)origin));
            Assert.assertTrue((dotProduct > 0.0 ? 1 : 0) != 0);
        }
    }

    private String loadTestData(String resourceName) throws IOException {
        InputStream stream = this.getClass().getResourceAsStream(resourceName);
        InputStreamReader reader = new InputStreamReader(stream, "UTF-8");
        StringBuilder builder = new StringBuilder();
        int c = ((Reader)reader).read();
        while (c >= 0) {
            builder.append((char)c);
            c = ((Reader)reader).read();
        }
        return builder.toString();
    }

    private void checkPoints(Region.Location expected, PolyhedronsSet tree, Vector3D[] points) {
        for (int i = 0; i < points.length; ++i) {
            Assert.assertEquals((Object)expected, (Object)tree.checkPoint((Vector)points[i]));
        }
    }
}

