/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.scxml.semantics;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.commons.scxml.SCXMLHelper;
import org.apache.commons.scxml.model.Parallel;
import org.apache.commons.scxml.model.State;
import org.apache.commons.scxml.model.TransitionTarget;

final class TransitionTargetComparator
implements Comparator,
Serializable {
    private static final long serialVersionUID = 1L;

    TransitionTargetComparator() {
    }

    public int compare(Object o1, Object o2) {
        TransitionTarget tt1 = (TransitionTarget)o1;
        TransitionTarget tt2 = (TransitionTarget)o2;
        if (tt1 == tt2) {
            return 0;
        }
        if (SCXMLHelper.isDescendant(tt1, tt2)) {
            return -1;
        }
        if (SCXMLHelper.isDescendant(tt2, tt1)) {
            return 1;
        }
        int tc1 = this.countChainLength(tt1);
        int tc2 = this.countChainLength(tt2);
        if (tc2 == tc1) {
            Parallel lca = (Parallel)SCXMLHelper.getLCA(tt1, tt2);
            TransitionTarget parent1 = tt1;
            while (parent1.getParent() != lca) {
                parent1 = parent1.getParent();
            }
            TransitionTarget parent2 = tt2;
            while (parent2.getParent() != lca) {
                parent2 = parent2.getParent();
            }
            Iterator iter = lca.getChildren().iterator();
            while (iter.hasNext()) {
                State s = (State)iter.next();
                if (s == parent1) {
                    return 1;
                }
                if (s != parent2) continue;
                return -1;
            }
        }
        return tc2 - tc1;
    }

    private int countChainLength(TransitionTarget tt) {
        int count = 0;
        for (TransitionTarget parent = tt.getParent(); parent != null; parent = parent.getParent()) {
            ++count;
        }
        return count;
    }
}

